/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser.picker;

import com.swimap.iview.templates.colorchooser.picker.ColorComboBoxPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class ColorComboBox
extends JComboBox {
    private Component parent = null;

    public ColorComboBox() {
        this.setRenderer(new ColorRenderer());
    }

    @Override
    public void updateUI() {
        this.setUI(new MetalColorComboBoxUI());
    }

    void fireActionListener() {
        super.fireActionEvent();
    }

    public Color getColor() {
        return this.getForeground();
    }

    public void setColor(Color color) {
        this.setForeground(color);
    }

    public void setColorChooserParent(Component component) {
        this.parent = component;
    }

    Component getColorChooserParent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    private final class ColorIcon
    implements Icon {
        private Color color = null;
        private int h = 10;
        private int w = 0;
        private JLabel label;

        public ColorIcon(JLabel jLabel) {
            this.label = jLabel;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.GRAY);
            this.w = this.label.getSize().width - 5;
            graphics.drawRect(n += 4, n2, this.w - 1, this.h - 1);
            graphics.setColor(this.color);
            graphics.fillRect(n + 1, n2 + 1, this.w - 2, this.h - 2);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }
    }

    private final class ColorRenderer
    extends JLabel
    implements ListCellRenderer {
        private ColorIcon icon;

        private ColorRenderer() {
            this.icon = new ColorIcon(this);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color = ColorComboBox.this.getColor();
            this.icon.setColor(color);
            this.setIcon(this.icon);
            return this;
        }
    }

    private static class MetalColorComboBoxUI
    extends MetalComboBoxUI {
        private MetalColorComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return new MetalColorComboBoxUI();
        }

        @Override
        protected ComboPopup createPopup() {
            return new ColorComboBoxPopup((ColorComboBox)this.comboBox);
        }
    }
}

