/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser.picker;

import com.swimap.iview.commstyle.commini.BorderlessButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class ColorButton
extends BorderlessButton {
    private static final int BORDER_SIZE = 18;
    private static final Color COLORICON_BORDER_COLOR = new Color(172, 168, 153);
    private final Dimension prefferedSize = new Dimension(18, 18);
    private boolean selected = false;
    private Color value;

    ColorButton(Color color) {
        this.value = color;
        if (color == null) {
            throw new IllegalArgumentException("null arg.");
        }
        this.setSize(this.prefferedSize);
        this.setMinimumSize(this.prefferedSize);
        this.setMaximumSize(this.prefferedSize);
        this.setPreferredSize(this.prefferedSize);
        this.setIcon(new ColorIcon(color));
        this.setUI(new ButtonUI());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.selected) {
            graphics.setColor(UIManager.getColor("ToolbarButton.borderColor"));
            graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
        }
    }

    final void setButtonSelected(boolean bl) {
        this.selected = bl;
    }

    final Color getSelectedColor() {
        return this.value;
    }

    static /* synthetic */ Color access$100() {
        return COLORICON_BORDER_COLOR;
    }

    private final class ColorIcon
    implements Icon {
        private static final int SIZE = 12;
        private final Color borderColor = ColorButton.access$100();
        private Color fillColor = Color.WHITE;

        public ColorIcon(Color color) {
            this.fillColor = color;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = (component.getWidth() - 12) / 2;
            int n4 = (component.getHeight() - 12) / 2;
            graphics.setColor(this.borderColor);
            graphics.drawRect(n3, n4, 11, 11);
            graphics.setColor(this.fillColor);
            graphics.fillRect(n3 + 1, n4 + 1, 10, 10);
        }
    }

    protected class ButtonUI
    extends BorderlessButton.ToolBarButtonUI {
        protected ButtonUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            if (ColorButton.this.selected) {
                graphics.setColor(UIManager.getColor("ToolbarButton.reoverBackground"));
                graphics.fillRect(0, 0, ColorButton.this.getBounds().width - 1, ColorButton.this.getBounds().height - 1);
            }
            super.paint(graphics, jComponent);
        }
    }
}

