/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser.colorgrid;

import com.swimap.iview.templates.colorchooser.BasicColorChooserPanel;
import com.swimap.iview.templates.colorchooser.colorgrid.ColorGridTableCellRenderer;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ColorGridTable
extends JTable
implements FocusListener,
MouseListener {
    protected int selectedRow = 0;
    protected int selectedCol = 0;
    private BasicColorChooserPanel basicColorChooserPanel = null;
    private boolean needSelect = true;
    private static final int GRID_CELL_HEIGHT = 21;

    public ColorGridTable(int n, int n2) {
        super(n, n2);
        this.init();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setColor(int n, int n2, int n3, int n4, int n5) {
        Color color = new Color(n3, n4, n5);
        this.setColor(n, n2, color);
    }

    public void setColor(int n, int n2, Color color) {
        this.setValueAt(color, n, n2);
    }

    public void installChooserPanel(BasicColorChooserPanel basicColorChooserPanel) {
        this.basicColorChooserPanel = basicColorChooserPanel;
        basicColorChooserPanel.addColorGridTable(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Iterator iterator = this.basicColorChooserPanel.getColorGridTables().iterator();
        ColorGridTable colorGridTable = null;
        while (iterator.hasNext()) {
            colorGridTable = (ColorGridTable)iterator.next();
            if (this == colorGridTable) continue;
            colorGridTable.clearSelection();
        }
        if (this.needSelect) {
            this.selectCell();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setSelInfo(this.getSelectedRow(), this.getSelectedColumn());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.needSelect = false;
            Point point = mouseEvent.getPoint();
            Color color = (Color)this.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point));
            this.setColor(color != null ? color : Color.white);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.needSelect = true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void setSelInfo(int n, int n2) {
        this.selectedRow = n;
        this.selectedCol = n2;
    }

    boolean isSelChanged(int n, int n2) {
        return n != this.selectedRow || n2 != this.selectedCol;
    }

    void setColor(Color color) {
        if (this.basicColorChooserPanel != null) {
            this.basicColorChooserPanel.setChooserColor(color);
        }
    }

    Color getChooserColor() {
        Color color = null;
        if (this.basicColorChooserPanel != null) {
            color = this.basicColorChooserPanel.getChooserColor();
        }
        return color;
    }

    private void selectCell() {
        this.selectedRow = this.selectedRow < 0 ? 0 : this.selectedRow;
        this.selectedCol = this.selectedCol < 0 ? 0 : this.selectedCol;
        this.setRowSelectionInterval(this.selectedRow, this.selectedRow);
        this.setColumnSelectionInterval(this.selectedCol, this.selectedCol);
    }

    private void init() {
        this.setRowHeight(21);
        this.setGridColor((Color)UIManager.get("Panel.background"));
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new ColorGridTableCellRenderer());
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    Object object = ColorGridTable.this.getValueAt(ColorGridTable.this.getSelectedRow(), ColorGridTable.this.getSelectedColumn());
                    ColorGridTable.this.setColor(object instanceof Color ? (Color)object : Color.white);
                }
            }
        });
    }
}

