/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.templates.colorchooser.SyntheticImageGenerator;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

abstract class SyntheticImage
implements ImageProducer {
    private SyntheticImageGenerator root = null;
    private static final int WIDTH = 10;
    private static final int HEIGHT = 100;
    protected int width = 10;
    protected int height = 100;
    static final ColorModel cm = ColorModel.getRGBdefault();
    public static final int pixMask = 255;
    protected volatile boolean aborted = false;

    protected SyntheticImage() {
    }

    protected SyntheticImage(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected void computeRow(int n, int[] nArray) {
        int n2 = 255 - 255 * n / (this.height - 1);
        n2 = 0xFF000000 | n2 << 16 | n2 << 8 | n2;
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    @Override
    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                return;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
        this.root = new SyntheticImageGenerator(imageConsumer, this.root, this);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                return true;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
        return false;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        Object var2_2 = null;
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                syntheticImageGenerator.useful = false;
                this.root = syntheticImageGenerator.next;
                return;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
    }

    @Override
    public synchronized void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.useful && !syntheticImageGenerator.isAlive()) {
                syntheticImageGenerator.start();
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
    }

    protected boolean isStatic() {
        return true;
    }

    public void nextFrame(int n) {
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }
}

