/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.AbstractColorChooserPanel;
import com.swimap.iview.templates.colorchooser.BasicColorChooserPanel;
import com.swimap.iview.templates.colorchooser.ColorChooser;
import com.swimap.iview.templates.colorchooser.HSLChooserPanel;
import com.swimap.iview.templates.colorchooser.PreviewPanel;
import com.swimap.iview.templates.colorchooser.RGBChooserPanel;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;

public class SwimapColorChooserUI
extends ColorChooserUI {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private ColorChooser chooser;
    private AbstractColorChooserPanel HSLChooserPanel;
    private AbstractColorChooserPanel RGBChooserPanel;
    private AbstractColorChooserPanel basicColorChooserPanel;
    private AbstractColorChooserPanel previewPanel;
    private JPanel panelLeft;
    private JPanel panelRight;
    private JButton addToCusButton;
    private JButton defineButton;
    private JButton okButton;
    private JButton cancelButton;
    private static final int DEFINE_BUTTON_WIDTH = 195;
    private static final int CUS_BUTTON_WIDTH = 236;
    private static final int BUTTON_HEIGHT = 21;
    private ActionListener addToCusTableAct = null;
    private ActionListener showDefPanelAct = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapColorChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.chooser = (ColorChooser)jComponent;
        super.installUI(jComponent);
        this.createDefaultChoosers();
        this.setPanelsToChooser();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaultChoosers();
        this.uninstallListeners();
    }

    private void createDefaultChoosers() {
        this.RGBChooserPanel = new RGBChooserPanel(this.chooser);
        this.HSLChooserPanel = new HSLChooserPanel(this.chooser);
        this.basicColorChooserPanel = new BasicColorChooserPanel(this.chooser);
        this.previewPanel = new PreviewPanel(this.chooser);
    }

    private void uninstallDefaultChoosers() {
        this.HSLChooserPanel.uninstallChooserPanel();
        this.RGBChooserPanel.uninstallChooserPanel();
        this.basicColorChooserPanel.uninstallChooserPanel();
        this.previewPanel.uninstallChooserPanel();
        this.chooser.remove(this.HSLChooserPanel);
        this.chooser.remove(this.RGBChooserPanel);
        this.chooser.remove(this.basicColorChooserPanel);
        this.chooser.remove(this.previewPanel);
        this.chooser.removeComponents();
    }

    private void setPanelsToChooser() {
        this.chooser.setLayout(new FlowLayout(0, 0, 0));
        this.intLeftPanel();
        this.intRightPanel();
        this.chooser.add(this.panelLeft);
        this.chooser.add(this.panelRight);
    }

    private void intLeftPanel() {
        this.panelLeft = new JPanel(new FlowLayout(1, 6, 6));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.basicColorChooserPanel, "North");
        JPanel jPanel2 = this.defButtonPanelCreator();
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 2, 0));
        this.okButton = this.chooser.getOkButton();
        this.okButton.setName("SwimapColorChooserUI_okButton");
        this.cancelButton = this.chooser.getCancelButton();
        this.cancelButton.setName("SwimapColorChooserUI_cancelButton");
        ScreenToolKit.setDefaultButtons(this.okButton, this.cancelButton);
        ScreenToolKit.setPreferredSizeofButtons(new JButton[]{this.okButton, this.cancelButton}, 21);
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        jPanel.add((Component)jPanel3, "South");
        this.panelLeft.add(jPanel);
    }

    private void intRightPanel() {
        this.panelRight = this.chooser.getPanelRight();
        this.panelRight.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                ((HSLChooserPanel)SwimapColorChooserUI.this.HSLChooserPanel).modifyState(true);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                ((HSLChooserPanel)SwimapColorChooserUI.this.HSLChooserPanel).modifyState(false);
            }
        });
        this.panelRight.setLayout(new BorderLayout(0, 0));
        this.panelRight.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(0, 2), "North");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(8, 0), "West");
        jPanel.add((Component)this.HSLChooserPanel, "Center");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(2, 0), "East");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(0, 1), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel3 = this.preAndTextPanelCreator();
        JPanel jPanel4 = this.cusButtonPanelCreator();
        jPanel2.add((Component)SwimapColorChooserUI.blankLabelCreator(8, 0), "West");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)SwimapColorChooserUI.blankLabelCreator(8, 0), "East");
        jPanel2.add((Component)jPanel4, "South");
        this.panelRight.add((Component)jPanel, "North");
        this.panelRight.add((Component)jPanel2, "South");
    }

    private JPanel defButtonPanelCreator() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.defineButton = this.chooser.getDefineButton();
        this.defineButton.setName("SwimapColorChooserUI_defineButton");
        this.defineButton.setPreferredSize(new Dimension(195, 21));
        this.defineButton.setMnemonic('D');
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(0, 8), "North");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(2, 0), "West");
        jPanel.add((Component)this.defineButton, "Center");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(2, 0), "East");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(0, 8), "South");
        return jPanel;
    }

    private JPanel preAndTextPanelCreator() {
        JPanel jPanel = new JPanel(new BorderLayout(2, 0));
        jPanel.add((Component)this.RGBChooserPanel, "East");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(((HSLChooserPanel)this.HSLChooserPanel).getHslControlor());
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(this.previewPanel);
        jPanel.add((Component)this.previewPanel, "West");
        return jPanel;
    }

    private JPanel cusButtonPanelCreator() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.addToCusButton = new JButton(res.getString("Add"));
        this.addToCusButton.setName("SwimapColorChooserUI_addToCusButton");
        this.addToCusButton.setPreferredSize(new Dimension(236, 21));
        this.addToCusButton.setMnemonic('A');
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(0, 4), "North");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(8, 0), "West");
        jPanel.add(this.addToCusButton);
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(8, 0), "East");
        jPanel.add((Component)SwimapColorChooserUI.blankLabelCreator(0, 6), "South");
        return jPanel;
    }

    private void installListeners() {
        this.addToCusTableAct = new AddToCusTableAct();
        this.showDefPanelAct = new ShowDefPanelAct();
        this.defineButton.addActionListener(this.showDefPanelAct);
        this.addToCusButton.addActionListener(this.addToCusTableAct);
    }

    private void uninstallListeners() {
        this.defineButton.removeActionListener(this.showDefPanelAct);
        this.addToCusButton.removeActionListener(this.addToCusTableAct);
    }

    private static JLabel blankLabelCreator(int n, int n2) {
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private class AddToCusTableAct
    implements ActionListener {
        private AddToCusTableAct() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((BasicColorChooserPanel)SwimapColorChooserUI.this.basicColorChooserPanel).getCustomColorChooserTable().updateColor(SwimapColorChooserUI.this.chooser.getColor());
        }
    }

    private class ShowDefPanelAct
    implements ActionListener {
        private ShowDefPanelAct() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwimapColorChooserUI.this.defineButton.setEnabled(false);
            ((HSLChooserPanel)SwimapColorChooserUI.this.HSLChooserPanel).getHslControlor().requestFocus();
        }
    }
}

