/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.AbstractColorChooserPanel;
import com.swimap.iview.templates.colorchooser.ColorChooser;
import com.swimap.iview.templates.colorchooser.ColorTextField;
import com.swimap.iview.templates.colorchooser.SmartGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class RGBChooserPanel
extends AbstractColorChooserPanel {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private ColorTextField redField;
    private ColorTextField greenField;
    private ColorTextField blueField;
    private boolean isAdjusting = false;
    private static final int MAX_RGB_VALUE = 255;
    private static final int MIN_RGB_VALUE = 0;

    RGBChooserPanel(ColorChooser colorChooser) {
        super(colorChooser);
    }

    @Override
    public void uninstallChooserPanel() {
        super.uninstallChooserPanel();
        this.removeAll();
    }

    @Override
    protected void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            Color color = this.getColorFromModel();
            this.updateRGBTextFields(color);
            this.isAdjusting = false;
        }
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        JComponent jComponent = this.buildRGBControls();
        this.add((Component)jComponent, "Center");
    }

    private void updateRGBTextFields(Color color) {
        this.redField.setText(String.valueOf(color.getRed()));
        this.greenField.setText(String.valueOf(color.getGreen()));
        this.blueField.setText(String.valueOf(color.getBlue()));
    }

    private JComponent buildRGBControls() {
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        Color color = this.getColorFromModel();
        this.redField = new RGBTextField(0, 255, String.valueOf(color.getRed()), 2);
        this.redField.setName("RGBChooserPanel_redField");
        this.greenField = new RGBTextField(0, 255, String.valueOf(color.getGreen()), 2);
        this.greenField.setName("RGBChooserPanel_greenField");
        this.blueField = new RGBTextField(0, 255, String.valueOf(color.getBlue()), 2);
        this.blueField.setName("RGBChooserPanel_blueField");
        String string = res.getString("Red");
        String string2 = res.getString("Green");
        String string3 = res.getString("Blue");
        ColorTextField.addColorInfo(jPanel, string, this.redField, 'R');
        ColorTextField.addColorInfo(jPanel, string2, this.greenField, 'G');
        ColorTextField.addColorInfo(jPanel, string3, this.blueField, 'U');
        return jPanel;
    }

    private class RGBTextField
    extends ColorTextField {
        RGBTextField(int n, int n2, String string, int n3) {
            super(n, n2, string, n3);
        }

        @Override
        public void UpdateText() {
            if (!RGBChooserPanel.this.isAdjusting) {
                RGBChooserPanel.this.isAdjusting = true;
                int n = Integer.parseInt(RGBChooserPanel.this.redField.getText());
                int n2 = Integer.parseInt(RGBChooserPanel.this.greenField.getText());
                int n3 = Integer.parseInt(RGBChooserPanel.this.blueField.getText());
                Color color = new Color(n, n2, n3);
                RGBChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
                RGBChooserPanel.this.isAdjusting = false;
            }
        }
    }
}

