/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.AbstractColorChooserPanel;
import com.swimap.iview.templates.colorchooser.ColorChooser;
import com.swimap.iview.templates.colorchooser.ColorSlider;
import com.swimap.iview.templates.colorchooser.ColorTextField;
import com.swimap.iview.templates.colorchooser.Converter;
import com.swimap.iview.templates.colorchooser.ImageBorder;
import com.swimap.iview.templates.colorchooser.SmartGridLayout;
import com.swimap.iview.templates.colorchooser.SyntheticImage;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class HSLChooserPanel
extends AbstractColorChooserPanel {
    private static IviewLogger logger = IviewLogger.getLogger(HSLChooserPanel.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private HSLImage palette;
    private HSLImage sliderPalette;
    private Image paletteImage;
    private Image sliderPaletteImage;
    private JSlider slider;
    private boolean isAdjusting = false;
    private Point paletteSelection;
    private JLabel paletteLabel;
    private JLabel sliderPaletteLabel;
    private ColorTextField hField;
    private ColorTextField sField;
    private ColorTextField lField;
    private JComponent hslControlor;
    private static final int PALETTE_DIMENSION_X = 200;
    private static final int PALETTE_DIMENSION_Y = 174;
    private static final int SLIDER_PALETTE_DIMENSION_X = 24;
    private static final int MAX_HUE_VALUE = 240;
    private static final int MAX_SATURATION_VALUE = 240;
    private static final int MAX_LUM_VALUE = 240;
    private static final int SLIDER_SPACE = 10;
    private static final int PALETTE_SLDER_SPACE = 12;
    private static final int SLIDER_LUM_PALETTE_SPACE = 1;

    HSLChooserPanel(ColorChooser colorChooser) {
        super(colorChooser);
    }

    @Override
    public void uninstallChooserPanel() {
        super.uninstallChooserPanel();
        this.cleanupPalettesIfNecessary();
        this.removeAll();
    }

    public JComponent getHslControlor() {
        return this.hslControlor;
    }

    @Override
    protected void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.initializePalettesIfNecessary();
            float[] fArray = this.getHSLColorFromModel();
            this.updateHSL(fArray[0], fArray[1], fArray[2]);
            this.isAdjusting = false;
        }
    }

    @Override
    protected void buildChooser() {
        this.hslControlor = this.buildHSLControls();
        this.paletteSelection = new Point();
        this.setLayout(new FlowLayout(1, 0, 0));
        JComponent jComponent = this.buildSliderPalettePanel();
        this.add((Component)jComponent, "Before");
    }

    void modifyState(boolean bl) {
        if (bl) {
            this.initializePalettesIfNecessary();
        } else {
            this.cleanupPalettesIfNecessary();
        }
    }

    private JComponent buildSliderPalettePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        this.slider = new ColorSlider(1, 0, 240, 0);
        this.slider.setFocusable(false);
        this.slider.setInverted(true);
        this.slider.setPaintTrack(false);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, 184));
        this.slider.setName("HSLChooserPanel_slider");
        this.addSliderListeners();
        this.paletteLabel = this.createPaletteLabel();
        this.paletteLabel.setName("HSLChooserPanel_palettelabel");
        this.addPaletteListeners();
        this.sliderPaletteLabel = new JLabel();
        this.sliderPaletteLabel.setName("HSLChooserPanel_sliderPaletteLabel");
        this.addSliderAjustListeners(this.sliderPaletteLabel);
        this.addSliderAjustListeners(this.slider);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 1, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 1, 1));
        ImageBorder imageBorder = new ImageBorder();
        jPanel2.setBorder(imageBorder);
        jPanel3.setBorder(imageBorder);
        jPanel2.add(this.paletteLabel);
        jPanel3.add(this.sliderPaletteLabel);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(12, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(new Dimension(1, 0));
        jPanel.add(jPanel2);
        jPanel.add(jLabel);
        jPanel.add(jPanel3);
        jPanel.add(jLabel2);
        jPanel.add(this.slider);
        this.initializePalettesIfNecessary();
        return jPanel;
    }

    private void updateHSL(float f, float f2, float f3) {
        this.updatePalette(f, f2);
        this.updateSlider(f3);
        this.updateSliderPalette(f, f2, f3);
        this.palette.setValues(0, f, f2, f3);
        this.sliderPalette.setValues(1, f, f2, f3);
        this.updateHSLTextFields(f, f2, f3);
    }

    private void addSliderListeners() {
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!HSLChooserPanel.this.isAdjusting) {
                    int n = HSLChooserPanel.this.slider.getValue();
                    int n2 = HSLChooserPanel.this.slider.getMaximum();
                    float f = 1.0f - (float)n / (float)n2;
                    HSLChooserPanel.this.updateHSL(HSLChooserPanel.this.palette.getHue(), HSLChooserPanel.this.palette.getSaturation(), f);
                }
            }
        });
    }

    private void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    float[] fArray = new float[3];
                    HSLChooserPanel.this.palette.getHSL(mouseEvent.getX(), mouseEvent.getY(), fArray);
                    HSLChooserPanel.this.updateHSL(fArray[0], fArray[1], fArray[2]);
                }
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = HSLChooserPanel.this.paletteLabel.getWidth();
                    int n2 = HSLChooserPanel.this.paletteLabel.getHeight();
                    int n3 = mouseEvent.getX();
                    int n4 = mouseEvent.getY();
                    if (n3 >= n) {
                        n3 = n;
                    }
                    if (n4 >= n2) {
                        n4 = n2;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    float[] fArray = new float[3];
                    HSLChooserPanel.this.palette.getHSL(n3, n4, fArray);
                    HSLChooserPanel.this.updateHSL(fArray[0], fArray[1], fArray[2]);
                }
            }
        });
    }

    private void addSliderAjustListeners(final JComponent jComponent) {
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HSLChooserPanel.this.adjustSlider(jComponent, mouseEvent);
            }
        });
        jComponent.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    HSLChooserPanel.this.adjustSlider(jComponent, mouseEvent);
                }
            }
        });
    }

    private void adjustSlider(JComponent jComponent, MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = mouseEvent.getY();
            int n2 = jComponent.getHeight();
            int n3 = Math.round((float)n / (float)n2 * (float)this.slider.getMaximum());
            this.slider.setValue(n3);
        }
    }

    private void initializePalettesIfNecessary() {
        if (this.palette != null) {
            return;
        }
        float[] fArray = this.getHSLColorFromModel();
        this.palette = new HSLImage(0, 200, 174, fArray[0], fArray[1], fArray[2]);
        this.sliderPalette = new HSLImage(1, 24, 174, fArray[0], fArray[1], fArray[2]);
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderPaletteImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderPaletteImage));
    }

    private void cleanupPalettesIfNecessary() {
        if (this.palette == null) {
            return;
        }
        this.palette.aborted = true;
        this.sliderPalette.aborted = true;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.palette = null;
        this.sliderPalette = null;
        this.paletteImage = null;
        this.sliderPaletteImage = null;
        this.paletteLabel.setIcon(null);
        this.sliderPaletteLabel.setIcon(null);
    }

    private JLabel createPaletteLabel() {
        return new JLabel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setColor(Color.white);
                graphics.drawOval(((HSLChooserPanel)HSLChooserPanel.this).paletteSelection.x - 4, ((HSLChooserPanel)HSLChooserPanel.this).paletteSelection.y - 4, 8, 8);
            }
        };
    }

    private void updatePalette(float f, float f2) {
        int n = Math.round(f * 200.0f);
        int n2 = 174 - Math.round(f2 * 174.0f);
        this.paletteSelection.setLocation(n, n2);
        this.paletteLabel.repaint();
    }

    private void updateSlider(float f) {
        float f2 = f;
        this.slider.setValue((int)((1.0f - f2) * (float)this.slider.getMaximum()));
    }

    private void updateSliderPalette(float f, float f2, float f3) {
        this.sliderPalette.nextFrame();
    }

    private void updateHSLTextFields(float f, float f2, float f3) {
        this.hField.setText(String.valueOf((int)(f * 240.0f)));
        this.sField.setText(String.valueOf((int)(f2 * 240.0f)));
        this.lField.setText(String.valueOf((int)(f3 * 240.0f)));
    }

    private JComponent buildHSLControls() {
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        String string = res.getString("Hue");
        String string2 = res.getString("Sat");
        String string3 = res.getString("Lum");
        float[] fArray = this.getHSLColorFromModel();
        this.hField = new HSLTextField(0, 239, String.valueOf(Math.round(fArray[0] * 240.0f)), 2);
        this.hField.setName("HSLChooserPanel_hField");
        this.sField = new HSLTextField(0, 240, String.valueOf(Math.round(fArray[1] * 240.0f)), 2);
        this.sField.setName("HSLChooserPanel_sField");
        this.lField = new HSLTextField(0, 240, String.valueOf(Math.round(fArray[2] * 240.0f)), 2);
        this.lField.setName("HSLChooserPanel_lField");
        ColorTextField.addColorInfo(jPanel, string, this.hField, 'E');
        ColorTextField.addColorInfo(jPanel, string2, this.sField, 'S');
        ColorTextField.addColorInfo(jPanel, string3, this.lField, 'L');
        jPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                HSLChooserPanel.this.hField.requestFocus();
            }
        });
        return jPanel;
    }

    private float[] getHSLColorFromModel() {
        Color color = this.getColorFromModel();
        float[] fArray = new float[3];
        Converter.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray;
    }

    private class HSLImage
    extends SyntheticImage {
        private static final float MIN_LIMIT_VALUE = 0.0f;
        private static final float MAX_LIMIT_VALUE = 1.0f;
        private static final float DEFALUT_LIGHTENESS_VALUE = 0.5f;
        protected float h;
        protected float s;
        protected float l;
        protected float[] hsl;
        protected boolean isDirty;
        protected int cachedColor;
        protected int type;
        private static final int SQUARE = 0;
        private static final int SLIDER = 1;

        protected HSLImage(int n, int n2, int n3, float f, float f2, float f3) {
            super(n2, n3);
            this.h = 0.0f;
            this.s = 0.0f;
            this.l = 0.0f;
            this.hsl = new float[3];
            this.isDirty = true;
            this.cachedColor = 0;
            this.type = 0;
            this.setValues(n, f, f2, f3);
        }

        public void setValues(int n, float f, float f2, float f3) {
            this.type = n;
            this.cachedColor = 0;
            this.setHue(f);
            this.setSaturation(f2);
            this.setLum(f3);
        }

        public final void setHue(float f) {
            this.h = f;
            this.hsl[0] = f;
        }

        public final void setSaturation(float f) {
            this.s = f;
            this.hsl[1] = f;
        }

        public final void setLum(float f) {
            this.l = f;
            this.hsl[2] = f;
        }

        public final float getHue() {
            return this.h;
        }

        public final float getSaturation() {
            return this.s;
        }

        public final float getLum() {
            return this.l;
        }

        @Override
        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame() {
            this.isDirty = true;
            this.notifyAll();
        }

        @Override
        public synchronized void addConsumer(ImageConsumer imageConsumer) {
            this.isDirty = true;
            super.addConsumer(imageConsumer);
        }

        private int getRGBForLocation(int n, int n2) {
            this.getHSLForLocation(n, n2, this.hsl);
            this.cachedColor = Converter.HSLtoRGB(this.hsl[0], this.hsl[1], this.hsl[2]);
            return this.cachedColor;
        }

        public void getHSLForLocation(int n, int n2, float[] fArray) {
            if (this.type == 0) {
                float f = (float)n2 / (float)this.height;
                float f2 = 0.99583334f / (float)this.width;
                fArray[0] = (float)n * f2;
                fArray[1] = 1.0f - f;
                fArray[2] = 0.5f;
            } else {
                float f = (float)n2 / (float)this.height;
                fArray[0] = this.h;
                fArray[1] = this.s;
                fArray[2] = 1.0f - f;
            }
        }

        public void getHSL(int n, int n2, float[] fArray) {
            if (this.type == 0) {
                float f = (float)n2 / (float)this.height;
                float f2 = 0.99583334f / (float)this.width;
                fArray[0] = (float)n * f2;
                fArray[1] = 1.0f - f;
                fArray[2] = this.l;
            } else {
                float f = (float)n2 / (float)this.height;
                fArray[0] = this.h;
                fArray[1] = this.s;
                fArray[2] = 1.0f - f;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void computeRow(int n, int[] nArray) {
            if (n == 0) {
                HSLImage hSLImage = this;
                synchronized (hSLImage) {
                    try {
                        while (!this.isDirty) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        logger.trace(interruptedException.getMessage(), interruptedException);
                    }
                    this.isDirty = false;
                }
            }
            if (this.aborted) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.getRGBForLocation(i, n);
            }
        }
    }

    private class HSLTextField
    extends ColorTextField {
        HSLTextField(int n, int n2, String string, int n3) {
            super(n, n2, string, n3);
        }

        @Override
        public void UpdateText() {
            if (!HSLChooserPanel.this.isAdjusting) {
                HSLChooserPanel.this.isAdjusting = true;
                float f = (float)Integer.parseInt(HSLChooserPanel.this.hField.getText()) / 240.0f;
                float f2 = (float)Integer.parseInt(HSLChooserPanel.this.sField.getText()) / 240.0f;
                float f3 = (float)Integer.parseInt(HSLChooserPanel.this.lField.getText()) / 240.0f;
                Color color = Converter.getHSLColor(f, f2, f3);
                HSLChooserPanel.this.updatePalette(f, f2);
                HSLChooserPanel.this.updateSlider(f3);
                HSLChooserPanel.this.updateSliderPalette(f, f2, f3);
                HSLChooserPanel.this.palette.setHue(f);
                HSLChooserPanel.this.palette.setSaturation(f2);
                HSLChooserPanel.this.palette.setLum(f3);
                HSLChooserPanel.this.sliderPalette.setHue(f);
                HSLChooserPanel.this.sliderPalette.setSaturation(f2);
                HSLChooserPanel.this.sliderPalette.setLum(f3);
                HSLChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
                HSLChooserPanel.this.isAdjusting = false;
            }
        }
    }
}

