/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import java.awt.Color;

public class Converter {
    private static final float EXACT_MAX_RGB_VALUE = 255.0f;
    private static final int MAX_RGB_VALUE = 255;

    public static void RGBtoHSL(int n, int n2, int n3, float[] fArray) {
        float f = (float)n / 255.0f;
        float f2 = (float)n2 / 255.0f;
        float f3 = (float)n3 / 255.0f;
        float f4 = Math.min(Math.min(f, f2), f3);
        float f5 = Math.max(Math.max(f, f2), f3);
        float f6 = f5 - f4;
        float f7 = (f5 + f4) / 2.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (f6 == 0.0f) {
            f8 = 0.0f;
            f9 = 0.0f;
        } else {
            f9 = (double)f7 < 0.5 ? f6 / (f5 + f4) : f6 / (2.0f - f5 - f4);
            float f10 = ((f5 - f) / 6.0f + f6 / 2.0f) / f6;
            float f11 = ((f5 - f2) / 6.0f + f6 / 2.0f) / f6;
            float f12 = ((f5 - f3) / 6.0f + f6 / 2.0f) / f6;
            if (Float.floatToIntBits(f) == Float.floatToIntBits(f5)) {
                f8 = f12 - f11;
            } else if (Float.floatToIntBits(f2) == Float.floatToIntBits(f5)) {
                f8 = 0.33333334f + f10 - f12;
            } else if (Float.floatToIntBits(f3) == Float.floatToIntBits(f5)) {
                f8 = 0.6666667f + f11 - f10;
            }
            float f13 = 0.0020833334f;
            f8 += f13;
            if (f8 < 0.0f) {
                f8 += 1.0f;
            }
            if (f8 >= 1.0f) {
                f8 -= 1.0f;
            }
        }
        fArray[0] = f8;
        fArray[1] = f9;
        fArray[2] = f7;
    }

    public static int HSLtoRGB(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Color color = Converter.getHSLColor(f, f2, f3);
        n = color.getRed();
        n2 = color.getGreen();
        n3 = color.getBlue();
        return 0xFF000000 | n << 16 | n2 << 8 | n3 << 0;
    }

    public static Color getHSLColor(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        Color color = null;
        if (f2 == 0.0f) {
            f4 = f3 * 255.0f;
            f5 = f3 * 255.0f;
            f6 = f3 * 255.0f;
        } else {
            float f7 = 0.0f;
            float f8 = 0.0f;
            f7 = (double)f3 < 0.5 ? f3 * (1.0f + f2) : f3 + f2 - f2 * f3;
            f8 = 2.0f * f3 - f7;
            f4 = 255.0f * Converter.Hue_2_RGB(f8, f7, f + 0.33333334f);
            f5 = 255.0f * Converter.Hue_2_RGB(f8, f7, f);
            f6 = 255.0f * Converter.Hue_2_RGB(f8, f7, f - 0.33333334f);
        }
        n = Math.round(f4);
        n2 = Math.round(f5);
        n3 = Math.round(f6);
        try {
            color = new Color(n, n2, n3);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Color parameter outside of expected range:");
        }
        return color;
    }

    private static float Hue_2_RGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }
}

