/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.templates.textfield.IntegerTextField;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class ColorTextField
extends IntegerTextField
implements FocusListener,
DocumentListener,
MouseListener {
    private static IviewLogger logger = IviewLogger.getLogger(ColorTextField.class, "IVIEW");
    private int val = 0;
    private boolean needSelect = true;

    ColorTextField(int n, int n2, String string, int n3) {
        super(n, n2);
        this.setText(string);
        this.setColumns(n3);
        this.addFocusListener(this);
        this.getDocument().addDocumentListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() != 0) {
            this.setValue(documentEvent);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() != 0) {
            this.setValue(documentEvent);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() != 0) {
            this.setValue(documentEvent);
        }
    }

    public void setValue(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        try {
            this.val = Integer.parseInt(document.getText(0, documentEvent.getDocument().getLength()));
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.UpdateText();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof IntegerTextField && this.needSelect) {
            IntegerTextField integerTextField = (IntegerTextField)focusEvent.getSource();
            integerTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        IntegerTextField integerTextField = (IntegerTextField)focusEvent.getSource();
        if (integerTextField.getDocument().getLength() == 0) {
            integerTextField.setText(String.valueOf(this.val));
        }
        this.needSelect = !focusEvent.isTemporary();
    }

    public void UpdateText() {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.needSelect = false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.needSelect = true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public static void addColorInfo(Container container, String string, ColorTextField colorTextField, char c) {
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(c);
        jLabel.setLabelFor(colorTextField);
        jLabel.setHorizontalAlignment(4);
        container.add(jLabel);
        container.add(colorTextField);
    }
}

