/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.ColorChooser;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;

final class ColorChooserDialog
extends JDialog {
    private static ResourceBundle resBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private Color initialColor = null;
    private ColorChooser colorChooser = null;
    private static final int INIT_WIDTH = 220;
    private static final int WHOLE_WIDTH = 480;

    ColorChooserDialog(Component component, String string, boolean bl, final ColorChooser colorChooser, ActionListener actionListener, ActionListener actionListener2) throws HeadlessException {
        super(JOptionPane.getFrameForComponent(component), string == null ? resBundle.getString("Title") : string, bl);
        this.getContentPane().setLayout(new FlowLayout(0, 0, 0));
        this.colorChooser = colorChooser;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)colorChooser, "Center");
        JButton jButton = colorChooser.getOkButton();
        this.getRootPane().setDefaultButton(jButton);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        JButton jButton2 = colorChooser.getCancelButton();
        if (actionListener2 != null) {
            jButton2.addActionListener(actionListener2);
        }
        this.initButtonListeners();
        ScreenToolKit.setDefaultButtons(colorChooser.defaultComp, (AbstractButton)jButton, (AbstractButton)jButton2);
        this.applyComponentOrientation((component == null ? this.getRootPane() : component).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(component);
        this.addWindowListener(new WindowCloseAct());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                super.windowActivated(windowEvent);
                colorChooser.setColor(colorChooser.getColor());
            }
        });
        this.setResizable(false);
    }

    @Override
    public void show() {
        this.initialColor = this.colorChooser.getColor();
        super.show();
    }

    public void reset() {
        this.colorChooser.setColor(this.initialColor);
    }

    private void initButtonListeners() {
        HideDialogAct hideDialogAct = new HideDialogAct();
        this.colorChooser.getOkButton().addActionListener(hideDialogAct);
        this.colorChooser.getCancelButton().addActionListener(hideDialogAct);
        this.colorChooser.getDefineButton().addActionListener(new ShowDefPanelAct());
    }

    private class ShowDefPanelAct
    implements ActionListener {
        private ShowDefPanelAct() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepaintManager.currentManager(ColorChooserDialog.this.getRootPane()).setDoubleBufferingEnabled(true);
            RepaintManager.currentManager(ColorChooserDialog.this).setDoubleBufferingEnabled(true);
            ColorChooserDialog.this.colorChooser.getPanelRight().setVisible(true);
            ColorChooserDialog.this.setSize(480, ColorChooserDialog.this.getHeight());
            ColorChooserDialog.this.validate();
        }
    }

    private class HideDialogAct
    implements ActionListener {
        private HideDialogAct() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepaintManager.currentManager(ColorChooserDialog.this.getRootPane()).setDoubleBufferingEnabled(true);
            RepaintManager.currentManager(ColorChooserDialog.this).setDoubleBufferingEnabled(true);
            ColorChooserDialog.this.colorChooser.getPanelRight().setVisible(false);
            ColorChooserDialog.this.hide();
            ColorChooserDialog.this.colorChooser.getDefineButton().setEnabled(true);
            ColorChooserDialog.this.setSize(220, ColorChooserDialog.this.getHeight());
            ColorChooserDialog.this.colorChooser.setColor(ColorChooserDialog.this.colorChooser.getColor());
        }
    }

    private class WindowCloseAct
    extends WindowAdapter {
        private WindowCloseAct() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ColorChooserDialog.this.colorChooser.getCancelButton().doClick();
        }
    }
}

