/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.ColorChooserDialog;
import com.swimap.iview.templates.colorchooser.ColorTracker;
import com.swimap.iview.templates.colorchooser.SwimapColorSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;

public class ColorChooser
extends JComponent
implements Accessible {
    JComponent[] defaultComp = NULL_ARRAY;
    static final String SET_COLOR = "set the color";
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private static final String uiClassID = "SwimapColorChooserUI";
    private JButton okButton = new JButton(res.getString("OK"));
    private JButton cancelButton = new JButton(res.getString("Cancel"));
    private JButton defineButton = new JButton(res.getString("Define"));
    private JPanel panelRight = new JPanel();
    private SwimapColorSelectionModel selectionModel;
    private static final JComponent[] NULL_ARRAY;

    public ColorChooser() {
        this(Color.white);
    }

    public ColorChooser(Color color) {
        this(new SwimapColorSelectionModel(color));
    }

    public ColorChooser(SwimapColorSelectionModel swimapColorSelectionModel) {
        this.selectionModel = swimapColorSelectionModel;
        this.updateUI();
    }

    public static Color showDialog(Component component, String string, Color color) throws HeadlessException {
        ColorChooser colorChooser = new ColorChooser(color != null ? color : Color.white);
        ColorTracker colorTracker = new ColorTracker(colorChooser);
        JDialog jDialog = ColorChooser.createDialog(component, string, true, colorChooser, colorTracker, null);
        jDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                Window window = (Window)componentEvent.getComponent();
                window.dispose();
            }
        });
        jDialog.show();
        return colorTracker.getColor();
    }

    public static JDialog createDialog(Component component, String string, boolean bl, ColorChooser colorChooser, ActionListener actionListener, ActionListener actionListener2) throws HeadlessException {
        ColorChooserDialog colorChooserDialog = new ColorChooserDialog(component, string, bl, colorChooser, actionListener, actionListener2);
        return colorChooserDialog;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    final JButton getDefineButton() {
        return this.defineButton;
    }

    final JPanel getPanelRight() {
        return this.panelRight;
    }

    public Color getColor() {
        return this.selectionModel.getSelectedColor();
    }

    public void setColor(Color color) {
        this.selectionModel.setSelectedColor(color);
        this.firePropertyChange(SET_COLOR, null, color);
    }

    public void setColor(int n, int n2, int n3) {
        this.setColor(new Color(n, n2, n3));
    }

    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    final void addComponents(JComponent jComponent) {
        if (null == this.defaultComp || this.defaultComp == NULL_ARRAY) {
            this.defaultComp = new JComponent[]{jComponent};
        } else {
            int n = this.defaultComp.length;
            JComponent[] jComponentArray = new JComponent[n + 1];
            System.arraycopy(this.defaultComp, 0, jComponentArray, 0, n);
            jComponentArray[n] = jComponent;
            this.defaultComp = jComponentArray;
        }
    }

    final void removeComponents() {
        this.defaultComp = NULL_ARRAY;
    }

    static {
        if (null == UIManager.get(uiClassID)) {
            UIManager.put(uiClassID, "com.swimap.iview.templates.colorchooser.SwimapColorChooserUI");
        }
        NULL_ARRAY = new JComponent[0];
    }
}

