/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.AbstractColorChooserPanel;
import com.swimap.iview.templates.colorchooser.ColorChooser;
import com.swimap.iview.templates.colorchooser.SmartGridLayout;
import com.swimap.iview.templates.colorchooser.colorgrid.ColorGridTable;
import com.swimap.iview.templates.colorchooser.colorgrid.CustomColorGridTable;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JLabel;

public final class BasicColorChooserPanel
extends AbstractColorChooserPanel {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private JLabel basicLabel;
    private JLabel customLabel;
    private ColorGridTable basicColorTable;
    private CustomColorGridTable customColorTable;
    private HashSet colorGridTables = new HashSet(2);
    private static final int DEFAULT_COMPONENT_WIDTH = 200;
    private static final int DEFAULT_GRID_HEIGHT = 21;
    private static final int SPACE_HEIGHT = 10;
    private static final int ROW_GRID_NUM = 8;
    private static final int CUSTOM_ROW_COUNT = 2;
    private static final int BASIC_ROW_COUNT = 6;
    private static final int DEFUALT_LABEL_HEIGHT = 16;

    public BasicColorChooserPanel(ColorChooser colorChooser) {
        super(colorChooser);
        colorChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("set the color") && BasicColorChooserPanel.this.basicColorTable != null) {
                    BasicColorChooserPanel.this.selectInitColor();
                    BasicColorChooserPanel.this.basicColorTable.requestFocus();
                }
            }
        });
        this.installChooserPanel();
    }

    public void addColorGridTable(ColorGridTable colorGridTable) {
        this.colorGridTables.add(colorGridTable);
    }

    public void removeColorGridTable(ColorGridTable colorGridTable) {
        this.colorGridTables.remove(colorGridTable);
    }

    public HashSet getColorGridTables() {
        return this.colorGridTables;
    }

    public void setChooserColor(Color color) {
        if (this.getColorSelectionModel() != null) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    public Color getChooserColor() {
        Color color = null;
        if (this.getColorSelectionModel() != null) {
            color = this.getColorSelectionModel().getSelectedColor();
        }
        return color;
    }

    @Override
    protected void updateChooser() {
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new SmartGridLayout(1, 5));
        this.basicLabel = new JLabel(res.getString("Basic_Colors"));
        this.basicLabel.setPreferredSize(new Dimension(200, 16));
        this.add(this.basicLabel);
        this.basicColorTable = new ColorGridTable(6, 8);
        this.initBasicColorTable();
        this.selectInitColor();
        this.basicColorTable.setPreferredSize(new Dimension(200, 126));
        this.add(this.basicColorTable);
        this.basicLabel.setDisplayedMnemonic('B');
        this.basicLabel.setLabelFor(this.basicColorTable);
        this.customLabel = new JLabel(" ");
        this.customLabel.setPreferredSize(new Dimension(200, 10));
        this.add(this.customLabel);
        this.customLabel = new JLabel(res.getString("Custom_Colors"));
        this.customLabel.setPreferredSize(new Dimension(200, 16));
        this.add(this.customLabel);
        this.customColorTable = new CustomColorGridTable(2, 8);
        this.customColorTable.setPreferredSize(new Dimension(200, 42));
        this.add(this.customColorTable);
        this.customLabel.setDisplayedMnemonic('C');
        this.customLabel.setLabelFor(this.customColorTable);
        this.addComponents(this.customColorTable);
        this.addComponents(this.basicColorTable);
    }

    CustomColorGridTable getCustomColorChooserTable() {
        return this.customColorTable;
    }

    private void installChooserPanel() {
        this.basicColorTable.installChooserPanel(this);
        this.basicColorTable.setName("BasicColorChooserPanel_basicColorTable");
        this.customColorTable.installChooserPanel(this);
        this.customColorTable.setName("BasicColorChooserPanel_customColorTable");
    }

    private void selectInitColor() {
        int n;
        int n2;
        Color color = this.getChooserColor() == null ? Color.white : this.getChooserColor();
        int n3 = this.basicColorTable.getColumnCount();
        int n4 = this.basicColorTable.getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (!this.basicColorTable.getValueAt(n, n2).equals(color)) continue;
                this.basicColorTable.setSelInfo(n, n2);
                return;
            }
        }
        if (null == this.customColorTable) {
            this.basicColorTable.setSelInfo(0, 0);
            return;
        }
        n2 = this.customColorTable.getRowCount();
        n = this.customColorTable.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (null == this.customColorTable.getValueAt(i, j) || !this.customColorTable.getValueAt(i, j).equals(color)) continue;
                this.customColorTable.requestFocus();
                this.customColorTable.setSelInfo(i, j);
                return;
            }
        }
        this.basicColorTable.setSelInfo(0, 0);
    }

    private void initBasicColorTable() {
        this.basicColorTable.setColor(0, 0, 255, 128, 128);
        this.basicColorTable.setColor(0, 1, 255, 255, 128);
        this.basicColorTable.setColor(0, 2, 128, 255, 128);
        this.basicColorTable.setColor(0, 3, 0, 255, 128);
        this.basicColorTable.setColor(0, 4, 128, 255, 255);
        this.basicColorTable.setColor(0, 5, 0, 128, 255);
        this.basicColorTable.setColor(0, 6, 255, 128, 192);
        this.basicColorTable.setColor(0, 7, 255, 128, 255);
        this.basicColorTable.setColor(1, 0, 255, 0, 0);
        this.basicColorTable.setColor(1, 1, 255, 255, 0);
        this.basicColorTable.setColor(1, 2, 128, 255, 0);
        this.basicColorTable.setColor(1, 3, 0, 255, 64);
        this.basicColorTable.setColor(1, 4, 0, 255, 255);
        this.basicColorTable.setColor(1, 5, 0, 128, 192);
        this.basicColorTable.setColor(1, 6, 128, 128, 192);
        this.basicColorTable.setColor(1, 7, 255, 0, 255);
        this.basicColorTable.setColor(2, 0, 128, 64, 64);
        this.basicColorTable.setColor(2, 1, 255, 128, 64);
        this.basicColorTable.setColor(2, 2, 0, 255, 0);
        this.basicColorTable.setColor(2, 3, 0, 128, 128);
        this.basicColorTable.setColor(2, 4, 0, 64, 128);
        this.basicColorTable.setColor(2, 5, 128, 128, 255);
        this.basicColorTable.setColor(2, 6, 128, 0, 64);
        this.basicColorTable.setColor(2, 7, 255, 0, 128);
        this.basicColorTable.setColor(3, 0, 128, 0, 0);
        this.basicColorTable.setColor(3, 1, 255, 128, 0);
        this.basicColorTable.setColor(3, 2, 0, 128, 0);
        this.basicColorTable.setColor(3, 3, 0, 128, 64);
        this.basicColorTable.setColor(3, 4, 0, 0, 255);
        this.basicColorTable.setColor(3, 5, 0, 0, 160);
        this.basicColorTable.setColor(3, 6, 128, 0, 128);
        this.basicColorTable.setColor(3, 7, 128, 0, 255);
        this.basicColorTable.setColor(4, 0, 64, 0, 0);
        this.basicColorTable.setColor(4, 1, 128, 64, 0);
        this.basicColorTable.setColor(4, 2, 0, 64, 0);
        this.basicColorTable.setColor(4, 3, 0, 64, 64);
        this.basicColorTable.setColor(4, 4, 0, 0, 128);
        this.basicColorTable.setColor(4, 5, 0, 0, 64);
        this.basicColorTable.setColor(4, 6, 64, 0, 64);
        this.basicColorTable.setColor(4, 7, 64, 0, 128);
        this.basicColorTable.setColor(5, 0, 0, 0, 0);
        this.basicColorTable.setColor(5, 1, 128, 128, 0);
        this.basicColorTable.setColor(5, 2, 128, 128, 64);
        this.basicColorTable.setColor(5, 3, 128, 128, 128);
        this.basicColorTable.setColor(5, 4, 64, 128, 128);
        this.basicColorTable.setColor(5, 5, 192, 192, 192);
        this.basicColorTable.setColor(5, 6, 64, 0, 64);
        this.basicColorTable.setColor(5, 7, 255, 255, 255);
    }
}

