/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser;

import com.swimap.iview.templates.colorchooser.ColorChooser;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

abstract class AbstractColorChooserPanel
extends JPanel {
    private ColorChooser chooser;
    private ChangeListener colorListener;
    private boolean dirty = true;

    AbstractColorChooserPanel(ColorChooser colorChooser) {
        if (this.chooser != null) {
            throw new IllegalArgumentException("This chooser panel is already installed");
        }
        this.chooser = colorChooser;
        this.buildChooser();
        this.updateChooser();
        this.colorListener = new ModelListener();
        this.getColorSelectionModel().addChangeListener(this.colorListener);
    }

    public void uninstallChooserPanel() {
        this.getColorSelectionModel().removeChangeListener(this.colorListener);
        this.chooser = null;
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.chooser.getSelectionModel();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.dirty) {
            this.updateChooser();
            this.dirty = false;
        }
        super.paint(graphics);
    }

    protected abstract void updateChooser();

    protected abstract void buildChooser();

    final Color getColorFromModel() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    final void addComponents(JComponent jComponent) {
        this.chooser.addComponents(jComponent);
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (AbstractColorChooserPanel.this.isShowing()) {
                AbstractColorChooserPanel.this.updateChooser();
                AbstractColorChooserPanel.this.dirty = false;
            } else {
                AbstractColorChooserPanel.this.dirty = true;
            }
        }
    }
}

