/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.pie;

import com.swimap.iview.templates.charts.pie.PieChartStyleInformation;
import com.swimap.iview.templates.charts.pie.PieChartStyleInformationManager;
import com.swimap.iview.templates.charts.pie.xml.BackgroundColor;
import com.swimap.iview.templates.charts.pie.xml.PieChart;
import com.swimap.iview.templates.charts.pie.xml.PieChartInformation;
import com.swimap.iview.templates.charts.pie.xml.PointLabels;
import com.swimap.iview.templates.charts.pie.xml.SeriesInformation;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.net.URL;

public class PieChartXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(PieChartXMLFileReader.class, "IVIEW");
    private boolean validity = false;
    private PieChartStyleInformation styleInformation = null;
    private PieChartStyleInformationManager thePieChartStyleInformationManager = null;

    public PieChartStyleInformation getPieChartStyleInformation(String string) throws Exception {
        if (this.readXMLFile(string)) {
            return this.styleInformation;
        }
        return null;
    }

    public boolean readXMLFile(String string) throws Exception {
        try {
            File file = CommonUtil.getAbsoluteFile(string);
            URL uRL = file.toURL();
            PieChart pieChart = PieChart.unmarshal(uRL);
            this.validity = pieChart.isValid();
            if (this.validity) {
                Object[] objectArray;
                String[] stringArray;
                BackgroundColor backgroundColor;
                PieChartInformation pieChartInformation = pieChart.getPieChartInformation();
                this.styleInformation = new PieChartStyleInformation();
                if (pieChartInformation.getTitle() != null) {
                    this.styleInformation.setChartTitle(pieChartInformation.getTitle().trim());
                }
                if (pieChartInformation.getDepth() != null) {
                    this.styleInformation.setChartDepth(pieChartInformation.getDepth());
                }
                if (pieChartInformation.getElevation() != null) {
                    this.styleInformation.setChartElevation(pieChartInformation.getElevation());
                }
                if (pieChartInformation.getRotation() != null) {
                    this.styleInformation.setChartRotation(pieChartInformation.getRotation());
                }
                if (pieChartInformation.getWidth() != null && pieChartInformation.getHeight() != null) {
                    this.styleInformation.setChartSize(pieChartInformation.getWidth(), pieChartInformation.getHeight());
                }
                this.styleInformation.setLegendFont(pieChartInformation.getLegendFontName().trim(), pieChartInformation.getLegendFontStyle(), pieChartInformation.getLegendFontSize());
                if (pieChartInformation.getLegendPosition() != null) {
                    this.styleInformation.setLegendPosition(pieChartInformation.getLegendPosition().trim());
                }
                if (pieChartInformation.getStartAngle() != null) {
                    this.styleInformation.setPieStartAngle(pieChartInformation.getStartAngle());
                }
                boolean bl = true;
                PointLabels[] pointLabelsArray = pieChartInformation.getPointLabels();
                int n = pieChartInformation.getPointLabelsCount();
                String[] stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    if (pointLabelsArray[i].getName() == null) {
                        bl = false;
                        break;
                    }
                    stringArray2[i] = pointLabelsArray[i].getName();
                }
                if (bl) {
                    this.styleInformation.setPointLabel(stringArray2);
                }
                if ((backgroundColor = pieChartInformation.getBackgroundColor()) != null && backgroundColor.getR() != null && backgroundColor.getG() != null && backgroundColor.getB() != null) {
                    stringArray = new String[]{backgroundColor.getR(), backgroundColor.getG(), backgroundColor.getB()};
                    this.styleInformation.setChartBackground(stringArray);
                }
                if ((stringArray = pieChartInformation.getLegendBackgroundColor()) != null && stringArray.getR() != null && stringArray.getG() != null && stringArray.getB() != null) {
                    objectArray = new String[]{stringArray.getR(), stringArray.getG(), stringArray.getB()};
                    this.styleInformation.setLegendBackground((String[])objectArray);
                }
                objectArray = pieChartInformation.getSeriesInformation();
                int n2 = pieChartInformation.getSeriesInformationCount();
                String[][] stringArray3 = new String[n2][3];
                String[] stringArray4 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    bl = true;
                    stringArray3[i][0] = objectArray[i].getR();
                    stringArray3[i][1] = ((SeriesInformation)objectArray[i]).getG();
                    stringArray3[i][2] = ((SeriesInformation)objectArray[i]).getB();
                    if (((SeriesInformation)objectArray[i]).getLabel() != null) {
                        stringArray4[i] = ((SeriesInformation)objectArray[i]).getLabel();
                        continue;
                    }
                    bl = false;
                }
                this.styleInformation.setSeriesColors(stringArray3);
                if (bl) {
                    this.styleInformation.setSeriesLabel(stringArray4);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.validity = false;
            logger.error("Error while reading XML file : " + numberFormatException);
            throw numberFormatException;
        }
        catch (Exception exception) {
            this.validity = false;
            logger.error("Error while reading XML file : " + exception);
            throw exception;
        }
        return this.validity;
    }

    public boolean isInformationValid() {
        return this.validity;
    }

    public boolean saveInformation(String string) throws Exception {
        this.thePieChartStyleInformationManager = new PieChartStyleInformationManager(string);
        boolean bl = this.thePieChartStyleInformationManager != null & this.styleInformation != null;
        if (bl) {
            try {
                this.thePieChartStyleInformationManager.saveInformation(this.styleInformation);
            }
            catch (Exception exception) {
                bl = false;
                logger.error("Error while saving the information" + exception);
            }
        }
        return bl;
    }
}

