/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.pie;

import com.swimap.iview.templates.charts.pie.IPieChartStyleInterface;
import com.swimap.iview.templates.charts.pie.PieChartStyleInformation;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.TableOrder;

public class PieChartTemplate
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(PieChartTemplate.class, "IVIEW");
    private static final Color DEFAULT_CHART_HEADER_BACKGROUND = Color.white;
    private static final Color DEFAULT_CHART_HEADER_FOREGROUND = Color.blue;
    private static final Font DEFAULT_CHART_HEADER_FONT = new Font("Courier", 3, 30);
    private static final int DEFAULT_PLOT_AREA_TOP = 30;
    public CategoryDataset dataset = null;
    private PieChartStyleInformation styleInformation;
    private Vector chartDataVector = null;
    private ChartPanel chartPanel = null;
    private JFreeChart chart = this.createChart(null);

    public PieChartTemplate() {
        this.chartPanel = new ChartPanel(this.chart, true, true, true, false, true);
        this.add((Component)this.chartPanel);
    }

    public PieChartTemplate(IPieChartStyleInterface iPieChartStyleInterface) throws ClassNotFoundException, IOException, SecurityException {
        this();
        try {
            this.styleInformation = iPieChartStyleInterface.loadInformation();
            if (null == this.styleInformation) {
                String string = new String("styleInformation can not be null.");
                logger.error(string);
                throw new IllegalArgumentException(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error(classNotFoundException.toString());
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.error(iOException.toString());
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (SecurityException securityException) {
            logger.error(securityException.toString());
            throw securityException;
        }
        catch (Exception exception) {
            logger.error(exception.toString());
        }
        this.setStyleInformationToTemplate();
    }

    public void setChartData(Vector vector) {
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)this.chart.getPlot();
        this.dataset = this.getChartData(vector);
        multiplePiePlot.setDataset(this.dataset);
        this.setColor();
    }

    private void setColor() {
        Color[] colorArray = this.styleInformation.getSeriesColors();
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)this.chart.getPlot();
        JFreeChart jFreeChart = multiplePiePlot.getPieChart();
        Plot plot = jFreeChart.getPlot();
        PiePlot3D piePlot3D = (PiePlot3D)plot;
        List list = this.dataset.getColumnKeys();
        for (int i = 0; i < list.size(); ++i) {
            piePlot3D.setSectionPaint((Comparable)list.get(i), (Paint)colorArray[i]);
        }
        piePlot3D.setStartAngle(this.styleInformation.getPieStartAngle());
        piePlot3D.setDepthFactor((double)((float)this.styleInformation.getChartDepth() / 100.0f));
    }

    public CategoryDataset getChartData(Vector vector) {
        this.chartPanel.setSize(this.styleInformation.getChartSize());
        String[] stringArray = this.styleInformation.getSeriesLabel();
        String[] stringArray2 = this.styleInformation.getPointLabel();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        if (null != stringArray && null != stringArray2) {
            Vector vector2 = new Vector();
            for (int i = 0; i < stringArray2.length; ++i) {
                vector2 = (Vector)vector.get(i);
                for (int j = 0; j < stringArray.length; ++j) {
                    defaultCategoryDataset.addValue((Number)((Double)vector2.get(j)), (Comparable)((Object)stringArray2[j]), (Comparable)((Object)stringArray[i]));
                }
            }
        }
        return defaultCategoryDataset;
    }

    public PieChartStyleInformation getInformation() {
        return this.styleInformation;
    }

    public void setInformation(PieChartStyleInformation pieChartStyleInformation) {
        if (null == pieChartStyleInformation) {
            String string = new String("data can not be null.");
            logger.error(string);
            throw new IllegalArgumentException(string);
        }
        this.styleInformation = pieChartStyleInformation;
        this.setStyleInformationToTemplate();
    }

    private void setStyleInformationToTemplate() {
        this.setChartProperties();
        this.setChartHeaderProperties();
        this.setChartAreaProperties();
        this.setPieProperties();
        this.setLegendProperties();
    }

    private void setLegendProperties() {
        LegendTitle legendTitle = this.chart.getLegend();
        legendTitle.setBackgroundPaint((Paint)this.styleInformation.getLegendBackground());
        legendTitle.setItemFont(this.styleInformation.getLegendFont());
        String string = this.styleInformation.getLegendPosition();
        RectangleEdge rectangleEdge = null;
        rectangleEdge = "SOUTH".equals(string) ? RectangleEdge.BOTTOM : ("WEST".equals(string) ? RectangleEdge.LEFT : ("NORTH".equals(string) ? RectangleEdge.TOP : RectangleEdge.RIGHT));
        legendTitle.setPosition(rectangleEdge);
        legendTitle.setBorder(0.0, 0.0, 0.0, 0.0);
    }

    public void setPieProperties() {
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)this.chart.getPlot();
        JFreeChart jFreeChart = multiplePiePlot.getPieChart();
        Plot plot = jFreeChart.getPlot();
        PiePlot3D piePlot3D = null;
        piePlot3D = (PiePlot3D)plot;
        piePlot3D.setLabelLinksVisible(false);
        piePlot3D.setLabelGenerator(null);
        piePlot3D.setOutlineVisible(false);
        piePlot3D.setBackgroundPaint((Paint)this.styleInformation.getChartBackground());
        piePlot3D.setCircular(true);
        this.setBackground(this.styleInformation.getChartBackground());
    }

    private void setChartAreaProperties() {
        Plot plot = this.chart.getPlot();
        plot.setBackgroundPaint((Paint)this.styleInformation.getChartBackground());
        this.chartPanel.setPreferredSize(this.styleInformation.getChartSize());
    }

    private void setChartHeaderProperties() {
        TextTitle textTitle = this.chart.getTitle();
        textTitle.setText(this.styleInformation.getChartTitle());
        textTitle.setBackgroundPaint((Paint)DEFAULT_CHART_HEADER_BACKGROUND);
        textTitle.setFont(DEFAULT_CHART_HEADER_FONT);
        textTitle.setPaint((Paint)DEFAULT_CHART_HEADER_FOREGROUND);
    }

    private void setChartProperties() {
        this.chart.setBackgroundPaint((Paint)this.styleInformation.getChartBackground());
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createMultiplePieChart3D((String)"Pie Chart", (CategoryDataset)categoryDataset, (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)false, (boolean)false);
        return jFreeChart;
    }
}

