/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class VerticalNumberAxis
extends NumberAxis {
    private static final double DEFAULT_LOWER = 0.0;
    private static final double DEFAULT_UPPER = 100.0;
    private static final int DEFAULT_SHOW_UNIT = 5;
    private int basicScaleUnit = 5;
    private static final double DEFAULT_SPACE_RATE = 0.05;
    double spaceHeight = Double.NaN;
    private Rectangle2D dataArea = null;
    boolean isUpVisible = false;
    boolean isDownVisible = false;
    public static final int LEFT_AXIS = 0;
    public static final int RIGHT_AXIS = 1;

    public VerticalNumberAxis() {
        this.setRange(0.0, 100.0);
        double[] dArray = new double[]{10.0, this.getRange().getLength() / 4.0};
        this.setTickUnitSize(dArray);
    }

    public void setTickUnitSize(double d) {
        this.setTickUnitSize(new double[]{d});
    }

    public void setTickUnitSize(double d, NumberFormat numberFormat) {
        this.setTickUnitSize(new double[]{d}, numberFormat);
    }

    public void setTickUnitSize(double[] dArray) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.setTickUnitSize(dArray, numberFormat);
    }

    public void setTickUnitSize(double[] dArray, NumberFormat numberFormat) {
        if (dArray == null) {
            return;
        }
        TickUnits tickUnits = new TickUnits();
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance();
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] <= 0.0) continue;
            tickUnits.add((TickUnit)new NumberTickUnit(dArray[i], numberFormat));
        }
        if (tickUnits.size() == 0) {
            return;
        }
        this.setStandardTickUnits((TickUnitSource)tickUnits);
    }

    public void setBasicScaleUnit(int n) {
        if (n < 0) {
            return;
        }
        if (this.basicScaleUnit == n) {
            return;
        }
        this.basicScaleUnit = n;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public int getBasicScaleUnit() {
        return this.basicScaleUnit;
    }

    public void setRange(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("Range's upper must be greater than lower");
        }
        this.spaceHeight = 0.05 * (d2 - d);
        double d3 = this.isDownVisible ? -this.spaceHeight : 0.0;
        double d4 = this.isUpVisible ? this.spaceHeight : 0.0;
        super.setRange(d + d3, d2 + d4);
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d2;
        Object object;
        AxisState axisState = new AxisState(d);
        double d3 = this.valueToJava2D(this.getUpperBound(), rectangle2D2, rectangleEdge);
        double d4 = this.valueToJava2D(this.getUpperBound() - this.spaceHeight, rectangle2D2, rectangleEdge);
        int n = (int)Math.abs(d3 - d4);
        double d5 = this.isUpVisible ? (double)n : 0.0;
        double d6 = this.isDownVisible ? (double)n : 0.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY() + d5, rectangle2D2.getWidth(), rectangle2D2.getHeight() - d5 - d6);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, double_, rectangleEdge);
        }
        double d7 = this.getTickMarkOutsideLength();
        double d8 = this.getTickMarkInsideLength();
        this.dataArea = rectangle2D2;
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = list.iterator();
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        ValueTick valueTick = null;
        ValueTick valueTick2 = null;
        float f4 = -1.0f;
        while (iterator.hasNext()) {
            ++n2;
            valueTick2 = valueTick;
            valueTick = (ValueTick)iterator.next();
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                object = this.calculateAnchorPoint(valueTick, d, rectangle2D2, rectangleEdge);
                if ((double)object[1] < double_.getMinY()) {
                    valueTick = valueTick2;
                    break;
                }
                if ((double)object[1] > double_.getMaxY()) continue;
                if (f4 < 0.0f) {
                    f4 = object[1];
                }
                TextUtilities.drawRotatedString((String)valueTick.getText(), (Graphics2D)graphics2D, (float)object[0], (float)object[1], (TextAnchor)valueTick.getTextAnchor(), (double)valueTick.getAngle(), (TextAnchor)valueTick.getRotationAnchor());
            }
            if (!this.isTickMarksVisible()) continue;
            float f5 = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            Line2D.Double double_2 = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            double d9 = d7 + 2.0;
            if (rectangleEdge.equals((Object)RectangleEdge.LEFT)) {
                double_2 = new Line2D.Double(d - d9, f5, d + d8, f5);
            } else if (rectangleEdge.equals((Object)RectangleEdge.RIGHT)) {
                double_2 = new Line2D.Double(d + d9, f5, d - d8, f5);
            }
            graphics2D.draw(double_2);
            if (n2 == 1) {
                f = f5;
                continue;
            }
            f2 = Math.abs(f5 - f);
            if (f2 != 0.0f) {
                f3 = f2 /= (float)this.basicScaleUnit;
                for (int i = 0; i < this.basicScaleUnit; ++i) {
                    f -= f2;
                    double_2 = null;
                    graphics2D.setStroke(this.getTickMarkStroke());
                    graphics2D.setPaint(this.getTickMarkPaint());
                    if (rectangleEdge.equals((Object)RectangleEdge.LEFT)) {
                        double_2 = new Line2D.Double(d - d7, f, d + d8, f);
                    } else if (rectangleEdge.equals((Object)RectangleEdge.RIGHT)) {
                        double_2 = new Line2D.Double(d + d7, f, d - d8, f);
                    }
                    graphics2D.draw(double_2);
                }
            }
            f = f5;
        }
        if (valueTick != null) {
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            object = null;
            d2 = this.valueToJava2D(this.getUpperBound(), rectangle2D2, rectangleEdge) + d5;
            for (double d10 = this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge); d10 >= d2 && !(f3 <= 0.0f); d10 -= (double)f3) {
                if (rectangleEdge.equals((Object)RectangleEdge.LEFT)) {
                    object = new Line2D.Double(d - d7, d10, d + d8, d10);
                } else if (rectangleEdge.equals((Object)RectangleEdge.RIGHT)) {
                    object = new Line2D.Double(d + d7, d10, d - d8, d10);
                }
                graphics2D.draw((Shape)object);
            }
        }
        object = null;
        double d11 = this.valueToJava2D(this.getLowerBound(), rectangle2D2, rectangleEdge) - d6;
        for (d2 = (double)f4; d2 <= d11 + (double)(f3 / 10.0f) && d2 >= 0.0 && !(f3 <= 0.0f); d2 += (double)f3) {
            if (rectangleEdge == RectangleEdge.LEFT) {
                object = new Line2D.Double(d - d7, d2, d + d8, d2);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                object = new Line2D.Double(d + d7, d2, d - d8, d2);
            }
            graphics2D.draw((Shape)object);
        }
        double d12 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge.equals((Object)RectangleEdge.LEFT)) {
                axisState.cursorLeft(d12 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (rectangleEdge.equals((Object)RectangleEdge.RIGHT)) {
                d12 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d12);
            }
        }
        return axisState;
    }

    Number getValueAtAxis(double d) {
        if (this.dataArea != null) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            d4 = this.dataArea.getHeight();
            d5 = this.getUpperBound() - this.getLowerBound();
            d3 = this.dataArea.getMinY();
            if (d < d3 || d > d3 + d4) {
                return null;
            }
            d2 = (d - d3) / d4;
            double d6 = d5 * d2;
            double d7 = this.getUpperBound() - d6;
            return new Double(d7);
        }
        return null;
    }

    public void setSpaceVisible(boolean bl, boolean bl2) {
        double d = this.getLowerBound();
        double d2 = this.getUpperBound();
        if (Double.isNaN(this.spaceHeight)) {
            this.spaceHeight = 0.05 * (d2 - d);
        }
        if (this.isUpVisible != bl) {
            if (this.isUpVisible && !bl) {
                d2 -= this.spaceHeight;
            } else if (!this.isUpVisible && bl) {
                d2 += this.spaceHeight;
            }
        }
        if (this.isDownVisible != bl2) {
            if (this.isDownVisible && !bl2) {
                d += this.spaceHeight;
            } else if (!this.isDownVisible && bl2) {
                d -= this.spaceHeight;
            }
        }
        this.isUpVisible = bl;
        this.isDownVisible = bl2;
        super.setRange(d, d2);
    }
}

