/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.CommonTools;
import com.swimap.iview.templates.charts.curve.expand.ScatterTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.dyntrace.DynDebugTracer;
import java.awt.Color;

public class SeriesTaskInfo
extends ScatterTaskInfo {
    private int lineType = 1;
    private int lineWidth = 1;
    private CommonTools commonTools = new CommonTools();
    private static final DynDebugTracer dynTracer = DynDebugTracer.getInstance(SeriesTaskInfo.class);
    public static final int LINEWIDTH_NARROW = 1;
    public static final int LINEWIDTH_BROAD = 2;
    public static final int LINETYPE_GENERAL = 1;
    public static final int LINETYPE_SECOND = 2;
    public static final int LINETYPE_THIRD = 3;
    public static final int LINETYPE_FOUTH = 4;
    public static final int LINETYPE_FIFTH = 5;
    public static final int LINTTYPE_SIXTH = 6;
    public static final int LINTTYPE_SEVENTH = 7;
    public static final int LINTTYPE_EIGHTH = 8;

    public SeriesTaskInfo(String string, String string2, String string3, Color color, int n) {
        super(string, string2, string3, color, n);
    }

    public SeriesTaskInfo(String string, String string2) {
        super(string, string2);
    }

    public void modifyLineType(int n) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("modifyLineType()", "lineType=" + n);
        }
        if (n < 1 || n > 8) {
            throw new IllegalArgumentException("The lineType must be between 1(include) - 8(include)");
        }
        if (this.lineType == n) {
            return;
        }
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("modifyLineType()", "valid.");
        }
        this.lineType = n;
        this.commonTools.modifyLine(super.getRenderer(), this.lineType, this.lineWidth);
        if (n == 2) {
            this.modifyShapeType(1);
        } else if (n == 3) {
            this.modifyShapeType(0);
        } else if (n == 5) {
            this.modifyShapeType(7);
        }
        this.fireTaskInfoChange(this.getGeneralEvent());
    }

    public void modifyLineWidth(int n) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("modifyLineWidth()", "lineWidth=" + n);
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("The lineWidth must be LINEWIDTH_NARROW or LINEWIDTH_BROAD");
        }
        if (this.lineWidth == n) {
            return;
        }
        this.lineWidth = n;
        this.commonTools.modifyLine(super.getRenderer(), this.lineType, this.lineWidth);
        this.fireTaskInfoChange(this.getGeneralEvent());
    }

    public int getLineType() {
        return this.lineType;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public boolean hasLine() {
        return true;
    }
}

