/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.AbstractNumTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.NumStandardXYItemRenderer;
import com.swimap.iview.templates.charts.curve.expand.dyntrace.DynDebugTracer;
import java.awt.Color;
import java.awt.Shape;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScatterTaskInfo
extends AbstractNumTaskInfo {
    private int shapeType = -1;
    private XYSeriesCollection dataset = null;
    private NumStandardXYItemRenderer renderer = null;
    private static final Shape[] DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE;
    public static final int SHAPE_SQUARE = 0;
    public static final int SHAPE_CIRCLE = 1;
    public static final int SHAPE_UP_TRIANGLE = 2;
    public static final int SHAPE_DIAMOND = 3;
    public static final int SHAPE_HORIZONTAL_RECTANGLE = 4;
    public static final int SHAPE_DOWN_TRIANGLE = 5;
    public static final int SHAPE_HORIZONTAL_ELLIPSE = 6;
    public static final int SHAPE_RIGHT_TRIANGLE = 7;
    public static final int SHAPE_VERTICAL_RECTANGLE = 8;
    public static final int SHAPE_LEFT_TRIANGLE = 9;
    private static final DynDebugTracer dynTracer = DynDebugTracer.getInstance(ScatterTaskInfo.class);

    public ScatterTaskInfo(String string, String string2, String string3, Color color, int n) {
        super(string, string2, string3, color);
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("ScatterTaskInfo()", "Building... shapeType=" + n);
        }
        this.init();
        this.modifyShapeType(n);
        this.renderer.setPaint(color);
    }

    public ScatterTaskInfo(String string, String string2) {
        super(string, string2);
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("ScatterTaskInfo()", "Building... ");
        }
        this.init();
    }

    private void init() {
        XYSeries xYSeries = super.getSeries();
        this.dataset = new XYSeriesCollection(xYSeries);
        this.renderer = this.hasLine() ? new NumStandardXYItemRenderer(2) : new NumStandardXYItemRenderer(1);
    }

    public static int getShapeTypeCount() {
        return DEFAULT_SHAPE_SEQUENCE.length;
    }

    public void modifyShapeType(int n) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("modifyShapeType()", "type=" + n);
        }
        if (n >= ScatterTaskInfo.getShapeTypeCount() || n < 0) {
            throw new IllegalArgumentException("Shape type must be between 0(include) - 9(include)");
        }
        if (this.shapeType != n) {
            if (dynTracer.isEnableDynDebug()) {
                dynTracer.trace("modifyShapeType()", "valid");
            }
            this.shapeType = n;
            this.renderer.setShape(DEFAULT_SHAPE_SEQUENCE[this.shapeType]);
            this.fireTaskInfoChange(this.getGeneralEvent());
        }
    }

    @Override
    public void modifyColor(Color color) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("modifyColor()", "color=" + color);
        }
        if (color != null && !color.equals(this.getColor())) {
            if (dynTracer.isEnableDynDebug()) {
                dynTracer.trace("modifyColor()", "valid.");
            }
            super.modifyColor(color);
            this.renderer.setPaint(color);
            this.fireTaskInfoChange(this.getGeneralEvent());
        }
    }

    public XYSeriesCollection getDataset() {
        return this.dataset;
    }

    public StandardXYItemRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean hasLine() {
        return false;
    }

    @Override
    void customXYPlot(XYPlot xYPlot) {
        int n = xYPlot.getDatasetCount();
        xYPlot.setDataset(n, (XYDataset)this.dataset);
        xYPlot.setRenderer(n, (XYItemRenderer)this.renderer);
        xYPlot.mapDatasetToRangeAxis(n, this.bindAxis);
    }

    @Override
    void removeSelf(XYPlot xYPlot) {
        int n = xYPlot.indexOf((XYDataset)this.dataset);
        xYPlot.setDataset(n, null);
        xYPlot.setRenderer(n, null);
        this.dataset.removeSeries(this.getSeries());
        this.clear();
        this.dataset = null;
        this.setRemoved(true);
    }

    @Override
    void setTooltipFormat(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator(string, numberFormat, numberFormat2));
    }

    @Override
    public void setVisible(boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVisible()", "visible=" + bl);
        }
        if (this.isVisible() == bl) {
            return;
        }
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVisible()", "Valid.");
        }
        this.renderer.setVisible(bl);
        this.fireTaskInfoChange(this.getGeneralEvent());
    }

    @Override
    public boolean isVisible() {
        return this.renderer.isVisible();
    }
}

