/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.NumXYBarRenderer;
import com.swimap.iview.templates.charts.curve.expand.VerticalNumberAxis;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class NumXYSingleBarRenderer
extends NumXYBarRenderer {
    private double xPosition = 0.0;
    private double barWidth = 0.0;

    public void setXPosition(double d) {
        this.xPosition = d >= 0.0 && d <= 1.0 ? d : 0.0;
    }

    public double getXPosition() {
        return this.xPosition;
    }

    public void setWidth(double d) {
        this.barWidth = d >= 0.0 && d <= 1.0 ? d : 0.0;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        GradientPaint gradientPaint;
        if (!this.isVisible()) {
            return;
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemOutlinePaint(n, n2);
        Number number = intervalXYDataset.getY(n, n2);
        if (number == null || Double.isNaN(number.doubleValue())) {
            return;
        }
        double d = this.getTranslatedValue(valueAxis2, rectangle2D, xYPlot, number.doubleValue());
        double d2 = this.getRelativeZero(valueAxis2, rectangle2D, xYPlot);
        NumXYBarRenderer.XYBarRendererState xYBarRendererState = (NumXYBarRenderer.XYBarRendererState)xYItemRendererState;
        double d3 = xYBarRendererState.getG2Zero();
        double d4 = 0.0;
        if (Double.isNaN(d2)) {
            d4 = Math.abs(d - d3);
        } else {
            d4 = Math.abs(d - d2);
            d3 = d2;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(rectangle2D.getMinX() + rectangle2D.getWidth() * this.xPosition, Math.min(d3, d), rectangle2D.getWidth() * this.barWidth, d4);
        }
        Paint paint2 = this.getItemPaint(n, n2);
        if (this.getGradientPaintTransformer() != null && paint2 instanceof GradientPaint) {
            gradientPaint = (GradientPaint)paint2;
            paint2 = this.getGradientPaintTransformer().transform(gradientPaint, double_);
        }
        graphics2D.setPaint(paint2);
        graphics2D.fill(double_);
        if (Math.abs(rectangle2D.getWidth() * this.barWidth) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        this.drawBarValue(graphics2D, paint2, number, (float)(rectangle2D.getMinX() + rectangle2D.getWidth() * this.xPosition + rectangle2D.getWidth() * this.barWidth / 2.0), (float)d);
        if (plotRenderingInfo != null && (gradientPaint = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity((Shape)double_, xYDataset, n, n2, string, string2);
            gradientPaint.add((ChartEntity)xYItemEntity);
        }
    }

    private double getTranslatedValue(ValueAxis valueAxis, Rectangle2D rectangle2D, XYPlot xYPlot, double d) {
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        if (valueAxis instanceof VerticalNumberAxis) {
            VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)valueAxis;
            double d3 = verticalNumberAxis.getUpperBound();
            double d4 = verticalNumberAxis.getLowerBound();
            d3 = verticalNumberAxis.isUpVisible ? d3 - verticalNumberAxis.spaceHeight : d3;
            double d5 = d4 = verticalNumberAxis.isDownVisible ? d4 + verticalNumberAxis.spaceHeight : d4;
            if (d >= d3) {
                d2 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
            } else if (d <= d4) {
                d2 = valueAxis.valueToJava2D(d4, rectangle2D, xYPlot.getRangeAxisEdge());
            }
        }
        return d2;
    }

    private double getRelativeZero(ValueAxis valueAxis, Rectangle2D rectangle2D, XYPlot xYPlot) {
        double d = Double.NaN;
        if (valueAxis instanceof VerticalNumberAxis) {
            VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)valueAxis;
            double d2 = verticalNumberAxis.getUpperBound();
            double d3 = verticalNumberAxis.getLowerBound();
            d2 = verticalNumberAxis.isUpVisible ? d2 - verticalNumberAxis.spaceHeight : d2;
            double d4 = d3 = verticalNumberAxis.isDownVisible ? d3 + verticalNumberAxis.spaceHeight : d3;
            if (0.0 < d3) {
                d = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
            } else if (0.0 >= d2) {
                d = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
            }
        }
        return d;
    }
}

