/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.HorizontalNumberAxis;
import com.swimap.iview.templates.charts.curve.expand.NumXYBarRenderer;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;

public class NumXYPlot
extends XYPlot {
    private static int num = 0;
    private static int oldIndex = -1;

    public NumXYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        super(xYDataset, valueAxis, valueAxis2, xYItemRenderer);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        super.draw(graphics2D, rectangle2D, point2D, plotState, plotRenderingInfo);
        ValueAxis valueAxis = this.getDomainAxis();
        if (valueAxis instanceof HorizontalNumberAxis) {
            HorizontalNumberAxis horizontalNumberAxis = (HorizontalNumberAxis)valueAxis;
            horizontalNumberAxis.drawPointer(graphics2D);
        }
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        boolean bl = false;
        XYDataset xYDataset = this.getDataset(n);
        if (!DatasetUtilities.isEmptyOrNull((XYDataset)xYDataset)) {
            XYItemRenderer xYItemRenderer;
            this.getDomainAxisForDataset(n);
            bl = true;
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getDomainAxisForDataset(n);
            if (null != valueAxis2) {
                valueAxis = valueAxis2;
            }
            ValueAxis valueAxis3 = this.getRangeAxis();
            ValueAxis valueAxis4 = this.getRangeAxisForDataset(n);
            if (null != valueAxis4) {
                valueAxis3 = valueAxis4;
            }
            if (null == (xYItemRenderer = this.getRenderer(n))) {
                xYItemRenderer = this.getRenderer();
            }
            if (oldIndex <= n) {
                num = -1;
            }
            if (xYItemRenderer instanceof NumXYBarRenderer) {
                if (oldIndex > n) {
                    ++num;
                }
                if (num < 0) {
                    num = 0;
                }
                ((NumXYBarRenderer)xYItemRenderer).setNum(num);
            }
            oldIndex = n;
            XYItemRendererState xYItemRendererState = xYItemRenderer.initialise(graphics2D, rectangle2D, (XYPlot)this, xYDataset, plotRenderingInfo);
            int n2 = xYItemRenderer.getPassCount();
            Range range = this.getDomainAxis().getRange();
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            for (int i = 0; i < n2; ++i) {
                int n3 = xYDataset.getSeriesCount();
                block1: for (int j = 0; j < n3; ++j) {
                    int n4 = xYDataset.getItemCount(j);
                    for (int k = 0; k < n4; ++k) {
                        Number number = xYDataset.getX(j, k);
                        if (number == null || number.doubleValue() < d2) continue;
                        xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, (XYPlot)this, valueAxis, valueAxis3, xYDataset, j, k, crosshairState, i);
                        if (number.doubleValue() > d + 10.0) continue block1;
                    }
                }
            }
        }
        return bl;
    }
}

