/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class NumXYBarRenderer
extends XYBarRenderer {
    private boolean columnBarVisible = true;
    protected int num = 0;
    private NumberFormat valueFormat = null;

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        if (!this.columnBarVisible) {
            return;
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemOutlinePaint(n, n2);
        Number number = intervalXYDataset.getY(n, n2);
        if (null == number) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        Number number2 = intervalXYDataset.getStartX(n, n2);
        if (null == number2) {
            return;
        }
        double d = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        Number number3 = intervalXYDataset.getEndX(n, n2);
        if (null == number3) {
            return;
        }
        double d2 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d3 = ((XYBarRendererState)xYItemRendererState).getG2Zero();
        double d4 = Math.max(1.0, Math.abs(d2 - d));
        double d5 = valueAxis2.valueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        double d6 = Math.abs(d5 - d3);
        if (this.getMargin() > 0.0) {
            double d7 = d4 * this.getMargin();
            d4 -= d7;
            d += d7 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (PlotOrientation.VERTICAL == plotOrientation) {
            d -= d4 * 0.5;
            double_ = new Rectangle2D.Double(d -= (double)this.num * d4, Math.min(d3, d5), d4, d6);
        } else if (PlotOrientation.HORIZONTAL == plotOrientation) {
            double_ = new Rectangle2D.Double(Math.min(d3, d5), d2, d6, d4);
        }
        Paint paint2 = this.getItemPaint(n, n2);
        if (this.getGradientPaintTransformer() != null && paint2 instanceof GradientPaint) {
            paint2 = this.getGradientPaintTransformer().transform((GradientPaint)paint2, (Shape)double_);
        }
        graphics2D.setPaint(paint2);
        graphics2D.fill(double_);
        if (Math.abs(d2 - d) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        if (null != plotRenderingInfo && null != (entityCollection = plotRenderingInfo.getOwner().getEntityCollection())) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (null != xYToolTipGenerator) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (null != this.getURLGenerator()) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity((Shape)double_, xYDataset, n, n2, string, string2);
            entityCollection.add((ChartEntity)xYItemEntity);
        }
    }

    public void setVisible(boolean bl) {
        this.columnBarVisible = bl;
    }

    public boolean isVisible() {
        return this.columnBarVisible;
    }

    public void drawBarValue(Graphics2D graphics2D, Paint paint, Number number, float f, float f2) {
        NumberFormat numberFormat = this.valueFormat == null ? NumberFormat.getInstance() : this.valueFormat;
        Font font = new Font("SansSerif", 0, 12);
        String string = numberFormat.format(number);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.charsWidth(string.toCharArray(), 0, string.length());
        int n2 = fontMetrics.getHeight();
        if (number.intValue() >= 0) {
            graphics2D.drawString(string, f - (float)(n / 2), f2 - 2.0f);
        } else {
            graphics2D.drawString(string, f - (float)(n / 2), f2 + (float)(n2 / 2) + 2.0f);
        }
    }

    public void setNum(int n) {
        this.num = n;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYBarRendererState xYBarRendererState = new XYBarRendererState(plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxisForDataset(xYPlot.indexOf(xYDataset));
        xYBarRendererState.setG2Zero(valueAxis.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge()));
        return xYBarRendererState;
    }

    public void setVerticalNumberFormat(NumberFormat numberFormat) {
        this.valueFormat = numberFormat;
    }

    class XYBarRendererState
    extends XYItemRendererState {
        private double g2Zero;

        public XYBarRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
            this.g2Zero = 0.0;
        }

        public double getG2Zero() {
            return this.g2Zero;
        }

        public void setG2Zero(double d) {
            this.g2Zero = d;
        }
    }
}

