/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.util.log.IviewLogger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;

public class NumStandardXYItemRenderer
extends StandardXYItemRenderer {
    private static IviewLogger logger = IviewLogger.getLogger(NumStandardXYItemRenderer.class, "IVIEW");
    private boolean visible = true;

    public NumStandardXYItemRenderer() {
    }

    public NumStandardXYItemRenderer(int n) {
        super(n);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Serializable serializable;
        Object object;
        if (!this.visible) {
            return;
        }
        Object object2 = null;
        EntityCollection entityCollection = null;
        if (null != plotRenderingInfo) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getY(n, n2);
        Number number2 = xYDataset.getX(n, n2);
        if (null == number || null == number2) {
            logger.trace("NumStandardXYItemRenderer y1n or xln is null! yln=" + number + "x1n=" + number2);
            return;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d3 = valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        boolean bl = true;
        if (Double.isNaN(d4) || Double.isNaN(d3)) {
            logger.trace("NumStandardXYItemRenderer y1n or xln is Double.isNaN! transY1=" + d3 + "transX1=" + d4);
            return;
        }
        if (this.getPlotLines() && n2 > 0) {
            object = xYDataset.getX(n, n2 - 1);
            serializable = xYDataset.getY(n, n2 - 1);
            if (null != serializable && null != object) {
                double d5 = ((Number)serializable).doubleValue();
                double d6 = ((Number)object).doubleValue();
                boolean bl2 = true;
                if (this.getPlotDiscontinuous()) {
                    int n4 = xYDataset.getItemCount(n);
                    double d7 = xYDataset.getXValue(n, 0);
                    double d8 = xYDataset.getXValue(n, n4 - 1);
                    boolean bl3 = bl2 = d2 - d6 <= (d8 - d7) / (double)n4 * this.getGapThreshold();
                    if (!bl2) {
                        StringBuffer stringBuffer = new StringBuffer(110);
                        stringBuffer.append("NumStandardXYItemRenderer x0 = ").append(d6).append(" x1 = ").append(d2).append(" maxX = ").append(d8).append(" minX = ").append(d7).append(" numX =").append(n4).append(" getGapThreshold() = ").append(this.getGapThreshold());
                        logger.trace(stringBuffer.toString());
                    }
                }
                if (bl2) {
                    double d9 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge2);
                    double d10 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge);
                    if (Double.isNaN(d9) || Double.isNaN(d10)) {
                        logger.trace("NumStandardXYItemRenderer transX0 or transY0 is Double.isNaN! transY0=" + d10 + "transX0=" + d9);
                        bl = false;
                    }
                    if (PlotOrientation.HORIZONTAL == plotOrientation) {
                        xYItemRendererState.workingLine.setLine(d10, d9, d3, d4);
                    } else if (PlotOrientation.VERTICAL == plotOrientation) {
                        xYItemRendererState.workingLine.setLine(d9, d10, d4, d3);
                    }
                    if (bl && xYItemRendererState.workingLine.intersects(rectangle2D)) {
                        graphics2D.draw(xYItemRendererState.workingLine);
                    }
                }
            } else {
                logger.trace("NumStandardXYItemRenderer y0n or x0n is null! y0n=" + serializable + "x0n=" + object);
            }
        }
        if (this.getBaseShapesVisible()) {
            object = this.getItemShape(n, n2);
            if (PlotOrientation.HORIZONTAL == plotOrientation) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, (double)d3, (double)d4);
            } else if (PlotOrientation.VERTICAL == plotOrientation) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, (double)d4, (double)d3);
            }
            if (object.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n, n2)) {
                    graphics2D.fill((Shape)object);
                } else {
                    graphics2D.draw((Shape)object);
                }
            }
            object2 = object;
        }
        if (this.getPlotImages() && null != (object = this.getImage((Plot)xYPlot, n, n2, d4, d3))) {
            serializable = this.getImageHotspot((Plot)xYPlot, n, n2, d4, d3, (Image)object);
            graphics2D.drawImage((Image)object, (int)(d4 - ((Point)serializable).getX()), (int)(d3 - ((Point)serializable).getY()), null);
            object2 = new Rectangle2D.Double(d4 - ((Point)serializable).getX(), d3 - ((Point)serializable).getY(), ((Image)object).getWidth(null), ((Image)object).getHeight(null));
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d4, d3, d < 0.0);
        }
        this.updateCrosshairValues(crosshairState, d2, d, d4, d3, plotOrientation);
        if (null != entityCollection) {
            if (null == object2) {
                object2 = new Rectangle2D.Double(d4 - 2.0, d3 - 2.0, 4.0, 4.0);
            }
            object = null;
            serializable = this.getToolTipGenerator(n, n2);
            if (null != serializable) {
                object = serializable.generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (null != this.getURLGenerator()) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity((Shape)object2, xYDataset, n, n2, (String)object, string);
            entityCollection.add((ChartEntity)xYItemEntity);
        }
    }
}

