/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.MarkItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MarkSeries {
    private List data = null;
    private int maximumItemCount = Integer.MAX_VALUE;

    public MarkSeries(int n) {
        this.data = new ArrayList(n);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public void addOrUpdate(MarkItem markItem) {
        if (markItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        int n = Collections.binarySearch(this.data, markItem);
        if (n < 0) {
            this.data.add(-n - 1, markItem);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else {
            this.update(n, markItem.getXLabel());
        }
    }

    public void addOrUpdate(double d, String string) {
        MarkItem markItem = new MarkItem(new Double(d), string);
        this.addOrUpdate(markItem);
    }

    public void add(MarkItem markItem) {
        if (markItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        int n = Collections.binarySearch(this.data, markItem);
        if (n < 0) {
            this.data.add(-n - 1, markItem);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        }
    }

    public void add(double d, String string) {
        MarkItem markItem = new MarkItem(new Double(d), string);
        this.add(markItem);
    }

    public void delete(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.data.remove(n);
        }
    }

    public MarkItem remove(int n) {
        return (MarkItem)this.data.remove(n);
    }

    public MarkItem remove(double d) {
        return this.remove(this.indexOf(d));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
        }
    }

    public MarkItem getMarkItem(int n) {
        if (n < 0) {
            return null;
        }
        return (MarkItem)this.data.get(n);
    }

    public double getXValue(int n) {
        return this.getMarkItem(n).getX();
    }

    public String getXLabelByIndex(int n) {
        MarkItem markItem = this.getMarkItem(n);
        if (markItem == null) {
            return "";
        }
        return markItem.getXLabel();
    }

    public String getXLabel(double d) {
        return this.getXLabelByIndex(this.indexOf(d));
    }

    public void update(int n, String string) {
        MarkItem markItem = this.getMarkItem(n);
        if (null != markItem) {
            markItem.setXLabel(string);
        }
    }

    public int indexOf(double d) {
        return Collections.binarySearch(this.data, new MarkItem(new Double(d), null));
    }
}

