/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.AbstractNumTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.DaemonTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.HorizontalAxisChangedEvent;
import com.swimap.iview.templates.charts.curve.expand.HorizontalAxisChangedListener;
import com.swimap.iview.templates.charts.curve.expand.MarkItem;
import com.swimap.iview.templates.charts.curve.expand.MarkSeries;
import com.swimap.iview.templates.charts.curve.expand.NumTaskInfoChangedEvent;
import com.swimap.iview.templates.charts.curve.expand.NumTaskInfoChangedListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.data.Range;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class HorizontalNumberAxis
extends NumberAxis
implements NumTaskInfoChangedListener {
    private static final double DEFAULT_LOWER = 0.0;
    private static final double DEFAULT_UPPER = 10.0;
    private static final double DEFAULT_VISIBLE_LENDTH = 10.0;
    private static final int DEFAULT_SHOW_UNIT = 5;
    private static final int DEFAULT_MAX_COUNT = 50;
    private int basicScaleUnit = 5;
    private double lower = 0.0;
    private double beginValue = 0.0;
    private boolean beginValueEnabled = true;
    private double oldValue = Double.NaN;
    private double visibleLength = 10.0;
    private MarkSeries markSeries = new MarkSeries(50);
    private boolean customLabel = false;
    private boolean autoscroll = true;
    private transient EventListenerList listenerList = null;
    private HorizontalAxisChangedEvent axisEvent = new HorizontalAxisChangedEvent(this);
    private double angle = 0.0;
    private TextAnchor textAnchor = TextAnchor.TOP_CENTER;
    private Rectangle2D dataArea = null;
    private boolean isShowTaskNum = false;
    protected Hashtable taskNamePosition = new Hashtable(10);
    private boolean isPointerVisible = false;
    private int[] xpoints = null;
    private int[] ypoints = null;
    private double pointerPosition = Double.MAX_VALUE;
    private static final double MAX_POINTER_PERCENT = 1.0;
    private double percent = 1.0;
    private ArrayList units = new ArrayList(30);
    private double gap = 0.2;

    public HorizontalNumberAxis() {
        this.setBeginValueEnabled(true);
        this.setBeginValue(this.lower);
        this.setRange(this.lower - this.visibleLength, this.lower);
        this.setTickUnitSize(1.0);
        this.setLowerMargin(0.0);
        this.setUpperMargin(0.0);
    }

    public void setTickUnitSize(double d) {
        this.setTickUnitSize(new double[]{d});
    }

    public void setTickUnitSize(double d, NumberFormat numberFormat) {
        this.setTickUnitSize(new double[]{d}, numberFormat);
    }

    public void setTickUnitSize(double[] dArray) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.setTickUnitSize(dArray, numberFormat);
    }

    public void setTickUnitSize(double[] dArray, NumberFormat numberFormat) {
        if (dArray == null) {
            return;
        }
        TickUnits tickUnits = new TickUnits();
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance();
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] <= 0.0) continue;
            tickUnits.add((TickUnit)new NumberTickUnit(dArray[i], numberFormat));
        }
        if (tickUnits.size() == 0) {
            return;
        }
        this.setStandardTickUnits((TickUnitSource)tickUnits);
    }

    public void setVisibleLength(double d) {
        if (d > 0.0) {
            this.visibleLength = d;
        }
        double d2 = this.getRange().getUpperBound();
        this.setRange(d2 - d, d2);
    }

    public double getVisibleLength() {
        return this.visibleLength;
    }

    public void setBasicScaleUnit(int n) {
        if (n < 0) {
            return;
        }
        if (this.basicScaleUnit == n) {
            return;
        }
        this.basicScaleUnit = n;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public int getBasicScaleUnit() {
        return this.basicScaleUnit;
    }

    public void setRange(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("Range's upper must be greater than lower");
        }
        this.lower = d;
        this.visibleLength = d2 - d;
        super.setRange(d, d2);
    }

    public void setBeginValue(double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("beginValue can't be Double.NaN");
        }
        this.beginValue = d;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public void setBeginValueEnabled(boolean bl) {
        this.beginValueEnabled = bl;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public void setCustomLabelEnabled(boolean bl) {
        this.customLabel = bl;
    }

    public double getBeginValue() {
        return this.beginValue;
    }

    public boolean isBeginValueEnabled() {
        return this.beginValueEnabled;
    }

    public boolean isCustomLabelEnabled() {
        return this.customLabel;
    }

    public synchronized void addRangeChangedListener(HorizontalAxisChangedListener horizontalAxisChangedListener) {
        if (horizontalAxisChangedListener == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(HorizontalAxisChangedListener.class, horizontalAxisChangedListener);
    }

    public synchronized void removeRangeChangedListener(HorizontalAxisChangedListener horizontalAxisChangedListener) {
        if (horizontalAxisChangedListener == null) {
            return;
        }
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(HorizontalAxisChangedListener.class, horizontalAxisChangedListener);
    }

    public void setAngle(double d, TextAnchor textAnchor) {
        if (this.angle == d && textAnchor.equals((Object)this.textAnchor)) {
            return;
        }
        if (textAnchor != null) {
            this.textAnchor = textAnchor;
        }
        this.angle = d;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public double getAngle() {
        return this.angle;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    final void setMaximumItemCount(int n) {
        if (n < 0) {
            return;
        }
        this.markSeries.setMaximumItemCount(n);
    }

    final int getMaximumItemCount() {
        return this.markSeries.getMaximumItemCount();
    }

    final void setAutoscroll(boolean bl) {
        this.autoscroll = bl;
    }

    final boolean isAutoscroll() {
        return this.autoscroll;
    }

    final void clear() {
        this.markSeries.clear();
    }

    final MarkSeries getMarkSeries() {
        return this.markSeries;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = new AxisState(d);
        this.dataArea = rectangle2D2;
        if (this.isShowTaskNum && this.isAxisLineVisible()) {
            Object object;
            Font font = new Font("SansSerif", 0, 12);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            if (!this.taskNamePosition.isEmpty()) {
                object = this.taskNamePosition.keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    Double d2 = (Double)this.taskNamePosition.get(string);
                    float f = (float)(rectangle2D2.getWidth() * d2 + rectangle2D2.getMinX());
                    float f2 = (float)d;
                    TextUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)f, (float)f2, (TextAnchor)this.textAnchor, (double)this.angle, (TextAnchor)this.textAnchor);
                }
            }
            object = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks((List)object);
            axisState.cursorDown((double)fontMetrics.getHeight());
            return axisState;
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        double d3 = this.getTickMarkOutsideLength();
        double d4 = this.getTickMarkInsideLength();
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = list.iterator();
        double d5 = -1.0;
        ValueTick valueTick = null;
        ValueTick valueTick2 = null;
        ValueTick valueTick3 = null;
        Line2D.Double double_ = null;
        this.units.clear();
        while (iterator.hasNext()) {
            String string;
            valueTick = (ValueTick)iterator.next();
            if (this.isTickLabelsVisible() && this.needDrawTick(string = valueTick.getText().replaceAll(",", ""))) {
                if (this.customLabel && this.markSeries.getItemCount() != 0) {
                    string = this.markSeries.getXLabel(Double.parseDouble(string));
                }
                graphics2D.setPaint(this.getTickLabelPaint());
                float[] fArray = this.calculateAnchorPoint(valueTick, d, rectangle2D2, rectangleEdge);
                TextUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)fArray[0], (float)fArray[1], (TextAnchor)this.textAnchor, (double)this.angle, (TextAnchor)this.textAnchor);
            }
            if (!this.isTickMarksVisible()) continue;
            double d6 = this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge.equals((Object)RectangleEdge.TOP)) {
                double_ = new Line2D.Double(d6, d - d3, d6, d + d4);
            } else if (rectangleEdge.equals((Object)RectangleEdge.BOTTOM)) {
                double_ = new Line2D.Double(d6, d + d3 + 2.0, d6, d - d4);
            }
            graphics2D.draw(double_);
            if (d5 < 0.0) {
                d5 = d6;
                valueTick2 = valueTick;
            } else {
                this.gap = (d6 - d5) / (double)this.basicScaleUnit;
                for (int i = 1; i < this.basicScaleUnit; ++i) {
                    this.units.add(new Double(d5 + this.gap * (double)i));
                    double_ = new Line2D.Double(d5 + this.gap * (double)i, d + d3, d5 + this.gap * (double)i, d - d4);
                    graphics2D.draw(double_);
                }
                d5 = d6;
            }
            this.units.add(new Double(d6));
        }
        if (valueTick != null && valueTick2 != null) {
            valueTick3 = valueTick;
            double d7 = this.valueToJava2D(valueTick2.getValue(), rectangle2D2, rectangleEdge);
            double d8 = this.valueToJava2D(valueTick3.getValue(), rectangle2D2, rectangleEdge);
            double d9 = d8 + this.gap;
            double d10 = this.valueToJava2D(this.getLowerBound(), rectangle2D2, rectangleEdge);
            double d11 = this.valueToJava2D(this.getUpperBound(), rectangle2D2, rectangleEdge);
            for (double d12 = d7 - this.gap; d12 >= d10 - 1.0; d12 -= this.gap) {
                this.units.add(0, new Double(d12));
                if (this.gap <= 0.0) break;
                double_ = new Line2D.Double(d12, d + d3, d12, d - d4);
                graphics2D.draw(double_);
            }
            while (d9 <= d11 + 1.0) {
                this.units.add(new Double(d9));
                if (this.gap <= 0.0) break;
                double_ = new Line2D.Double(d9, d + d3, d9, d - d4);
                graphics2D.draw(double_);
                d9 += this.gap;
            }
        }
        double d13 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge.equals((Object)RectangleEdge.TOP)) {
                d13 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d13);
            } else if (rectangleEdge.equals((Object)RectangleEdge.BOTTOM)) {
                d13 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d13 + 5.0);
            }
        }
        return axisState;
    }

    protected void fireAxisChange(HorizontalAxisChangedEvent horizontalAxisChangedEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HorizontalAxisChangedListener.class) continue;
            ((HorizontalAxisChangedListener)objectArray[i + 1]).axisRangeChanged(horizontalAxisChangedEvent);
        }
    }

    @Override
    public void numTaskInfoChanged(NumTaskInfoChangedEvent numTaskInfoChangedEvent) {
        if (numTaskInfoChangedEvent == null) {
            return;
        }
        if (numTaskInfoChangedEvent.getEventType() == 1) {
            return;
        }
        AbstractNumTaskInfo abstractNumTaskInfo = numTaskInfoChangedEvent.getTaskInfo();
        if (abstractNumTaskInfo == null) {
            return;
        }
        double d = abstractNumTaskInfo.getLastHorizontalValue();
        Range range = new Range(d - this.visibleLength, d);
        if (abstractNumTaskInfo instanceof DaemonTaskInfo) {
            if (this.customLabel) {
                this.markSeries.addOrUpdate(d, abstractNumTaskInfo.getLastHorizontalLabel());
            }
            this.setRange(range);
            this.oldValue = d;
            return;
        }
        if (this.oldValue == d) {
            return;
        }
        Vector vector = abstractNumTaskInfo.getTempHorizontalLabel();
        if (this.customLabel) {
            this.markSeries.add(d, abstractNumTaskInfo.getLastHorizontalLabel());
            MarkItem markItem = null;
            if (!vector.isEmpty()) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    markItem = (MarkItem)vector.get(i);
                    if (markItem == null) continue;
                    this.markSeries.add(markItem);
                }
            }
        }
        vector.clear();
        if (this.autoscroll) {
            this.setRange(range);
        }
        this.axisEvent.setLowerValue(range.getLowerBound());
        this.axisEvent.setUpperValue(range.getUpperBound());
        this.axisEvent.setBeginValue(range.getUpperBound());
        this.oldValue = d;
        this.fireAxisChange(this.axisEvent);
    }

    private boolean needDrawTick(String string) {
        if (!this.beginValueEnabled) {
            return true;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        double d = Double.parseDouble(string);
        return d >= this.beginValue;
    }

    protected double getValueAtAxis(double d) {
        if (this.dataArea != null) {
            double d2 = 0.0;
            double d3 = this.dataArea.getWidth();
            double d4 = this.dataArea.getMinX();
            if (d < d4 || d > d4 + d3) {
                return Double.NaN;
            }
            d2 = (d - d4) / d3;
            double d5 = this.getUpperBound() - this.getLowerBound();
            double d6 = d5 * d2;
            double d7 = this.getLowerBound() + d6;
            return d7;
        }
        return Double.NaN;
    }

    public void setShowTaskNum(boolean bl) {
        this.isShowTaskNum = bl;
    }

    public Hashtable getTaskNamePosition() {
        return this.taskNamePosition;
    }

    final void setPointerVisible(boolean bl) {
        this.isPointerVisible = bl;
    }

    final boolean isPointerVisible() {
        return this.isPointerVisible && !this.isShowTaskNum;
    }

    final void drawPointer(Graphics2D graphics2D) {
        if (this.isPointerVisible()) {
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 2);
            graphics2D.setPaint(Color.RED);
            graphics2D.setStroke(basicStroke);
            this.setPointerPercent(this.percent);
            double d = this.dataArea.getMinX();
            double d2 = this.dataArea.getMaxX();
            if (this.pointerPosition < d) {
                this.pointerPosition = d;
            } else if (this.pointerPosition > d2) {
                this.pointerPosition = d2;
            }
            Line2D.Double double_ = new Line2D.Double(this.pointerPosition, this.dataArea.getMinY(), this.pointerPosition, this.dataArea.getMaxY());
            graphics2D.draw(double_);
            double d3 = this.getTickMarkOutsideLength();
            double d4 = this.getTickMarkInsideLength();
            double d5 = this.dataArea.getMaxY();
            Line2D.Double double_2 = new Line2D.Double(this.pointerPosition, d5 + d3 + 22.0, this.pointerPosition, d5 - d4);
            graphics2D.draw(double_2);
            int n = (int)(d5 + d3 + 22.0);
            Line2D.Double double_3 = new Line2D.Double(this.pointerPosition - 8.0, n + 8, this.pointerPosition, n);
            Line2D.Double double_4 = new Line2D.Double(this.pointerPosition, n, this.pointerPosition + 8.0, n + 8);
            Line2D.Double double_5 = new Line2D.Double(this.pointerPosition - 8.0, n + 8, this.pointerPosition + 8.0, n + 8);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
            graphics2D.draw(double_5);
            int n2 = (int)(this.pointerPosition + 0.5);
            this.xpoints = new int[]{n2 - 8, n2, n2 + 8};
            this.ypoints = new int[]{n + 8, n, n + 8};
            Polygon polygon = new Polygon(this.xpoints, this.ypoints, 3);
            graphics2D.fill(polygon);
        }
    }

    final double getPointerPosition() {
        return this.pointerPosition;
    }

    final double getGap() {
        return this.gap;
    }

    final void setPointPostion(int n) {
        if (this.dataArea == null) {
            return;
        }
        double d = this.dataArea.getMinX();
        double d2 = this.dataArea.getMaxX();
        double d3 = d2 - d;
        if (d3 > 0.0) {
            double d4;
            ListIterator listIterator = this.units.listIterator();
            while (listIterator.hasNext() && !((d4 = ((Double)listIterator.next()).doubleValue()) - (double)n > this.gap / 4.0)) {
                this.pointerPosition = d4;
            }
            this.percent = (this.pointerPosition - d) / d3;
        }
    }

    final void setPointerPercent(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        this.percent = d;
        if (this.dataArea == null) {
            return;
        }
        double d2 = this.dataArea.getMinX();
        double d3 = this.dataArea.getMaxX();
        double d4 = d3 - d2;
        if (d4 > 0.0) {
            this.setPointPostion((int)(d2 + d4 * d));
        }
    }

    final boolean isInPointerScope(int n, int n2) {
        return this.xpoints != null && this.ypoints != null && n2 >= this.ypoints[1] && n2 <= this.ypoints[0] && n >= this.xpoints[0] && n <= this.xpoints[2];
    }

    final double getPointerPositionValue() {
        if (!this.isPointerVisible()) {
            return Double.NaN;
        }
        Range range = this.getRange();
        double d = range.getLength();
        double d2 = range.getLowerBound();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setGroupingUsed(false);
        String string = numberFormat.format(d2 + d * this.percent);
        return Double.parseDouble(string);
    }

    final void resetAxis() {
        this.setRange(0.0 - this.visibleLength, 0.0);
        this.setPointerPercent(1.0);
    }
}

