/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.HorizontalNumberAxis;
import com.swimap.iview.templates.charts.curve.expand.TooltipListener;
import com.swimap.iview.templates.charts.curve.expand.VerticalNumberAxis;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;

public class ExpandChartPanel
extends ChartPanel {
    private TooltipListener tooltipListener = null;
    private int chartIndex = -1;

    public ExpandChartPanel(JFreeChart jFreeChart) {
        super(jFreeChart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
    }

    public ExpandChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(jFreeChart, 680, 420, 300, 200, 800, 600, bl, true, true, true, true, true);
    }

    public ExpandChartPanel(JFreeChart jFreeChart, boolean bl) {
        super(jFreeChart, 680, 420, 300, 200, 800, 600, bl, true, true, true, true, true);
    }

    public ExpandChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(jFreeChart, 680, 420, 300, 200, 800, 600, false, bl, bl2, bl3, bl4, bl5);
    }

    public ExpandChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(jFreeChart, n, n2, n3, n4, n5, n6, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.tooltipListener == null) {
            return super.getToolTipText(mouseEvent);
        }
        return this.tooltipListener.getTooltip(this.getMousePointValue(mouseEvent));
    }

    final Point2D getMousePointValue(MouseEvent mouseEvent) {
        Number number;
        Object object;
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.getScaleX());
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.getScaleY());
        XYPlot xYPlot = this.getChart().getXYPlot();
        HorizontalNumberAxis horizontalNumberAxis = (HorizontalNumberAxis)xYPlot.getDomainAxis();
        if (xYPlot instanceof CombinedDomainXYPlot) {
            object = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            int n3 = this.getSubPlotIndexForMousePosition(mouseEvent.getPoint());
            xYPlot = (XYPlot)object.get(n3);
        }
        if ((number = ((VerticalNumberAxis)((Object)(object = (VerticalNumberAxis)xYPlot.getRangeAxis()))).getValueAtAxis(n2)) == null) {
            return null;
        }
        double d = horizontalNumberAxis.getValueAtAxis(n);
        if (Double.isNaN(d)) {
            return null;
        }
        return new Point2D.Double(d, number.doubleValue());
    }

    final void setTooltipListener(TooltipListener tooltipListener) {
        this.tooltipListener = tooltipListener;
    }

    protected void displayPopupMenu(int n, int n2) {
        XYPlot xYPlot = this.getChart().getXYPlot();
        if (xYPlot instanceof CombinedDomainXYPlot) {
            this.chartIndex = this.getSubPlotIndexForMousePosition(new Point(n, n2));
            if (this.chartIndex == -1) {
                return;
            }
        } else {
            this.chartIndex = 0;
        }
        super.displayPopupMenu(n, n2);
    }

    public int getChartIndexForMouseRightClick() {
        return this.chartIndex;
    }

    private int getSubPlotIndexForMousePosition(Point2D point2D) {
        int n = -1;
        CombinedDomainXYPlot combinedDomainXYPlot = (CombinedDomainXYPlot)this.getChart().getXYPlot();
        int n2 = combinedDomainXYPlot.getSubplots().size();
        PlotRenderingInfo plotRenderingInfo = this.getChartRenderingInfo().getPlotInfo();
        for (int i = 0; i < n2; ++i) {
            PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i);
            if (!plotRenderingInfo2.getDataArea().contains(point2D)) continue;
            n = i;
            break;
        }
        return n;
    }
}

