/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.HorizontalAxisChangedEvent;
import com.swimap.iview.templates.charts.curve.expand.HorizontalAxisChangedListener;
import com.swimap.iview.templates.charts.curve.expand.HorizontalNumberAxis;
import com.swimap.iview.templates.charts.curve.expand.TaskDateRefreshListener;
import com.swimap.iview.templates.charts.curve.expand.dyntrace.DynDebugTracer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.EventListenerList;

public class ChartScrollBar
extends JPanel
implements HorizontalAxisChangedListener,
AdjustmentListener {
    private JScrollBar scrollBar = new JScrollBar(0);
    private static final double DEFAULT_INCREASE_VALUE = 1.0;
    private double increaseValue = 1.0;
    private int maxViewRange = Integer.MAX_VALUE;
    private double beginValue = 0.0;
    private int viewLength = 0;
    private HorizontalNumberAxis xAxis = null;
    private int oldValue = Integer.MIN_VALUE;
    private boolean updateWhileAdjusting = true;
    private transient EventListenerList listenersList = null;
    private boolean isRefresh = false;
    private static final DynDebugTracer dynTracer = DynDebugTracer.getInstance(ChartScrollBar.class);

    public ChartScrollBar() {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("ChartScrollBar()", "Building... ");
        }
        this.setLayout(new BorderLayout());
        this.scrollBar.setEnabled(false);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setValue(0);
        this.add((Component)this.scrollBar, "Center");
    }

    public ChartScrollBar(int n, double d) {
        this();
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("ChartScrollBar(int, double)", "maxViewRange=" + n + ", increaseValue=" + d);
        }
        this.setMaximumViewRange(n);
        this.setIncreaseValue(d);
    }

    public void setMaximumViewRange(int n) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setMaximumViewRange()", "max=" + n);
        }
        if (n > 0) {
            this.maxViewRange = n;
        }
    }

    public int getMaximumViewRange() {
        return this.maxViewRange;
    }

    final void setRefreshDate(boolean bl) {
        this.isRefresh = bl;
    }

    public void setIncreaseValue(double d) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setMaximumViewRange()", "value=" + d);
        }
        if (d > 0.0) {
            this.increaseValue = d;
        }
    }

    public double getIncreaseValue() {
        return this.increaseValue;
    }

    public boolean isUpdateWhileAdjusting() {
        return this.updateWhileAdjusting;
    }

    public void setUpdateWhileAdjusting(boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setUpdateWhileAdjusting()", "updateWhileAdjusting=" + bl);
        }
        this.updateWhileAdjusting = bl;
    }

    @Override
    public void axisRangeChanged(HorizontalAxisChangedEvent horizontalAxisChangedEvent) {
        if (horizontalAxisChangedEvent == null) {
            return;
        }
        if (horizontalAxisChangedEvent.getSource() == null) {
            return;
        }
        this.xAxis = (HorizontalNumberAxis)horizontalAxisChangedEvent.getSource();
        this.viewLength = (int)(horizontalAxisChangedEvent.getUpperValue() - horizontalAxisChangedEvent.getLowerValue());
        if (this.isRefresh && this.scrollBar.isEnabled()) {
            return;
        }
        if (!this.scrollBar.isEnabled() && horizontalAxisChangedEvent.getLowerValue() >= horizontalAxisChangedEvent.getBeginValue()) {
            this.scrollBar.setEnabled(true);
            this.beginValue = horizontalAxisChangedEvent.getBeginValue();
        } else if (!this.scrollBar.isEnabled()) {
            return;
        }
        int n = (int)this.calculateMaximum(horizontalAxisChangedEvent);
        int n2 = (int)this.calculateMinimum(horizontalAxisChangedEvent);
        if (this.isRefresh) {
            this.scrollBar.setValues(n, 0, n2, this.maxViewRange);
            return;
        }
        this.scrollBar.removeAdjustmentListener(this);
        if (this.xAxis.isAutoscroll()) {
            this.scrollBar.setValues(n, 0, n2, n);
        } else {
            int n3 = this.scrollBar.getValue();
            if (n3 <= n2) {
                this.scrollBar.setValues(n2, 0, n2, n);
                this.setRange();
            } else {
                this.scrollBar.setValues(n3, 0, n2, n);
            }
        }
        this.scrollBar.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.scrollBar.getValueIsAdjusting() && !this.updateWhileAdjusting) {
            return;
        }
        if (this.xAxis == null || adjustmentEvent == null) {
            return;
        }
        if (this.oldValue == adjustmentEvent.getValue()) {
            return;
        }
        this.oldValue = adjustmentEvent.getValue();
        this.setRange();
    }

    private void setRange() {
        double d;
        double d2 = (double)this.scrollBar.getValue() * this.increaseValue + this.beginValue;
        if (d2 > (d = d2 - (double)this.viewLength)) {
            if (this.isRefresh) {
                this.fireDateRefresh(d, d2);
            }
            this.xAxis.setRange(d, d2);
        }
    }

    final void updateAxisRange() {
        double d;
        double d2 = (double)this.scrollBar.getValue() * this.increaseValue + this.beginValue;
        if (d2 > (d = d2 - (double)this.viewLength)) {
            this.xAxis.setRange(d, d2);
        }
    }

    private void fireDateRefresh(double d, double d2) {
        if (this.listenersList == null) {
            return;
        }
        Object[] objectArray = this.listenersList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TaskDateRefreshListener.class) continue;
            ((TaskDateRefreshListener)objectArray[i + 1]).dateRefresh(d, d2);
        }
    }

    public synchronized void addDateRefreshListener(TaskDateRefreshListener taskDateRefreshListener) {
        if (taskDateRefreshListener == null) {
            return;
        }
        if (this.listenersList == null) {
            this.listenersList = new EventListenerList();
        }
        this.listenersList.add(TaskDateRefreshListener.class, taskDateRefreshListener);
    }

    public synchronized void removeDateRefreshListener(TaskDateRefreshListener taskDateRefreshListener) {
        if (taskDateRefreshListener == null) {
            return;
        }
        if (this.listenersList == null) {
            return;
        }
        this.listenersList.remove(TaskDateRefreshListener.class, taskDateRefreshListener);
    }

    final JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    private double calculateMaximum(HorizontalAxisChangedEvent horizontalAxisChangedEvent) {
        double d = horizontalAxisChangedEvent.getUpperValue();
        double d2 = horizontalAxisChangedEvent.getBeginValue();
        double d3 = (d - d2) / this.increaseValue;
        return d3;
    }

    private double calculateMinimum(HorizontalAxisChangedEvent horizontalAxisChangedEvent) {
        double d = this.calculateMaximum(horizontalAxisChangedEvent);
        double d2 = horizontalAxisChangedEvent.getUpperValue() - horizontalAxisChangedEvent.getLowerValue();
        double d3 = d - ((double)this.maxViewRange - d2) / this.increaseValue;
        double d4 = d2 / this.increaseValue;
        d3 = Math.max(d3, d4);
        return d3;
    }
}

