/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.AbstractNumTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.BarTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.ChartScrollBar;
import com.swimap.iview.templates.charts.curve.expand.DaemonTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.ExpandChartPanel;
import com.swimap.iview.templates.charts.curve.expand.HorizontalNumberAxis;
import com.swimap.iview.templates.charts.curve.expand.MarkNumberFormat;
import com.swimap.iview.templates.charts.curve.expand.NumTaskInfoChangedEvent;
import com.swimap.iview.templates.charts.curve.expand.NumTaskInfoChangedListener;
import com.swimap.iview.templates.charts.curve.expand.NumXYBarRenderer;
import com.swimap.iview.templates.charts.curve.expand.NumXYPlot;
import com.swimap.iview.templates.charts.curve.expand.NumXYSingleBarRenderer;
import com.swimap.iview.templates.charts.curve.expand.PointerChangeListener;
import com.swimap.iview.templates.charts.curve.expand.SeriesTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.SingleBarTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.TooltipListener;
import com.swimap.iview.templates.charts.curve.expand.VerticalNumberAxis;
import com.swimap.iview.templates.charts.curve.expand.dyntrace.DynDebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.UnitType;

public class ChartGraphPanelEx
extends JPanel
implements NumTaskInfoChangedListener {
    private static IviewLogger logger = IviewLogger.getLogger(ChartGraphPanelEx.class, "IVIEW");
    private static final int DEFAULT_MAX_ITEM = 5000;
    private static final int DEFAULT_MAX_TASK = 10;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "{0}: ({1}, {2})";
    private Hashtable taskHashtable = new Hashtable(10);
    private ExpandChartPanel chartPanel = null;
    private HorizontalNumberAxis xAxis = null;
    private final String title;
    private final boolean legend = false;
    private final boolean showToolTip = true;
    private int maxItem = 5000;
    private int maxTask = 10;
    private DaemonTaskInfo daemonTask = null;
    private ChartScrollBar scrollBar = null;
    private NumberFormat xFormat = null;
    private NumberFormat yFormat = null;
    private String tooltipFormat = "{0}: ({1}, {2})";
    private static final DynDebugTracer dynTracer = DynDebugTracer.getInstance(ChartGraphPanelEx.class);
    private boolean isSingleTaskCharPanel = false;
    private Comparator singleTaskComparator = null;
    private int singleBarTaskInfoNum = 0;
    private NumberFormat valueFormat = null;
    private static final String SIGLEBAR_TASK_TOOLTIPFORMAT = "\u4efb\u52a1_{0}:\u7eb5:{2}";
    private double barTaskBarWidth = Double.NaN;
    private JLabel beginTime = new JLabel();
    private transient EventListenerList listenerList = new EventListenerList();
    private MouseHandler mouseHandler = null;
    private int[] chartWeight = null;

    public ChartGraphPanelEx() {
        this(DEFAULT_TOOL_TIP_FORMAT);
    }

    public ChartGraphPanelEx(int[] nArray) {
        this(DEFAULT_TOOL_TIP_FORMAT, nArray);
    }

    public ChartGraphPanelEx(String string) {
        this(string, null);
    }

    public ChartGraphPanelEx(String string, int[] nArray) {
        this.title = null;
        this.chartWeight = nArray;
        this.init();
        this.tooltipFormat = string;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("ChartGraphPanelEx()", "tooltipFormat=" + string);
        }
    }

    public ChartGraphPanelEx(String string, boolean bl) {
        this.title = null;
        this.isSingleTaskCharPanel = bl;
        this.init();
        this.tooltipFormat = string == null ? SIGLEBAR_TASK_TOOLTIPFORMAT : string;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("ChartGraphPanelEx()", "tooltipFormat=" + string);
            dynTracer.trace("ChartGraphPanelEx()", "isSingleTaskCharPanel=" + bl);
        }
    }

    private void init() {
        JFreeChart jFreeChart = this.createBlankChart();
        jFreeChart.setBackgroundPaint(null);
        this.chartPanel = new ExpandChartPanel(jFreeChart, true);
        this.chartPanel.setMaximumDrawHeight(1000);
        this.chartPanel.setMaximumDrawWidth(1200);
        this.chartPanel.setMinimumDrawHeight(150);
        this.chartPanel.setMinimumDrawWidth(250);
        this.chartPanel.setPopupMenu(null);
        this.setGridLineVisible(false, false);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.chartPanel), "Center");
        this.beginTime.setFocusable(false);
        this.beginTime.setHorizontalAlignment(0);
        this.add((Component)this.beginTime, "South");
    }

    private JFreeChart createBlankChart() {
        NumXYPlot numXYPlot;
        this.xAxis = new HorizontalNumberAxis();
        this.xAxis.setMaximumItemCount(this.maxItem);
        this.xAxis.setAutoRangeIncludesZero(false);
        this.xAxis.setShowTaskNum(this.isSingleTaskCharPanel);
        this.xFormat = new MarkNumberFormat(this.xAxis.getMarkSeries(), NumberFormat.getInstance());
        this.yFormat = NumberFormat.getInstance();
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        Object object = null;
        if (this.chartWeight == null) {
            object = new NumXYPlot(null, (ValueAxis)this.xAxis, (ValueAxis)verticalNumberAxis, (XYItemRenderer)xYLineAndShapeRenderer);
            object.setRangeAxis(1, (ValueAxis)verticalNumberAxis);
            object.setAxisOffset(new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 5.0));
        } else {
            object = new CombinedDomainXYPlot((ValueAxis)this.xAxis);
            object.setAxisOffset(new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 0.0));
            numXYPlot = null;
            RectangleInsets rectangleInsets = null;
            for (int i = 0; i < this.chartWeight.length; ++i) {
                numXYPlot = new NumXYPlot(null, (ValueAxis)this.xAxis, (ValueAxis)verticalNumberAxis, (XYItemRenderer)xYLineAndShapeRenderer);
                numXYPlot.setOrientation(PlotOrientation.VERTICAL);
                numXYPlot.setRangeAxis(1, (ValueAxis)verticalNumberAxis);
                rectangleInsets = new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 5.0);
                numXYPlot.setAxisOffset(rectangleInsets);
                object.add((XYPlot)numXYPlot, this.chartWeight[i]);
                verticalNumberAxis = new VerticalNumberAxis();
            }
        }
        object.setOrientation(PlotOrientation.VERTICAL);
        numXYPlot = new JFreeChart(this.title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)object, this.legend);
        numXYPlot.setBackgroundPaint(Color.white);
        numXYPlot.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        return numXYPlot;
    }

    public boolean addTask(AbstractNumTaskInfo abstractNumTaskInfo) {
        return this.addTask(abstractNumTaskInfo, 0);
    }

    public boolean addTask(AbstractNumTaskInfo abstractNumTaskInfo, int n) {
        XYPlot xYPlot;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("addTask()", "Taskinfo=" + abstractNumTaskInfo);
        }
        boolean bl = true;
        if (abstractNumTaskInfo == null) {
            logger.trace("AddTask return false. Reason: Argument numTaskInfo is null.");
            return false;
        }
        if (abstractNumTaskInfo instanceof DaemonTaskInfo) {
            if (this.daemonTask == null) {
                this.daemonTask = (DaemonTaskInfo)abstractNumTaskInfo;
                bl = false;
            } else {
                logger.trace("AddTask return false.Reason: One Daemon Task has been added.");
                return false;
            }
        }
        if (bl && this.taskHashtable.size() >= this.maxTask) {
            logger.trace("AddTask return false.Reason: Current task count has reached upper limit.");
            return false;
        }
        if (bl && this.taskHashtable.containsKey(abstractNumTaskInfo.getTaskName())) {
            logger.trace("AddTask return false. Reason: task name '" + abstractNumTaskInfo.getTaskName() + "'is duplicate.");
            return false;
        }
        abstractNumTaskInfo.setMaximumItemCount(this.maxItem);
        abstractNumTaskInfo.setAddedToGraph(true);
        abstractNumTaskInfo.addChangedListener(this.xAxis);
        abstractNumTaskInfo.addChangedListener(this);
        this.getClass();
        abstractNumTaskInfo.setTooltipFormat(this.tooltipFormat, this.xFormat, this.yFormat);
        if (!(abstractNumTaskInfo instanceof DaemonTaskInfo)) {
            this.taskHashtable.put(abstractNumTaskInfo.getTaskName(), abstractNumTaskInfo);
        }
        if ((xYPlot = this.chartPanel.getChart().getXYPlot()) instanceof CombinedDomainXYPlot) {
            xYPlot = this.getPlot(n);
        }
        abstractNumTaskInfo.customXYPlot(xYPlot);
        if (abstractNumTaskInfo instanceof SingleBarTaskInfo) {
            ++this.singleBarTaskInfoNum;
            double d = this.barTaskBarWidth = Double.isNaN(this.barTaskBarWidth) ? 0.2 : this.barTaskBarWidth;
            if (this.singleTaskComparator != null) {
                this.resetSingleBarTaskPositionByName(this.barTaskBarWidth);
            } else {
                ((NumXYSingleBarRenderer)((SingleBarTaskInfo)abstractNumTaskInfo).getRenderer()).setXPosition(1.0);
                this.resetSingleBarTaskPositionByX(this.barTaskBarWidth);
            }
        }
        return true;
    }

    public void resetSingleBarTaskPositionByName(double d) {
        int n;
        double d2 = d * (double)this.singleBarTaskInfoNum;
        d2 = d2 > 1.0 ? 1.0 : d2;
        double d3 = d2 / (double)this.singleBarTaskInfoNum;
        double d4 = (1.0 - d2) / 2.0;
        String[] stringArray = new String[this.taskHashtable.size()];
        Enumeration enumeration = this.taskHashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        if (this.singleTaskComparator != null) {
            Arrays.sort(stringArray, this.singleTaskComparator);
        }
        ArrayList arrayList = new ArrayList(this.taskHashtable.size());
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(this.taskHashtable.get(stringArray[n]));
        }
        n = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            AbstractNumTaskInfo abstractNumTaskInfo = (AbstractNumTaskInfo)arrayList.get(i);
            if (!(abstractNumTaskInfo instanceof SingleBarTaskInfo)) continue;
            SingleBarTaskInfo singleBarTaskInfo = (SingleBarTaskInfo)abstractNumTaskInfo;
            NumXYSingleBarRenderer numXYSingleBarRenderer = (NumXYSingleBarRenderer)singleBarTaskInfo.getRenderer();
            numXYSingleBarRenderer.setWidth(d3);
            numXYSingleBarRenderer.setXPosition((double)n * d3 + d4);
            numXYSingleBarRenderer.setVerticalNumberFormat(this.valueFormat);
            if (this.xAxis != null) {
                this.xAxis.getTaskNamePosition().put(singleBarTaskInfo.getTaskName(), new Double((double)n * d3 + d4 + d3 / 2.0));
            }
            ++n;
        }
    }

    public void resetSingleBarTaskPositionByX(double d) {
        ArrayList<AbstractNumTaskInfo> arrayList = new ArrayList<AbstractNumTaskInfo>(this.taskHashtable.size());
        Enumeration enumeration = this.taskHashtable.elements();
        while (enumeration.hasMoreElements()) {
            AbstractNumTaskInfo abstractNumTaskInfo = (AbstractNumTaskInfo)enumeration.nextElement();
            if (!(abstractNumTaskInfo instanceof SingleBarTaskInfo)) continue;
            arrayList.add(abstractNumTaskInfo);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (!(arrayList.get(j) instanceof SingleBarTaskInfo)) continue;
                NumXYSingleBarRenderer numXYSingleBarRenderer = (NumXYSingleBarRenderer)((SingleBarTaskInfo)arrayList.get(i)).getRenderer();
                NumXYSingleBarRenderer numXYSingleBarRenderer2 = (NumXYSingleBarRenderer)((SingleBarTaskInfo)arrayList.get(j)).getRenderer();
                if (!(numXYSingleBarRenderer.getXPosition() > numXYSingleBarRenderer2.getXPosition())) continue;
                SingleBarTaskInfo singleBarTaskInfo = (SingleBarTaskInfo)arrayList.get(i);
                arrayList.set(i, (AbstractNumTaskInfo)arrayList.get(j));
                arrayList.set(j, singleBarTaskInfo);
            }
        }
        double d2 = d * (double)this.singleBarTaskInfoNum;
        d2 = d2 > 1.0 ? 1.0 : d2;
        double d3 = d2 / (double)this.singleBarTaskInfoNum;
        double d4 = (1.0 - d2) / 2.0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            SingleBarTaskInfo singleBarTaskInfo = (SingleBarTaskInfo)arrayList.get(i);
            ((NumXYSingleBarRenderer)singleBarTaskInfo.getRenderer()).setWidth(d3);
            ((NumXYSingleBarRenderer)singleBarTaskInfo.getRenderer()).setXPosition((double)i * d3 + d4);
            ((NumXYSingleBarRenderer)singleBarTaskInfo.getRenderer()).setVerticalNumberFormat(this.valueFormat);
            if (this.xAxis == null) continue;
            this.xAxis.getTaskNamePosition().put(singleBarTaskInfo.getTaskName(), new Double((double)i * d3 + d4 + d3 / 2.0));
        }
    }

    public boolean removeTask(String string) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("removeTask()", "taskName=" + string);
        }
        if (string == null || !this.taskHashtable.containsKey(string)) {
            return false;
        }
        AbstractNumTaskInfo abstractNumTaskInfo = (AbstractNumTaskInfo)this.taskHashtable.remove(string);
        if (abstractNumTaskInfo instanceof SingleBarTaskInfo) {
            --this.singleBarTaskInfoNum;
            if (this.singleTaskComparator != null) {
                this.resetSingleBarTaskPositionByName(this.barTaskBarWidth);
            } else {
                this.resetSingleBarTaskPositionByX(this.barTaskBarWidth);
            }
            if (this.xAxis != null && this.xAxis.getTaskNamePosition().containsKey(string)) {
                this.xAxis.getTaskNamePosition().remove(string);
            }
        }
        abstractNumTaskInfo.removeChangedListener(this.xAxis);
        XYPlot xYPlot = this.getPlotForTaskInfo(abstractNumTaskInfo);
        abstractNumTaskInfo.removeSelf(xYPlot);
        abstractNumTaskInfo = null;
        return true;
    }

    public boolean deleteTask(String string) {
        return this.removeTask(string);
    }

    public AbstractNumTaskInfo[] getTaskList() {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("getTaskList()", "start to getTaskList.");
        }
        if (this.taskHashtable.isEmpty()) {
            return new AbstractNumTaskInfo[0];
        }
        AbstractNumTaskInfo[] abstractNumTaskInfoArray = new AbstractNumTaskInfo[this.taskHashtable.size()];
        this.taskHashtable.values().toArray(abstractNumTaskInfoArray);
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("getTaskList()", "end of getTaskList, task length=" + abstractNumTaskInfoArray.length);
        }
        return abstractNumTaskInfoArray;
    }

    public AbstractNumTaskInfo getTaskInfo(String string) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("getTaskInfo(String)", "start to getTaskList.");
        }
        return (AbstractNumTaskInfo)this.taskHashtable.get(string);
    }

    public JPopupMenu getPopupMenu() {
        return this.chartPanel.getPopupMenu();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setPopupMenu()", "set PopupMenu=" + jPopupMenu);
        }
        this.chartPanel.setPopupMenu(jPopupMenu);
    }

    public void setMaximumItemCount(int n) throws IllegalStateException {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setMaximumItemCount()", "maxCount=" + n);
        }
        if (this.daemonTask != null || this.taskHashtable.size() > 0) {
            throw new IllegalStateException("Must invoke this method before add task to chart graph panel");
        }
        if (n < 0) {
            return;
        }
        this.maxItem = n;
        this.xAxis.setMaximumItemCount(this.maxItem);
    }

    public void setTooltipFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setTooltipFormat()", "formatx=" + numberFormat + ",formaty=" + numberFormat2);
        }
        if (this.daemonTask != null || this.taskHashtable.size() > 0) {
            throw new IllegalStateException("Must invoke this method before add task to chart graph panel");
        }
        if (numberFormat != null) {
            this.xFormat = new MarkNumberFormat(this.xAxis.getMarkSeries(), numberFormat);
        }
        if (numberFormat2 != null) {
            this.yFormat = numberFormat2;
        }
    }

    public int getMaximumItemCount() {
        return this.maxItem;
    }

    public void setMaximumTaskCount(int n) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setMaximumTaskCount()", "maxCount=" + n);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Maximum task count can't be negative. maximum = " + n);
        }
        if (n < this.taskHashtable.size()) {
            throw new IllegalArgumentException("Maximum task count can't be less than current task count. maximum = " + n);
        }
        this.maxTask = n;
    }

    public int getMaximumTaskCount() {
        return this.maxTask;
    }

    public int getTaskCount() {
        return this.taskHashtable.size();
    }

    public void addScrollBar(ChartScrollBar chartScrollBar) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("addScrollBar()", "ChartScrollBar=" + chartScrollBar);
        }
        if (chartScrollBar == null) {
            return;
        }
        this.scrollBar = chartScrollBar;
        this.xAxis.addRangeChangedListener(this.scrollBar);
        ScrollBarHandler scrollBarHandler = new ScrollBarHandler();
        Component[] componentArray = this.scrollBar.getScrollBar().getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            componentArray[i].addMouseListener(scrollBarHandler);
        }
        this.scrollBar.getScrollBar().addMouseListener(scrollBarHandler);
    }

    public void removeScrollBar() {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("removeScrollBar()", "scrollBar=" + this.scrollBar);
        }
        if (this.scrollBar != null) {
            this.xAxis.removeRangeChangedListener(this.scrollBar);
            this.scrollBar = null;
        }
    }

    public void setAutoscroll(boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setAutoscroll()", "auto=" + bl);
        }
        this.xAxis.setAutoscroll(bl);
    }

    public boolean isAutoscroll() {
        return this.xAxis.isAutoscroll();
    }

    public void setChartBackground(Color color) {
        JFreeChart jFreeChart;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setAutoscroll()", "Color=" + color);
        }
        if ((jFreeChart = this.chartPanel.getChart()) != null) {
            jFreeChart.setBackgroundPaint((Paint)color);
        }
        if (this.scrollBar != null) {
            this.scrollBar.setBackground(color);
        }
    }

    public void setGridLineVisible(boolean bl, boolean bl2) {
        XYPlot xYPlot;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setGridLineVisible()", "horizontal = " + bl + ", vertical=" + bl2);
        }
        if ((xYPlot = this.chartPanel.getChart().getXYPlot()) instanceof CombinedDomainXYPlot) {
            List list = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            int n = list.size();
            XYPlot xYPlot2 = null;
            for (int i = 0; i < n; ++i) {
                xYPlot2 = (XYPlot)list.get(i);
                xYPlot2.setDomainGridlinesVisible(bl2);
                xYPlot2.setRangeGridlinesVisible(bl);
            }
        } else {
            xYPlot.setDomainGridlinesVisible(bl2);
            xYPlot.setRangeGridlinesVisible(bl);
        }
    }

    public void setGridLineVisible(int n, boolean bl, boolean bl2) {
        XYPlot xYPlot = this.getPlot(n);
        if (xYPlot != null) {
            xYPlot.setDomainGridlinesVisible(bl2);
            xYPlot.setRangeGridlinesVisible(bl);
        }
    }

    public void setGridLineColor(Paint paint, Paint paint2) {
        XYPlot xYPlot;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setGridLineColor()", "horizontal = " + paint + ", vertical = " + paint2);
        }
        if ((xYPlot = this.chartPanel.getChart().getXYPlot()) instanceof CombinedDomainXYPlot) {
            List list = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            int n = list.size();
            XYPlot xYPlot2 = null;
            for (int i = 0; i < n; ++i) {
                xYPlot2 = (XYPlot)list.get(i);
                xYPlot2.setDomainGridlinePaint(paint2);
                xYPlot2.setRangeGridlinePaint(paint);
            }
        } else {
            xYPlot.setDomainGridlinePaint(paint2);
            xYPlot.setRangeGridlinePaint(paint);
        }
    }

    public void setGridLineColor(int n, Paint paint, Paint paint2) {
        XYPlot xYPlot = this.getPlot(n);
        if (xYPlot != null) {
            xYPlot.setDomainGridlinePaint(paint2);
            xYPlot.setRangeGridlinePaint(paint);
        }
    }

    public void setGridlineStroke(Stroke stroke, Stroke stroke2) {
        XYPlot xYPlot;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setGridLineStroke()", "horizontal = " + stroke + ", vertical = " + stroke2);
        }
        if ((xYPlot = this.chartPanel.getChart().getXYPlot()) instanceof CombinedDomainXYPlot) {
            List list = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            int n = list.size();
            XYPlot xYPlot2 = null;
            for (int i = 0; i < n; ++i) {
                xYPlot2 = (XYPlot)list.get(i);
                xYPlot2.setDomainGridlineStroke(stroke2);
                xYPlot2.setRangeGridlineStroke(stroke);
            }
        } else {
            xYPlot.setDomainGridlineStroke(stroke2);
            xYPlot.setRangeGridlineStroke(stroke);
        }
    }

    public void setGridlineStroke(int n, Stroke stroke, Stroke stroke2) {
        XYPlot xYPlot = this.getPlot(n);
        if (xYPlot != null) {
            xYPlot.setDomainGridlineStroke(stroke2);
            xYPlot.setRangeGridlineStroke(stroke);
        }
    }

    public void close() {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("close()", "Release resource.");
        }
        AbstractNumTaskInfo[] abstractNumTaskInfoArray = this.getTaskList();
        for (int i = 0; i < abstractNumTaskInfoArray.length; ++i) {
            abstractNumTaskInfoArray[i].clear();
            abstractNumTaskInfoArray[i].removeSelf(this.getPlotForTaskInfo(abstractNumTaskInfoArray[i]));
            abstractNumTaskInfoArray[i].removeChangedListener(this);
            abstractNumTaskInfoArray[i].removeChangedListener(this.xAxis);
        }
        this.taskHashtable.clear();
        this.xAxis.clear();
    }

    public String getHorizontalLabel() {
        return this.xAxis.getLabel();
    }

    public void setHorizontalLabel(String string) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalLabel()", "label=" + string);
        }
        this.xAxis.setLabel(string);
    }

    public void setHorizontalVisibleLength(double d) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalVisibleLength()", "length=" + d);
        }
        this.xAxis.setVisibleLength(d);
    }

    public double getHorizontalVisibleLength() {
        return this.xAxis.getVisibleLength();
    }

    public void setHorizontalRange(double d, double d2) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalRange()", "lower = " + d + ", upper=" + d2);
        }
        this.xAxis.setRange(d, d2);
    }

    public void setHorizontalTickUnit(double d) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalTickUnit(double)", "size=" + d);
        }
        this.xAxis.setTickUnitSize(d);
    }

    public void setHorizontalTickUnit(double d, NumberFormat numberFormat) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalTickUnit(double, NumberFormat)", "size = " + d + ", formatter=" + numberFormat);
        }
        this.xAxis.setTickUnitSize(d, numberFormat);
    }

    public void setHorizontalTickUnit(double[] dArray, NumberFormat numberFormat) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalTickUnit(double[], NumberFormat)", "size[] = " + this.printArray(dArray) + ", formatter=" + numberFormat);
        }
        this.xAxis.setTickUnitSize(dArray, numberFormat);
    }

    public void setHorizontalTickUnit(double[] dArray) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalTickUnit(double[])", "size[]=" + this.printArray(dArray));
        }
        this.xAxis.setTickUnitSize(dArray);
    }

    public void setHorizontalBasicScaleUnit(int n) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalBasicScaleUnit()", "count=" + n);
        }
        this.xAxis.setBasicScaleUnit(n);
    }

    public int getHorizontalBasicScaleUnit() {
        return this.xAxis.getBasicScaleUnit();
    }

    public void setHorizontalBeginValue(double d) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalBeginValue()", "beginValue=" + d);
        }
        this.xAxis.setBeginValue(d);
    }

    public double getHorizontalBeginValue() {
        return this.xAxis.getBeginValue();
    }

    public void setHorizontalBeginValueEnabled(boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalBeginValueEnabled()", "beginValueEnabled=" + bl);
        }
        this.xAxis.setBeginValueEnabled(bl);
    }

    public boolean isHorizontalBeginValueEnabled() {
        return this.xAxis.isBeginValueEnabled();
    }

    public void setHorizontalCustomLabelEnabled(boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalCustomLabelEnabled()", "flag=" + bl);
        }
        if (this.daemonTask != null || this.taskHashtable.size() > 0) {
            throw new IllegalStateException("Must invoke this method before add task to chart graph panel");
        }
        this.xAxis.setCustomLabelEnabled(bl);
    }

    public boolean isHorizontalCustomLabelEnabled() {
        return this.xAxis.isCustomLabelEnabled();
    }

    public void setHorizontalAngle(double d, TextAnchor textAnchor) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setHorizontalAngle()", "double = " + d + ", TextAnchor=" + textAnchor);
        }
        this.xAxis.setAngle(d, textAnchor);
    }

    public double getHorizontalAngle() {
        return this.xAxis.getAngle();
    }

    public TextAnchor getHorizontalTextAnchor() {
        return this.xAxis.getTextAnchor();
    }

    public String getVerticalLabel() {
        return this.getVerticalLabel(0);
    }

    public String getVerticalLabel(int n) {
        return this.getVerticalLabel(n, 0);
    }

    public String getVerticalLabel(int n, int n2) {
        Axis axis = this.getVerticalAxis(n, n2);
        if (axis != null) {
            return axis.getLabel();
        }
        return null;
    }

    public void setVerticalLabel(String string) {
        this.setVerticalLabel(0, string);
        this.setVerticalLabel(1, string);
    }

    public void setVerticalLabel(int n, String string) {
        this.setVerticalLabel(n, 0, string);
    }

    public void setVerticalLabel(int n, int n2, String string) {
        Axis axis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalLabel()", "label=" + string);
        }
        if ((axis = this.getVerticalAxis(n, n2)) != null) {
            axis.setLabel(string);
        }
    }

    public void setVerticalRange(double d, double d2) {
        this.setVerticalRange(0, d, d2);
        this.setVerticalRange(1, d, d2);
    }

    public void setVerticalRange(int n, double d, double d2) {
        this.setVerticalRange(n, 0, d, d2);
    }

    public void setVerticalRange(int n, int n2, double d, double d2) {
        VerticalNumberAxis verticalNumberAxis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalRange()", "lower = " + d + ", upper = " + d2);
        }
        if ((verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2)) != null) {
            verticalNumberAxis.setRange(d, d2);
        }
    }

    public void setVerticalTickUnit(double d) {
        this.setVerticalTickUnit(0, d);
        this.setVerticalTickUnit(1, d);
    }

    public void setVerticalTickUnit(int n, double d) {
        this.setVerticalTickUnit(n, 0, d);
    }

    public void setVerticalTickUnit(int n, int n2, double d) {
        VerticalNumberAxis verticalNumberAxis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalTickUnit(double)", "size=" + d);
        }
        if ((verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2)) != null) {
            verticalNumberAxis.setTickUnitSize(d);
        }
    }

    public void setVerticalTickUnit(double[] dArray) {
        this.setVerticalTickUnit(0, dArray);
        this.setVerticalTickUnit(1, dArray);
    }

    public void setVerticalTickUnit(int n, double[] dArray) {
        this.setVerticalTickUnit(n, 0, dArray);
    }

    public void setVerticalTickUnit(int n, int n2, double[] dArray) {
        VerticalNumberAxis verticalNumberAxis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalTickUnit(double[])", "size[]=" + this.printArray(dArray));
        }
        if ((verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2)) != null) {
            verticalNumberAxis.setTickUnitSize(dArray);
        }
    }

    public void setVerticalTickUnit(double d, NumberFormat numberFormat) {
        this.setVerticalTickUnit(0, d, numberFormat);
        this.setVerticalTickUnit(1, d, numberFormat);
    }

    public void setVerticalTickUnit(int n, double d, NumberFormat numberFormat) {
        this.setVerticalTickUnit(n, 0, d, numberFormat);
    }

    public void setVerticalTickUnit(int n, int n2, double d, NumberFormat numberFormat) {
        VerticalNumberAxis verticalNumberAxis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalTickUnit(double, NumberFormat)", "size=" + d + ", formatter=" + numberFormat);
        }
        if ((verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2)) != null) {
            verticalNumberAxis.setTickUnitSize(d, numberFormat);
        }
    }

    public void setVerticalTickUnit(double[] dArray, NumberFormat numberFormat) {
        this.setVerticalTickUnit(0, dArray, numberFormat);
        this.setVerticalTickUnit(1, dArray, numberFormat);
    }

    public void setVerticalTickUnit(int n, double[] dArray, NumberFormat numberFormat) {
        this.setVerticalTickUnit(n, 0, dArray, numberFormat);
    }

    public void setVerticalTickUnit(int n, int n2, double[] dArray, NumberFormat numberFormat) {
        VerticalNumberAxis verticalNumberAxis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalTickUnit(double[], NumberFormat)", "size[]=" + this.printArray(dArray) + ", formatter=" + numberFormat);
        }
        if ((verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2)) != null) {
            verticalNumberAxis.setTickUnitSize(dArray, numberFormat);
        }
    }

    private String printArray(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dArray == null) {
            return "null";
        }
        int n = dArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        stringBuilder.append('[');
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i]);
            if (dArray.length > 20 && i == 19) {
                return stringBuilder.append("...]").toString();
            }
            if (i >= n) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(']').toString();
    }

    public void setVerticalBasicScaleUnit(int n) {
        this.setVerticalBasicScaleUnit(0, n);
        this.setVerticalBasicScaleUnit(1, n);
    }

    public void setVerticalBasicScaleUnit(int n, int n2) {
        this.setVerticalBasicScaleUnit(n, 0, n2);
    }

    public void setVerticalBasicScaleUnit(int n, int n2, int n3) {
        VerticalNumberAxis verticalNumberAxis;
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVerticalBasicScaleUnit()", "count=" + n3);
        }
        if ((verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2)) != null) {
            verticalNumberAxis.setBasicScaleUnit(n3);
        }
    }

    public int getVerticalBasicScaleUnit() {
        return this.getVerticalBasicScaleUnit(0);
    }

    public int getVerticalBasicScaleUnit(int n) {
        return this.getVerticalBasicScaleUnit(n, 0);
    }

    public int getVerticalBasicScaleUnit(int n, int n2) {
        VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2);
        if (verticalNumberAxis != null) {
            return verticalNumberAxis.getBasicScaleUnit();
        }
        return 0;
    }

    @Override
    public void numTaskInfoChanged(NumTaskInfoChangedEvent numTaskInfoChangedEvent) {
        if (numTaskInfoChangedEvent == null) {
            return;
        }
        if (numTaskInfoChangedEvent.getEventType() == 1 && !numTaskInfoChangedEvent.getTaskInfo().isRemoved()) {
            if (dynTracer.isEnableDynDebug()) {
                dynTracer.trace("numTaskInfoChanged()", "Repaint. " + numTaskInfoChangedEvent.getTaskInfo().getTaskName());
            }
            this.updateChart();
        }
    }

    public Point2D getMoucePoint(MouseEvent mouseEvent) {
        return this.chartPanel.getMousePointValue(mouseEvent);
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setChartPanelBackground(Color color) {
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        if (xYPlot instanceof CombinedDomainXYPlot) {
            List list = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ((XYPlot)list.get(i)).setBackgroundPaint((Paint)color);
            }
        } else {
            xYPlot.setBackgroundPaint((Paint)color);
        }
    }

    public void setChartPanelBackground(int n, Color color) {
        XYPlot xYPlot = this.getPlot(n);
        if (xYPlot != null) {
            xYPlot.setBackgroundPaint((Paint)color);
        }
    }

    public void setSpaceVisible(boolean bl, boolean bl2) {
        this.setSpaceVisible(0, bl, bl2);
        this.setSpaceVisible(1, bl, bl2);
    }

    public void setSpaceVisible(int n, boolean bl, boolean bl2) {
        this.setSpaceVisible(n, 0, bl, bl2);
    }

    public void setSpaceVisible(int n, int n2, boolean bl, boolean bl2) {
        VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)this.getVerticalAxis(n, n2);
        if (verticalNumberAxis != null) {
            verticalNumberAxis.setSpaceVisible(bl, bl2);
        }
    }

    public void setHorizontalAxisVisible(boolean bl) {
        this.xAxis.setVisible(bl);
    }

    public void setBarWidth(double d) {
        if (d >= 1.0 || d <= 0.0) {
            throw new IllegalArgumentException(d + "doesn't  bettwen 0.0 and 1.0.");
        }
        this.barTaskBarWidth = d;
        if (this.singleTaskComparator != null) {
            this.resetSingleBarTaskPositionByName(d);
        } else {
            this.resetSingleBarTaskPositionByX(d);
        }
        this.updateChart();
    }

    public void setVerticalNumberFormat(NumberFormat numberFormat) {
        this.valueFormat = numberFormat;
        Enumeration enumeration = this.taskHashtable.elements();
        while (enumeration.hasMoreElements()) {
            AbstractNumTaskInfo abstractNumTaskInfo = (AbstractNumTaskInfo)enumeration.nextElement();
            if (!(abstractNumTaskInfo instanceof BarTaskInfo)) continue;
            BarTaskInfo barTaskInfo = (BarTaskInfo)abstractNumTaskInfo;
            ((NumXYBarRenderer)barTaskInfo.getRenderer()).setVerticalNumberFormat(numberFormat);
        }
        this.updateChart();
    }

    public void setTaskComparator(Comparator comparator) {
        this.singleTaskComparator = comparator;
    }

    public void setRefreshDate(boolean bl) {
        if (this.scrollBar == null) {
            throw new IllegalArgumentException("the scrollBar is null.");
        }
        this.scrollBar.setRefreshDate(bl);
    }

    public void setBeginTimeInfo(String string) {
        final StringBuffer stringBuffer = new StringBuffer(20);
        if (string != null && !"".equals(string)) {
            stringBuffer.append(string);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartGraphPanelEx.this.beginTime.setText(stringBuffer.toString());
            }
        });
    }

    public void setPointerVisible(boolean bl) {
        if (bl) {
            if (this.mouseHandler == null) {
                this.mouseHandler = new MouseHandler();
                this.chartPanel.addMouseListener(this.mouseHandler);
                this.chartPanel.addMouseMotionListener(this.mouseHandler);
            }
        } else {
            this.chartPanel.removeMouseListener(this.mouseHandler);
            this.chartPanel.removeMouseMotionListener(this.mouseHandler);
            this.mouseHandler = null;
        }
        this.xAxis.setPointerVisible(bl);
        this.updateChart();
    }

    public double getCurrentPointerValue() {
        return this.xAxis.getPointerPositionValue();
    }

    public void addPointerChangeListener(PointerChangeListener pointerChangeListener) {
        this.listenerList.add(PointerChangeListener.class, pointerChangeListener);
    }

    public void removePointerChangeListener(PointerChangeListener pointerChangeListener) {
        this.listenerList.remove(PointerChangeListener.class, pointerChangeListener);
    }

    private void firePointerChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PointerChangeListener.class) continue;
            ((PointerChangeListener)objectArray[i + 1]).positonChanged();
        }
    }

    public void setPointerPosition(double d) {
        if (!this.xAxis.isPointerVisible() || Double.isNaN(d)) {
            return;
        }
        JScrollBar jScrollBar = this.scrollBar.getScrollBar();
        if (!jScrollBar.isEnabled()) {
            Range range = this.xAxis.getRange();
            double d2 = (d - range.getLowerBound()) / range.getLength();
            this.xAxis.setPointerPercent(d2);
        } else {
            double d3 = this.scrollBar.getIncreaseValue();
            double d4 = this.xAxis.getPointerPositionValue();
            if (Double.isNaN(d4)) {
                return;
            }
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setGroupingUsed(false);
            String string = numberFormat.format(d - d4);
            double d5 = Double.parseDouble(string);
            int n = (int)(d5 / d3);
            int n2 = jScrollBar.getValue() + n;
            jScrollBar.setValue(n2);
            this.scrollBar.updateAxisRange();
            if (n2 != jScrollBar.getValue()) {
                Range range = this.xAxis.getRange();
                double d6 = (d - range.getLowerBound()) / range.getLength();
                this.xAxis.setPointerPercent(d6);
            }
        }
        this.updateChart();
    }

    public void setTooltipListener(TooltipListener tooltipListener) {
        this.chartPanel.setTooltipListener(tooltipListener);
    }

    public void resetChart() {
        this.close();
        if (this.daemonTask != null) {
            this.daemonTask.clear();
        }
        this.setBeginTimeInfo(null);
        this.xAxis.resetAxis();
        this.scrollBar.getScrollBar().setEnabled(false);
        this.updateChart();
    }

    private void updateChart() {
        this.chartPanel.setRefreshBuffer(true);
        this.chartPanel.repaint();
    }

    private Axis getVerticalAxis(int n, int n2) {
        XYPlot xYPlot = this.getPlot(n2);
        if (xYPlot != null) {
            return xYPlot.getRangeAxis(n);
        }
        return null;
    }

    public void addRangeAxis(int n) {
        this.addRangeAxis(n, 0);
    }

    public void addRangeAxis(int n, int n2) {
        XYPlot xYPlot = this.getPlot(n2);
        if (xYPlot != null) {
            xYPlot.setRangeAxis(n, (ValueAxis)new VerticalNumberAxis());
        }
    }

    private XYPlot getPlot(int n) {
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        if (xYPlot instanceof CombinedDomainXYPlot) {
            List list = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            if (n >= 0 && n < list.size()) {
                xYPlot = (XYPlot)list.get(n);
            }
        }
        return xYPlot;
    }

    private XYPlot getPlotForTaskInfo(AbstractNumTaskInfo abstractNumTaskInfo) {
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        if (xYPlot instanceof CombinedDomainXYPlot) {
            List list = ((CombinedDomainXYPlot)xYPlot).getSubplots();
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                if (abstractNumTaskInfo instanceof SeriesTaskInfo) {
                    n = ((XYPlot)list.get(i)).indexOf((XYDataset)((SeriesTaskInfo)abstractNumTaskInfo).getDataset());
                } else if (abstractNumTaskInfo instanceof BarTaskInfo) {
                    n = ((XYPlot)list.get(i)).indexOf((XYDataset)((BarTaskInfo)abstractNumTaskInfo).getDataset());
                }
                if (n == -1) continue;
                xYPlot = (XYPlot)list.get(i);
                break;
            }
        }
        return xYPlot;
    }

    public int getChartIndexForMouseRightClick() {
        return this.chartPanel.getChartIndexForMouseRightClick();
    }

    private class ScrollBarHandler
    extends MouseAdapter {
        private ScrollBarHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ChartGraphPanelEx.this.xAxis.isPointerVisible() && ChartGraphPanelEx.this.scrollBar.getScrollBar().isEnabled()) {
                ChartGraphPanelEx.this.firePointerChanged();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean inPointerScope = false;
        private int originateX = 0;
        private int currentX = 0;
        private int startPosition = 0;
        private int endPosition = 0;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Point2D point2D = ChartGraphPanelEx.this.chartPanel.translateScreenToJava2D(point);
                this.inPointerScope = ChartGraphPanelEx.this.xAxis.isInPointerScope((int)point2D.getX(), (int)point2D.getY());
                if (this.inPointerScope) {
                    this.originateX = (int)point2D.getX();
                    this.startPosition = (int)ChartGraphPanelEx.this.xAxis.getPointerPosition();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.inPointerScope) {
                this.endPosition = (int)ChartGraphPanelEx.this.xAxis.getPointerPosition();
                if (this.startPosition != this.endPosition) {
                    ChartGraphPanelEx.this.firePointerChanged();
                }
                this.inPointerScope = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.inPointerScope) {
                this.inPointerScope = false;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Point2D point2D = ChartGraphPanelEx.this.chartPanel.translateScreenToJava2D(point);
                this.currentX = (int)point2D.getX();
                if ((double)Math.abs(this.currentX - this.originateX) >= ChartGraphPanelEx.this.xAxis.getGap() / 2.0) {
                    this.originateX -= this.currentX;
                    ChartGraphPanelEx.this.xAxis.setPointPostion((int)ChartGraphPanelEx.this.xAxis.getPointerPosition() - this.originateX);
                    ChartGraphPanelEx.this.updateChart();
                    this.originateX = (int)ChartGraphPanelEx.this.xAxis.getPointerPosition();
                }
                this.inPointerScope = true;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

