/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.AbstractNumTaskInfo;
import com.swimap.iview.templates.charts.curve.expand.NumXYBarRenderer;
import com.swimap.iview.templates.charts.curve.expand.dyntrace.DynDebugTracer;
import java.awt.Color;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class BarTaskInfo
extends AbstractNumTaskInfo {
    private static final double DEFAULT_BAR_WIDTH = 0.2;
    protected double barWidth = 0.2;
    protected XYSeriesCollection basicDataset = null;
    protected XYBarDataset dataset = null;
    protected NumXYBarRenderer renderer = null;
    private static final DynDebugTracer dynTracer = DynDebugTracer.getInstance(BarTaskInfo.class);

    public BarTaskInfo(String string, String string2, String string3, Color color, double d) {
        super(string, string2, string3, color);
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("BarTaskInfo()", "Building... barWidth=" + d);
        }
        this.barWidth = d;
        this.init();
        this.renderer.setPaint(color);
    }

    public BarTaskInfo(String string, String string2, double d) {
        this(string, string2, null, null, d);
    }

    public BarTaskInfo(String string, String string2) {
        this(string, string2, null, null, 0.2);
    }

    protected void init() {
        XYSeries xYSeries = super.getSeries();
        this.basicDataset = new XYSeriesCollection(xYSeries);
        this.dataset = new XYBarDataset((XYDataset)this.basicDataset, this.barWidth);
        this.renderer = new NumXYBarRenderer();
    }

    @Override
    public void modifyColor(Color color) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("modifyColor()", "color=" + color);
        }
        if (color != null && !color.equals(this.getColor())) {
            if (dynTracer.isEnableDynDebug()) {
                dynTracer.trace("modifyColor()", "valid.");
            }
            super.modifyColor(color);
            this.renderer.setPaint(color);
            this.fireTaskInfoChange(this.getGeneralEvent());
        }
    }

    public XYBarDataset getDataset() {
        return this.dataset;
    }

    public XYBarRenderer getRenderer() {
        return this.renderer;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    @Override
    public boolean hasLine() {
        return false;
    }

    @Override
    void customXYPlot(XYPlot xYPlot) {
        int n = xYPlot.getDatasetCount();
        xYPlot.setDataset(n, (XYDataset)this.dataset);
        xYPlot.setRenderer(n, (XYItemRenderer)this.renderer);
        xYPlot.mapDatasetToRangeAxis(n, this.bindAxis);
    }

    @Override
    void removeSelf(XYPlot xYPlot) {
        int n = xYPlot.indexOf((XYDataset)this.dataset);
        xYPlot.setDataset(n, null);
        xYPlot.setRenderer(n, null);
        this.basicDataset.removeSeries(this.getSeries());
        this.clear();
        this.setRemoved(true);
    }

    @Override
    void setTooltipFormat(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator(string, numberFormat, numberFormat2));
    }

    @Override
    public void setVisible(boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("setVisible()", "visible=" + bl);
        }
        if (this.isVisible() != bl) {
            if (dynTracer.isEnableDynDebug()) {
                dynTracer.trace("setVisible()", "valid.");
            }
            this.renderer.setVisible(bl);
            this.fireTaskInfoChange(this.getGeneralEvent());
        }
    }

    @Override
    public boolean isVisible() {
        return this.renderer.isVisible();
    }
}

