/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve.expand;

import com.swimap.iview.templates.charts.curve.expand.InitialFaultException;
import com.swimap.iview.templates.charts.curve.expand.MarkItem;
import com.swimap.iview.templates.charts.curve.expand.NumTaskInfoChangedEvent;
import com.swimap.iview.templates.charts.curve.expand.NumTaskInfoChangedListener;
import com.swimap.iview.templates.charts.curve.expand.dyntrace.DynDebugTracer;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;

public abstract class AbstractNumTaskInfo {
    private String taskName = null;
    private String taskLabel = null;
    private String toolTip = null;
    private Color color = null;
    private boolean addedToGraph = false;
    private boolean removed = false;
    private EventListenerList listenerList = null;
    private NumTaskInfoChangedEvent eventNewDate = new NumTaskInfoChangedEvent(this, this, 2);
    private NumTaskInfoChangedEvent eventGeneral = new NumTaskInfoChangedEvent(this, this, 1);
    private XYSeries series = null;
    private double lastHorizontalValue = 0.0;
    private double lastVerticalValue = 0.0;
    private String lastHorizontalLabel = null;
    private static Vector tempHorizontalLabel = new Vector(10, 5);
    private boolean executeOne = true;
    private static final DynDebugTracer dynTracer = DynDebugTracer.getInstance(AbstractNumTaskInfo.class);
    public static final int BIND_TO_LEFT_AXIS = 0;
    public static final int BIND_TO_RIGHT_AXIS = 1;
    protected int bindAxis = 0;

    public AbstractNumTaskInfo(String string, String string2, String string3, Color color) {
        if (dynTracer.isEnableDynDebug()) {
            String string4 = new StringBuffer("Start building AbstractNumTaskInfo, taskName = ").append(string).append(", taskLabel=").append(string2).append(", tooltip=").append(string3).append(", color=").append(color).toString();
            dynTracer.trace("AbstractNumTaskInfo()", string4);
        }
        if (string == null) {
            throw new IllegalArgumentException("TaskName can't be null");
        }
        this.taskName = string;
        this.taskLabel = string2;
        this.toolTip = string3;
        this.color = color;
        this.series = this.toolTip != null ? new XYSeries((Comparable)((Object)this.toolTip)) : (this.taskLabel != null ? new XYSeries((Comparable)((Object)this.taskLabel)) : new XYSeries((Comparable)((Object)this.taskName)));
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("AbstractNumTaskInfo()", "End constructor, " + string);
        }
    }

    public AbstractNumTaskInfo(String string, String string2) {
        this(string, string2, null, null);
    }

    protected XYSeries getSeries() {
        return this.series;
    }

    protected void fireTaskInfoChange(NumTaskInfoChangedEvent numTaskInfoChangedEvent) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("fireTaskInfoChange()", "event=" + numTaskInfoChangedEvent);
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NumTaskInfoChangedListener.class) continue;
            ((NumTaskInfoChangedListener)objectArray[i + 1]).numTaskInfoChanged(numTaskInfoChangedEvent);
        }
    }

    final void setAddedToGraph(boolean bl) {
        this.addedToGraph = bl;
    }

    private final boolean isAddedToGraph() {
        return this.addedToGraph;
    }

    final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    private final NumTaskInfoChangedEvent getNewDateEvent() {
        return this.eventNewDate;
    }

    final NumTaskInfoChangedEvent getGeneralEvent() {
        return this.eventGeneral;
    }

    final void setMaximumItemCount(int n) {
        if (n < 0) {
            return;
        }
        this.series.setMaximumItemCount(n);
    }

    final int getMaximumItemCount() {
        return this.series.getMaximumItemCount();
    }

    final void clear() {
        this.series.clear();
        tempHorizontalLabel.clear();
    }

    public final Color getColor() {
        return this.color;
    }

    public final String getTaskLabel() {
        return this.taskLabel;
    }

    public final String getToolTip() {
        return this.toolTip;
    }

    public final String getTaskName() {
        return this.taskName;
    }

    public final double getLastHorizontalValue() {
        return this.lastHorizontalValue;
    }

    public final String getLastHorizontalLabel() {
        return this.lastHorizontalLabel;
    }

    public final Vector getTempHorizontalLabel() {
        return tempHorizontalLabel;
    }

    public final double getLastVerticalValue() {
        return this.lastVerticalValue;
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public void fireTaskDataChange() {
        this.fireTaskInfoChange(this.getNewDateEvent());
    }

    public void modifyColor(Color color) {
        this.color = color;
    }

    private void setLastVerticalValue(double d) {
        this.lastVerticalValue = d;
    }

    private void setLastHorizontalValue(double d) {
        this.lastHorizontalValue = d;
    }

    private void setLastHorizontalLabel(String string) {
        this.lastHorizontalLabel = string;
    }

    private void addTempHorizontalLabel(double d, String string) {
        MarkItem markItem = new MarkItem(new Double(d), string);
        tempHorizontalLabel.add(markItem);
    }

    public synchronized void addChangedListener(NumTaskInfoChangedListener numTaskInfoChangedListener) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("addChangedListener()", "listener=" + numTaskInfoChangedListener);
        }
        if (numTaskInfoChangedListener == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(NumTaskInfoChangedListener.class, numTaskInfoChangedListener);
    }

    public synchronized void removeChangedListener(NumTaskInfoChangedListener numTaskInfoChangedListener) {
        if (dynTracer.isEnableDynDebug()) {
            dynTracer.trace("removeChangedListener()", "listener=" + numTaskInfoChangedListener);
        }
        if (numTaskInfoChangedListener == null) {
            return;
        }
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(NumTaskInfoChangedListener.class, numTaskInfoChangedListener);
    }

    public void addData(double d, double d2) {
        this.addData(d, null, d2, true);
    }

    public void addData(double d, String string, double d2) {
        this.addData(d, string, d2, true);
    }

    public void addData(double d, double d2, boolean bl) {
        this.addData(d, null, d2, bl);
    }

    public void addData(double d, String string, double d2, boolean bl) {
        if (dynTracer.isEnableDynDebug()) {
            String string2 = new StringBuffer("Task: ").append(this.getTaskName()).append(", Data is [x=").append(d).append(", xLabel=").append(string).append(", y=").append(d2).append(", notify=").append(bl).append(']').toString();
            dynTracer.trace("addData()", string2);
        }
        if (!this.isAddedToGraph()) {
            throw new InitialFaultException("Must use ChartGraphPanelEx.addTask() method to add AbstractNumTaskInfo to graph before invoking addData() method");
        }
        if (this.isRemoved()) {
            throw new InitialFaultException("The Task named '" + this.getTaskName() + "' has been removed from chart.");
        }
        this.series.add(d, d2, bl);
        this.setLastHorizontalValue(d);
        this.setLastVerticalValue(d2);
        if (string == null) {
            string = String.valueOf(d);
        }
        this.setLastHorizontalLabel(string);
        if (!bl) {
            this.addTempHorizontalLabel(d, string);
        }
        if (bl || this.executeOne) {
            this.fireTaskInfoChange(this.getNewDateEvent());
            this.executeOne = false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[taskName=");
        stringBuffer.append(this.taskName);
        stringBuffer.append(", label=").append(this.taskLabel);
        stringBuffer.append(", tooltip=").append(this.toolTip);
        stringBuffer.append(", Color=").append(this.color);
        stringBuffer.append(", addedToGraph=").append(this.addedToGraph);
        stringBuffer.append(", removed=").append(this.removed);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void bindToAxis(int n) {
        this.bindAxis = n;
    }

    public abstract boolean hasLine();

    public abstract void setVisible(boolean var1);

    public abstract boolean isVisible();

    abstract void customXYPlot(XYPlot var1);

    abstract void removeSelf(XYPlot var1);

    abstract void setTooltipFormat(String var1, NumberFormat var2, NumberFormat var3);
}

