/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.ChartGraphPanel;
import com.swimap.iview.templates.charts.curve.ExtendDateAxis;
import com.swimap.iview.templates.charts.curve.TaskInfoChangeEvent;
import com.swimap.iview.templates.charts.curve.TaskInfoChangeListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TaskInfo {
    private static IviewLogger logger = IviewLogger.getLogger(TaskInfo.class, "IVIEW");
    private Color lineColor = null;
    private int lineType = 0;
    private int lineWidth = 0;
    private String toolTipName = null;
    private String taskLabel = null;
    private String taskName = null;
    private TimeSeries timeseries = null;
    private boolean isShow = true;
    public static final int LINEWIDTH_NARROW = 1;
    public static final int LINEWIDTH_BROAD = 2;
    public static final int LINETYPE_GENERAL = 1;
    public static final int LINETYPE_SECOND = 2;
    public static final int LINETYPE_THIRD = 3;
    public static final int LINETYPE_FOUTH = 4;
    public static final int LINETYPE_FIFTH = 5;
    public static final int LINTTYPE_SIXTH = 6;
    public static final int LINTTYPE_SEVENTH = 7;
    public static final int LINTTYPE_EIGHTH = 8;
    private EventListenerList listenerList = new EventListenerList();
    private TimeSeriesCollection dataset = null;
    private LinkedList taskDataList = new LinkedList();
    private static final int MAX_DADA_NUMBER = 720;
    private TaskInfoChangeListener chartGraphPanel = null;
    private static int maxDataNumber = 720;
    private TaskInfoChangeEvent event = new TaskInfoChangeEvent(this, this, 2);

    public TaskInfo(String string, String string2, Color color, int n, int n2, String string3) {
        this.taskName = string;
        this.taskLabel = string2;
        this.lineColor = color;
        this.lineType = n;
        this.lineWidth = n2;
        this.toolTipName = string3;
    }

    public void modifyLineType(int n) {
        if (n < 1 || n > 8) {
            this.lineType = 1;
            throw new IllegalArgumentException("The lineType is not correct.");
        }
        if (this.lineType == n) {
            return;
        }
        this.lineType = n;
        this.fireTaskInfoChanged(1);
    }

    public void modifyLineWidth(int n) {
        if (n != 1 && n != 2) {
            this.lineWidth = 1;
            throw new IllegalArgumentException("The lineWidth is not correct.");
        }
        if (this.lineWidth == n) {
            return;
        }
        this.lineWidth = n;
        this.fireTaskInfoChanged(1);
    }

    public void modifyLineColor(Color color) {
        if (this.lineColor == null) {
            this.lineColor = color;
            return;
        }
        if (this.lineColor.equals(color)) {
            return;
        }
        this.lineColor = color;
        this.fireTaskInfoChanged(1);
    }

    public void setTaskLineIsShow(boolean bl) {
        if (this.isShow != bl) {
            this.isShow = bl;
            this.fireTaskInfoChanged(1);
        }
    }

    public boolean getTaskLineIsShow() {
        return this.isShow;
    }

    public void addData(double d, Date date) {
        this.addData(new Double(d), date);
    }

    public void addData(int n, Date date) {
        this.addData((Number)n, date);
    }

    public void addData(Number number, Date date) {
        if (this.getTimeSeries() == null) {
            return;
        }
        if (date != null) {
            final ChartGraphPanel chartGraphPanel = (ChartGraphPanel)this.chartGraphPanel;
            if (!chartGraphPanel.isChartDataAdded()) {
                TaskDataCoordinate taskDataCoordinate = null;
                taskDataCoordinate = number == null ? new TaskDataCoordinate(0.0, date) : new TaskDataCoordinate(number.doubleValue(), date);
                chartGraphPanel.getScrollBarProcess().setBeginTime(date.getTime());
                long l = 0L;
                Date date2 = new Date(date.getTime());
                date2.setHours(0);
                date2.setMinutes(0);
                date2.setSeconds(0);
                l = date2.getTime();
                l /= 1000L;
                Date date3 = new Date(l *= 1000L);
                chartGraphPanel.setFirstTimeStarted(l);
                Millisecond millisecond = new Millisecond(date3);
                this.getTimeSeries().add((RegularTimePeriod)millisecond, number);
                chartGraphPanel.getDaemonTask().addDaemonData((RegularTimePeriod)millisecond);
                chartGraphPanel.setFirstCoordinate(taskDataCoordinate);
                ExtendDateAxis extendDateAxis = (ExtendDateAxis)chartGraphPanel.getChartPanel().getChart().getXYPlot().getDomainAxis();
                extendDateAxis.setBasalDate(date3);
                extendDateAxis.setBeginDate(date3);
            } else {
                long l = date.getTime();
                Date date4 = chartGraphPanel.getFirstCoordinate().getTaskTime();
                long l2 = date4.getTime();
                long l3 = Math.abs(l - l2) + chartGraphPanel.getFirstTimeStarted();
                Date date5 = new Date(l3);
                Millisecond millisecond = new Millisecond(date5);
                this.getTimeSeries().addOrUpdate((RegularTimePeriod)millisecond, number);
                chartGraphPanel.getDaemonTask().addDaemonData((RegularTimePeriod)millisecond);
                final Date date6 = date5;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        chartGraphPanel.getScrollBarProcess().adjustTime(date6);
                    }
                });
                ExtendDateAxis extendDateAxis = (ExtendDateAxis)chartGraphPanel.getChartPanel().getChart().getXYPlot().getDomainAxis();
                extendDateAxis.setCurrentDate(date6);
            }
            if (chartGraphPanel.isAutoScroll()) {
                chartGraphPanel.scrollToRight();
            }
        } else {
            logger.error("The parament of taskTime is null.");
        }
    }

    public LinkedList getTaskDateList() {
        return this.taskDataList;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskLabel() {
        return this.taskLabel;
    }

    public String getToolTipName() {
        return this.toolTipName;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getLineType() {
        return this.lineType;
    }

    public TimeSeries getTimeSeries() {
        return this.timeseries;
    }

    public void setTimeSeries(TimeSeries timeSeries) {
        this.timeseries = timeSeries;
    }

    public TimeSeriesCollection getDataset() {
        return this.dataset;
    }

    public void setDataset(TimeSeriesCollection timeSeriesCollection) {
        this.dataset = timeSeriesCollection;
    }

    public void addChangeListener(TaskInfoChangeListener taskInfoChangeListener) {
        this.listenerList.add(TaskInfoChangeListener.class, taskInfoChangeListener);
        if (this.chartGraphPanel == null) {
            this.chartGraphPanel = taskInfoChangeListener;
        }
    }

    public void removeChangeListener(TaskInfoChangeListener taskInfoChangeListener) {
        this.listenerList.remove(TaskInfoChangeListener.class, taskInfoChangeListener);
    }

    public static final int getMaxDataCount() {
        return maxDataNumber;
    }

    public static final void setMaxDataCount(int n) {
        if (n > 0) {
            maxDataNumber = n;
        }
    }

    public void fireTaskInfoChanged(int n) {
        this.event.setTaskInfo(this);
        this.event.setEventType(n);
        this.notifyListeners(this.event);
    }

    private void notifyListeners(TaskInfoChangeEvent taskInfoChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TaskInfoChangeListener.class) continue;
            ((TaskInfoChangeListener)objectArray[i + 1]).taskInfoChanged(taskInfoChangeEvent);
        }
    }

    public String toString() {
        return "Task Name: " + this.taskName + "\nTask Label: " + this.taskLabel + "\nTool Tip: " + this.toolTipName + "\nis Show: " + this.isShow + "\nLine Type: " + this.lineType + "\nLine Width: " + this.lineWidth + "\nLine Color" + this.lineColor + "\nMax Data Number" + maxDataNumber;
    }

    class TaskDataCoordinate {
        private double taskData = 0.0;
        private Date taskTime = null;

        public TaskDataCoordinate(double d, Date date) {
            this.taskData = d;
            this.taskTime = date;
        }

        public double getTaskData() {
            return this.taskData;
        }

        public Date getTaskTime() {
            return this.taskTime;
        }
    }
}

