/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.AxisInfo;
import com.swimap.iview.templates.charts.curve.ChartGraphPanel;
import com.swimap.iview.templates.charts.curve.DateAxisPaintListener;
import com.swimap.iview.templates.charts.curve.ExtendDateAxis;
import com.swimap.iview.templates.charts.curve.TaskInfo;
import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;

public class ScrollBarProcess
implements DateAxisPaintListener {
    private ChartGraphPanel chartGraphPanel = null;
    private JPanel scrollBarPanel = new JPanel(new BorderLayout());
    private JScrollBar scrollBar = new JScrollBar(0);
    private ImpAdjustmentListener listener = new ImpAdjustmentListener();
    private JLabel totalTimeLabel = new JLabel(AxisInfo.res.getString("Totol_time") + "(00:00:00)");
    private LabelTimer labelTimer = null;
    private static final int DEFAULT_MIN_VISIBLE = 20;
    private int minVisibleAmount = 20;
    private List rollBackTimeInfolist = null;
    private int rollbackCount = 0;
    private int hourOffset = 0;
    private Number firstX = null;
    private boolean isRollBackRecover = false;
    private boolean isRollBackNeed = false;
    private boolean isLabelVisible = true;
    private ExtendDateAxis dateAxis = null;
    private int currentHour = 0;
    private int currentMinute = 0;
    private int currentSecond = 0;
    private Calendar calendar = Calendar.getInstance();
    private boolean synchronizeLabelTime = true;
    private boolean isPause = false;
    private long beginTime = 0L;
    private boolean isSetBeginTime = false;
    private DateFormat beginTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private JLabel startTimeLabel = new JLabel();
    private JPopupMenu popup = null;
    private boolean scrollMove = true;

    public ScrollBarProcess(ChartGraphPanel chartGraphPanel) {
        this.chartGraphPanel = chartGraphPanel;
        this.scrollBar.setEnabled(false);
        this.scrollBar.setModel(new DefaultBoundedRangeModel());
        this.scrollBar.addAdjustmentListener(this.listener);
        Dimension dimension = new Dimension(120, 21);
        this.totalTimeLabel.setPreferredSize(dimension);
        this.totalTimeLabel.setHorizontalAlignment(4);
        this.totalTimeLabel.setHorizontalTextPosition(4);
        this.totalTimeLabel.setName("ScrollBarProcess_totalTimeLabel");
        this.startTimeLabel.setHorizontalAlignment(0);
        this.startTimeLabel.setVisible(false);
        this.startTimeLabel.setName("ScrollBarProcess_startTimeLabel");
        this.scrollBarPanel.add((Component)this.totalTimeLabel, "East");
        this.scrollBarPanel.add(Box.createRigidArea(dimension), "West");
        this.scrollBarPanel.add((Component)this.startTimeLabel, "Center");
        this.scrollBarPanel.add((Component)this.scrollBar, "South");
        this.dateAxis = (ExtendDateAxis)this.chartGraphPanel.getChartPanel().getChart().getXYPlot().getDomainAxis();
        this.dateAxis.setPaintListener(this);
        this.rollBackTimeInfolist = new ArrayList(12);
        MouseHandler mouseHandler = new MouseHandler();
        Component[] componentArray = this.scrollBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(mouseHandler);
        }
        this.scrollBar.addMouseListener(mouseHandler);
        this.scrollBar.setName("ScrollBarProcess_scrollBar");
        PopupMouseHandler popupMouseHandler = new PopupMouseHandler();
        this.scrollBarPanel.addMouseListener(popupMouseHandler);
        this.totalTimeLabel.addMouseListener(popupMouseHandler);
    }

    private void addRollBackDate(Date date) {
        int n = this.rollBackTimeInfolist.size();
        this.rollBackTimeInfolist.add(n, date);
        if (n > TaskInfo.getMaxDataCount()) {
            this.rollBackTimeInfolist.remove(0);
        }
    }

    void resetScrollBarProcess() {
        this.scrollBar.setEnabled(false);
        this.rollBackTimeInfolist.clear();
        this.clearLabelTimer();
        if (this.isLabelVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScrollBarProcess.this.totalTimeLabel.setText(AxisInfo.res.getString("Totol_time") + "(00:00:00)");
                }
            });
        }
        if (this.startTimeLabel.isVisible()) {
            this.clearBeginTime();
        }
    }

    void setLabelVisible(boolean bl) {
        this.isLabelVisible = bl;
        if (!bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScrollBarProcess.this.totalTimeLabel.setText("  ");
                }
            });
        }
    }

    void adjustTime(Date date) {
        if (!this.synchronizeLabelTime) {
            return;
        }
        if (date == null) {
            return;
        }
        if (this.isPause) {
            return;
        }
        this.calendar.setTime(date);
        int n = this.calendar.get(11);
        int n2 = this.calendar.get(12);
        int n3 = this.calendar.get(13);
        if (n == 0) {
            this.hourOffset = ((ExtendDateAxis)this.chartGraphPanel.getChartPanel().getChart().getXYPlot().getDomainAxis()).getHourOffset();
        }
        if (this.currentHour != (n += this.hourOffset)) {
            this.currentHour = n;
            this.currentMinute = n2;
            this.currentSecond = n3;
        } else if (this.currentMinute != n2) {
            this.currentMinute = n2;
            this.currentSecond = n3;
        } else if (this.currentSecond != n3 && this.currentSecond != n3 + 1 && this.currentSecond != n3 - 1) {
            this.currentSecond = n3;
        }
    }

    void setSynchronizeLabelTime(boolean bl) {
        this.synchronizeLabelTime = bl;
    }

    boolean isSynchronizeLabelTime() {
        return this.synchronizeLabelTime;
    }

    void setPause() {
        this.isPause = true;
    }

    void setResume() {
        this.isPause = false;
    }

    void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public JPanel getScrollBarPanel() {
        return this.scrollBarPanel;
    }

    @Override
    public void paint() {
        this.doRollBackSet();
    }

    private void setValueAndVisibleAmount() {
        if (this.scrollBar.isEnabled()) {
            if (this.scrollBar.getVisibleAmount() == this.minVisibleAmount) {
                int n = 0;
                if (!this.scrollMove) {
                    n = this.scrollBar.getValue() - 1;
                    n = Math.max(n, this.scrollBar.getMinimum());
                    this.scrollBar.setValues(n, this.scrollBar.getVisibleAmount(), this.scrollBar.getMinimum(), this.scrollBar.getMaximum());
                }
            } else {
                int n = this.scrollBar.getVisibleAmount() - 1;
                int n2 = 0;
                n2 = this.scrollMove ? this.scrollBar.getValue() + 1 : this.scrollBar.getValue();
                if (n > 0 && n2 <= this.scrollBar.getMaximum() - this.minVisibleAmount) {
                    this.scrollBar.setValues(n2, n, this.scrollBar.getMinimum(), this.scrollBar.getMaximum());
                }
            }
        }
    }

    void scrollmove(boolean bl) {
        if (this.scrollMove == bl) {
            return;
        }
        this.scrollMove = bl;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    private void doRollBackSet() {
        if (this.scrollBar.isEnabled()) {
            DateAxis dateAxis = (DateAxis)this.chartGraphPanel.getChartPanel().getChart().getXYPlot().getDomainAxis();
            int n = this.rollBackTimeInfolist.size();
            if (this.isRollBackNeed) {
                int n2 = this.scrollBar.getVisibleAmount();
                int n3 = this.scrollBar.getValue();
                this.rollbackCount = this.scrollBar.getMaximum() - (n2 + n3);
                if (this.rollbackCount >= 0 && this.rollbackCount <= n - 1) {
                    Date date = (Date)this.rollBackTimeInfolist.get(n - this.rollbackCount - 1);
                    long l = (long)dateAxis.getFixedAutoRange();
                    Date date2 = new Date(date.getTime() - l);
                    DateRange dateRange = new DateRange(date2, date);
                    dateAxis.setRange((Range)dateRange, false, false);
                }
            } else if (!this.isRollBackNeed && this.isRollBackRecover && n > 0) {
                Date date = (Date)this.rollBackTimeInfolist.get(n - 1);
                long l = (long)dateAxis.getFixedAutoRange();
                Date date3 = new Date(date.getTime() - l);
                DateRange dateRange = new DateRange(date3, date);
                dateAxis.setRange((Range)dateRange, false, false);
                this.rollbackCount = 0;
            }
        }
    }

    private void setScrollBarInfo() {
        DateAxis dateAxis = (DateAxis)this.chartGraphPanel.getChartPanel().getChart().getXYPlot().getDomainAxis();
        DateRange dateRange = (DateRange)dateAxis.getRange();
        Date date = dateRange.getUpperDate();
        if (this.rollBackTimeInfolist.isEmpty()) {
            this.addRollBackDate(date);
        } else {
            int n = this.rollBackTimeInfolist.size();
            Date date2 = (Date)this.rollBackTimeInfolist.get(n - 1);
            if (date.getTime() > date2.getTime()) {
                this.addRollBackDate(date);
                this.setValueAndVisibleAmount();
            }
        }
    }

    void setScrollBarEnable(TaskInfo taskInfo) {
        if (this.scrollBar.isEnabled()) {
            this.setScrollBarInfo();
            return;
        }
        int n = taskInfo.getDataset().getItemCount(0);
        if (n >= 1) {
            Number number = taskInfo.getDataset().getX(0, 0);
            if (number == null) {
                this.scrollBar.setEnabled(false);
                return;
            }
            if (this.firstX == null) {
                this.firstX = number;
            }
            long l = this.firstX.longValue();
            Number number2 = taskInfo.getDataset().getX(0, n - 1);
            if (number2 == null) {
                this.scrollBar.setEnabled(false);
                return;
            }
            long l2 = number2.longValue();
            if (l2 > l && (double)(l2 - l) >= this.chartGraphPanel.getAxisInfo().getXAxisScope()) {
                this.scrollBar.setEnabled(true);
                this.scrollBar.setValues(0, TaskInfo.getMaxDataCount() + this.minVisibleAmount, 0, TaskInfo.getMaxDataCount() + this.minVisibleAmount);
                this.setScrollBarInfo();
            }
        } else {
            this.scrollBar.setEnabled(false);
        }
    }

    void startLabelTimer() {
        if (this.labelTimer == null) {
            this.labelTimer = new LabelTimer();
            this.labelTimer.start();
        }
    }

    void clearLabelTimer() {
        if (this.labelTimer != null) {
            this.labelTimer.stop();
            this.labelTimer = null;
        }
    }

    void setBeginTime(final long l) {
        if (!this.isSetBeginTime) {
            if (l < 0L) {
                return;
            }
            this.beginTime = l;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = ScrollBarProcess.this.beginTimeFormat.format(new Date(l));
                    ScrollBarProcess.this.startTimeLabel.setText(AxisInfo.res.getString("Begin_Time") + string);
                }
            });
            this.isSetBeginTime = true;
        }
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    void setBeginTimeEnable(boolean bl) {
        this.isSetBeginTime = !bl;
    }

    private void clearBeginTime() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollBarProcess.this.startTimeLabel.setText("  ");
                ScrollBarProcess.this.isSetBeginTime = false;
            }
        });
    }

    void setBegintimeVisible(boolean bl) {
        this.startTimeLabel.setVisible(bl);
    }

    public int getRollbackCount() {
        return this.rollbackCount;
    }

    public boolean isNeedRollBack() {
        return this.isRollBackNeed;
    }

    void scrollToRight() {
        if (this.scrollBar.getValue() == this.scrollBar.getMaximum()) {
            return;
        }
        this.scrollBar.setValue(this.scrollBar.getMaximum());
    }

    public void setOffset(int n) {
        throw new UnsupportedOperationException("Method setOffset() not yet implemented.");
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ScrollBarProcess.this.chartGraphPanel.isPointerNeedVisible() && ScrollBarProcess.this.scrollBar.isEnabled()) {
                ScrollBarProcess.this.paint();
                ScrollBarProcess.this.chartGraphPanel.firePointerChanged();
            }
        }
    }

    private class PopupMouseHandler
    extends MouseAdapter {
        private PopupMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (ScrollBarProcess.this.popup != null && mouseEvent.isPopupTrigger()) {
                ScrollBarProcess.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class LabelTimer {
        private IviewUtilTimer time = null;
        private IviewTimerTask task = null;
        ImpRunnable impThead = new ImpRunnable();

        private LabelTimer() {
        }

        public void start() {
            ScrollBarProcess.this.currentHour = 0;
            ScrollBarProcess.this.currentMinute = 0;
            ScrollBarProcess.this.currentSecond = 0;
            this.time = new IviewUtilTimer();
            this.task = new IviewTimerTask(){

                @Override
                public void run() {
                    if (!ScrollBarProcess.this.isLabelVisible) {
                        return;
                    }
                    SwingUtilities.invokeLater(LabelTimer.this.impThead);
                }
            };
            this.time.schedule(this.task, 0L, 1000L);
        }

        public void stop() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            if (this.time != null) {
                this.time.cancel();
                this.time = null;
            }
        }

        private String toTimeString() {
            StringBuffer stringBuffer = new StringBuffer(8);
            if (!ScrollBarProcess.this.isPause) {
                ScrollBarProcess.this.currentSecond += 1;
            }
            if (ScrollBarProcess.this.currentSecond >= 60) {
                ScrollBarProcess.this.currentSecond -= 60;
                ScrollBarProcess.this.currentMinute += 1;
                if (ScrollBarProcess.this.currentMinute >= 60) {
                    ScrollBarProcess.this.currentMinute -= 60;
                    ScrollBarProcess.this.currentHour += 1;
                }
            }
            if (ScrollBarProcess.this.currentHour < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(ScrollBarProcess.this.currentHour);
            stringBuffer.append(":");
            if (ScrollBarProcess.this.currentMinute < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(ScrollBarProcess.this.currentMinute);
            stringBuffer.append(":");
            if (ScrollBarProcess.this.currentSecond < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(ScrollBarProcess.this.currentSecond);
            return stringBuffer.toString();
        }

        private class ImpRunnable
        implements Runnable {
            private ImpRunnable() {
            }

            @Override
            public void run() {
                String string = LabelTimer.this.toTimeString();
                ScrollBarProcess.this.totalTimeLabel.setText(AxisInfo.res.getString("Totol_time") + '(' + string + ')');
            }
        }
    }

    private class ImpAdjustmentListener
    implements AdjustmentListener {
        private ImpAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n;
            if (ScrollBarProcess.this.scrollBar.getValueIsAdjusting()) {
                return;
            }
            int n2 = ScrollBarProcess.this.scrollBar.getValue();
            if (n2 + (n = ScrollBarProcess.this.scrollBar.getVisibleAmount()) == ScrollBarProcess.this.scrollBar.getMaximum()) {
                if (ScrollBarProcess.this.isRollBackNeed) {
                    ScrollBarProcess.this.isRollBackNeed = false;
                    ScrollBarProcess.this.isRollBackRecover = true;
                }
            } else {
                ScrollBarProcess.this.isRollBackNeed = true;
            }
            JFreeChart jFreeChart = ScrollBarProcess.this.chartGraphPanel.getChartPanel().getChart();
            jFreeChart.setTitle(jFreeChart.getTitle());
        }
    }
}

