/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.ChartGraphPanel;
import com.swimap.iview.templates.charts.curve.ExtendChartPanel;
import com.swimap.iview.templates.charts.curve.ExtendDateAxis;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;

public class ExtendXYPlot
extends XYPlot {
    private ChartGraphPanel chartGraphPanel = null;
    private static final int DEFAULT_SHOW_COUNT = 35;
    private int showCount = 35;

    public ExtendXYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer, ChartGraphPanel chartGraphPanel) {
        super(xYDataset, valueAxis, valueAxis2, xYItemRenderer);
        ((ExtendDateAxis)valueAxis).setBeginDate(((ExtendDateAxis)valueAxis).getMaximumDate());
        this.chartGraphPanel = chartGraphPanel;
        int n = (int)this.chartGraphPanel.getAxisInfo().getXAxisScope() / 1000;
        int n2 = this.chartGraphPanel.getAxisInfo().getYAxisShowScaleUnit();
        if (n2 != 0 && n / n2 > this.showCount) {
            this.showCount = n / n2;
        }
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        boolean bl = false;
        XYDataset xYDataset = this.getDataset(n);
        if (!DatasetUtilities.isEmptyOrNull((XYDataset)xYDataset)) {
            XYItemRenderer xYItemRenderer;
            bl = true;
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getDomainAxisForDataset(n);
            if (valueAxis2 != null) {
                valueAxis = valueAxis2;
            }
            ValueAxis valueAxis3 = this.getRangeAxis();
            ValueAxis valueAxis4 = this.getRangeAxisForDataset(n);
            if (valueAxis4 != null) {
                valueAxis3 = valueAxis4;
            }
            if ((xYItemRenderer = this.getRenderer(n)) == null) {
                xYItemRenderer = this.getRenderer();
            }
            XYItemRendererState xYItemRendererState = xYItemRenderer.initialise(graphics2D, rectangle2D, (XYPlot)this, xYDataset, plotRenderingInfo);
            ChartPanel chartPanel = this.chartGraphPanel.getChartPanel();
            int n2 = xYItemRenderer.getPassCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = xYDataset.getSeriesCount();
                for (int j = 0; j < n4; ++j) {
                    int n5;
                    n3 = xYDataset.getItemCount(j);
                    if (chartPanel instanceof ExtendChartPanel) {
                        ((ExtendChartPanel)chartPanel).setCurrentSeriesName(xYDataset.getSeriesKey(j).toString());
                    }
                    if (n3 <= this.showCount) {
                        for (n5 = 0; n5 < n3; ++n5) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, (XYPlot)this, valueAxis, valueAxis3, xYDataset, j, n5, crosshairState, i);
                        }
                        continue;
                    }
                    if (this.chartGraphPanel.getScrollBarProcess().isNeedRollBack()) {
                        int n6;
                        n5 = this.chartGraphPanel.getScrollBarProcess().getRollbackCount();
                        int n7 = n3 - this.showCount - n5;
                        if (n7 >= 0) {
                            for (n6 = n7; n6 < n3 - n5 && n6 >= 0; ++n6) {
                                xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, (XYPlot)this, valueAxis, valueAxis3, xYDataset, j, n6, crosshairState, i);
                            }
                            continue;
                        }
                        for (n6 = 0; n6 < this.showCount && n6 < n3; ++n6) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, (XYPlot)this, valueAxis, valueAxis3, xYDataset, j, n6, crosshairState, i);
                        }
                        continue;
                    }
                    for (n5 = n3 - this.showCount; n5 < n3; ++n5) {
                        xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, (XYPlot)this, valueAxis, valueAxis3, xYDataset, j, n5, crosshairState, i);
                    }
                }
            }
        }
        return bl;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        super.draw(graphics2D, rectangle2D, point2D, plotState, plotRenderingInfo);
        ExtendDateAxis extendDateAxis = (ExtendDateAxis)this.getDomainAxis();
        extendDateAxis.drowPointer(graphics2D);
    }
}

