/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.AxisInfo;
import com.swimap.iview.templates.charts.curve.ChartGraphPanel;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;

public class ExtendStandardXYItemRenderer
extends StandardXYItemRenderer {
    private ChartGraphPanel chartGraphPanel = null;

    public ExtendStandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator, AxisInfo axisInfo) {
        this(n, xYToolTipGenerator, xYURLGenerator);
    }

    public ExtendStandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Serializable serializable;
        Object object;
        Rectangle2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (null != plotRenderingInfo) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        if (null == number2 || null == number) {
            return;
        }
        double d = number2.doubleValue();
        double d2 = number.doubleValue();
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d3 = valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (this.getPlotLines() && n2 > 0) {
            object = xYDataset.getY(n, n2 - 1);
            serializable = xYDataset.getX(n, n2 - 1);
            if (object != null && serializable != null) {
                double d5 = ((Number)object).doubleValue();
                double d6 = ((Number)serializable).doubleValue();
                boolean bl = true;
                if (this.getPlotDiscontinuous()) {
                    int n4 = xYDataset.getItemCount(n);
                    double d7 = xYDataset.getXValue(n, 0);
                    double d8 = xYDataset.getXValue(n, n4 - 1);
                    boolean bl2 = bl = d2 - d6 <= (d8 - d7) / (double)n4 * this.getGapThreshold();
                }
                if (bl) {
                    double d9 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge2);
                    double d10 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge);
                    if (Double.isNaN(d9) || Double.isNaN(d10) || Double.isNaN(d4) || Double.isNaN(d3)) {
                        return;
                    }
                    if (PlotOrientation.HORIZONTAL == plotOrientation) {
                        xYItemRendererState.workingLine.setLine(d10, d9, d3, d4);
                    } else if (PlotOrientation.VERTICAL == plotOrientation) {
                        xYItemRendererState.workingLine.setLine(d9, d10, d4, d3);
                    }
                    if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
                        graphics2D.draw(xYItemRendererState.workingLine);
                    }
                }
            }
        }
        if (this.getBaseShapesVisible()) {
            object = this.getItemShape(n, n2);
            if (PlotOrientation.HORIZONTAL == plotOrientation) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, (double)d3, (double)d4);
            } else if (PlotOrientation.VERTICAL == plotOrientation) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, (double)d4, (double)d3);
            }
            if (object.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n, n2)) {
                    graphics2D.fill((Shape)object);
                } else {
                    graphics2D.draw((Shape)object);
                }
            }
        }
        if (this.getPlotImages() && null != (object = this.getImage((Plot)xYPlot, n, n2, d4, d3))) {
            serializable = this.getImageHotspot((Plot)xYPlot, n, n2, d4, d3, (Image)object);
            graphics2D.drawImage((Image)object, (int)(d4 - ((Point)serializable).getX()), (int)(d3 - ((Point)serializable).getY()), null);
            double_ = new Rectangle2D.Double(d4 - ((Point)serializable).getX(), d3 - ((Point)serializable).getY(), ((Image)object).getWidth(null), ((Image)object).getHeight(null));
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d4, d3, d < 0.0);
        }
        this.updateCrosshairValues(crosshairState, d2, d, d4, d3, plotOrientation);
        if (null != entityCollection) {
            if (null == double_) {
                double_ = new Rectangle2D.Double(d4 - 2.0, d3 - 2.0, 4.0, 4.0);
            }
            object = null;
            if (null != this.getURLGenerator()) {
                object = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            serializable = new XYItemEntity((Shape)double_, xYDataset, n, n2, "", (String)object);
            entityCollection.add((ChartEntity)serializable);
        }
    }

    public void setChartGraphPanel(ChartGraphPanel chartGraphPanel) {
        this.chartGraphPanel = chartGraphPanel;
    }
}

