/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.AxisInfo;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class ExtendNumberAxis
extends NumberAxis {
    private static AxisInfo axisInfo = new AxisInfo();
    private Rectangle2D chartArea = null;

    public ExtendNumberAxis(String string) {
        super(string);
    }

    public ExtendNumberAxis(AxisInfo axisInfo) {
        this(axisInfo == null ? ExtendNumberAxis.axisInfo.getXAxisLabel() : axisInfo.getXAxisLabel());
        if (axisInfo != null) {
            ExtendNumberAxis.axisInfo = axisInfo;
        }
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = new AxisState(d);
        if (!this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickMarkOutsideLength();
        double d3 = this.getTickMarkInsideLength();
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = list.iterator();
        int n = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        while (iterator.hasNext()) {
            ++n;
            ValueTick valueTick = (ValueTick)iterator.next();
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                float[] fArray = this.calculateAnchorPoint(valueTick, d, rectangle2D2, rectangleEdge);
                TextUtilities.drawRotatedString((String)valueTick.getText(), (Graphics2D)graphics2D, (float)fArray[0], (float)fArray[1], (TextAnchor)valueTick.getTextAnchor(), (double)valueTick.getAngle(), (TextAnchor)valueTick.getRotationAnchor());
            }
            if (!this.isTickMarksVisible()) continue;
            float f3 = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            double d4 = d2 + 2.0;
            if (RectangleEdge.RIGHT == rectangleEdge) {
                double_ = new Line2D.Double(d + d4, f3, d - d3, f3);
            } else if (RectangleEdge.BOTTOM == rectangleEdge) {
                double_ = new Line2D.Double(f3, d + d2, f3, d - d3);
            } else if (RectangleEdge.TOP == rectangleEdge) {
                double_ = new Line2D.Double(f3, d - d2, f3, d + d3);
            } else if (RectangleEdge.LEFT == rectangleEdge) {
                double_ = new Line2D.Double(d - d4, f3, d + d3, f3);
            }
            graphics2D.draw(double_);
            if (n == 1) {
                f = f3;
                continue;
            }
            f2 = Math.abs(f3 - f);
            if (f2 != 0.0f) {
                int n2 = axisInfo.getXAxisShowScaleUnit();
                if (n2 <= 0) {
                    AxisInfo axisInfo = new AxisInfo();
                    n2 = axisInfo.getXAxisShowScaleUnit();
                }
                f2 /= (float)n2;
                for (int i = 0; i < n2; ++i) {
                    f -= f2;
                    double_ = null;
                    graphics2D.setStroke(this.getTickMarkStroke());
                    graphics2D.setPaint(this.getTickMarkPaint());
                    if (RectangleEdge.RIGHT == rectangleEdge) {
                        double_ = new Line2D.Double(d + d2, f, d - d3, f);
                    } else if (RectangleEdge.BOTTOM == rectangleEdge) {
                        double_ = new Line2D.Double(f3, d + d2, f3, d - d3);
                    } else if (RectangleEdge.TOP == rectangleEdge) {
                        double_ = new Line2D.Double(f3, d - d2, f3, d + d3);
                    } else if (RectangleEdge.LEFT == rectangleEdge) {
                        double_ = new Line2D.Double(d - d2, f, d + d3, f);
                    }
                    graphics2D.draw(double_);
                }
            }
            f = f3;
        }
        double d5 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (RectangleEdge.BOTTOM == rectangleEdge) {
                d5 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d5);
            } else if (RectangleEdge.LEFT == rectangleEdge) {
                axisState.cursorLeft(d5 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (RectangleEdge.RIGHT == rectangleEdge) {
                d5 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d5);
            } else if (RectangleEdge.TOP == rectangleEdge) {
                d5 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d5);
            }
        }
        this.chartArea = rectangle2D2;
        return axisState;
    }

    Number getValueAtAxis(double d) {
        if (this.chartArea != null) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            d4 = this.chartArea.getHeight();
            d5 = this.getUpperBound() - this.getLowerBound();
            d3 = this.chartArea.getMinY();
            if (d < d3 || d > d3 + d4) {
                return null;
            }
            d2 = (d - d3) / d4;
            double d6 = d5 * d2;
            double d7 = this.getUpperBound() - d6;
            return new Double(d7);
        }
        return null;
    }
}

