/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.AxisInfo;
import com.swimap.iview.templates.charts.curve.ChartGraphPanel;
import com.swimap.iview.templates.charts.curve.DateAxisPaintListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class ExtendDateAxis
extends DateAxis {
    private static AxisInfo axisInfo = new AxisInfo();
    private ChartGraphPanel chartGraphPanel = null;
    private DateAxisPaintListener paintListener = null;
    private double currentPointerX = -1.0;
    private double currentPointerY = -1.0;
    private static final double DEFAULT_PERCENT = 0.5;
    private double percent = 0.5;
    private double totolWidth = 0.0;
    private double maxX = 0.0;
    private double minX = 0.0;
    private Vector markVector = new Vector(40, 8);
    private int index = -1;
    private double gap = 0.0;
    private Date beginDate = null;
    private long basalDateL = -1L;
    private long currentDateL = -1L;
    private boolean timeCycled = false;
    private final Date adjustUpperDate = new Date();
    private final Date adjustLowerDate = new Date();
    private Rectangle2D area = null;
    private static final long NON_VALUE = -1L;
    private boolean resetRange = false;
    private int[] xpoints = null;
    private int[] ypoints = null;
    private int dataCount = 0;

    public void setPaintListener(DateAxisPaintListener dateAxisPaintListener) {
        this.paintListener = dateAxisPaintListener;
    }

    public void setChartGraphPanel(ChartGraphPanel chartGraphPanel) {
        this.chartGraphPanel = chartGraphPanel;
    }

    public ExtendDateAxis(String string) {
        super(string);
    }

    public ExtendDateAxis(AxisInfo axisInfo) {
        this(axisInfo == null ? ExtendDateAxis.axisInfo.getXAxisLabel() : axisInfo.getXAxisLabel());
        if (axisInfo != null) {
            ExtendDateAxis.axisInfo = axisInfo;
        }
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (this.paintListener != null) {
            this.paintListener.paint();
        }
        AxisState axisState = this.extendDrawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        this.currentPointerY = d;
        this.area = rectangle2D2;
        return axisState;
    }

    public List refreshTicksHorizontal(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D2, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        block5: while (!date2.before(date)) {
            if (this.isHiddenValue(date.getTime())) {
                date = dateTickUnit.rollDate(date);
                continue;
            }
            TextAnchor textAnchor = null;
            TextAnchor textAnchor2 = null;
            double d2 = 0.0;
            if (this.isVerticalTickLabels()) {
                textAnchor = TextAnchor.CENTER_RIGHT;
                textAnchor2 = TextAnchor.CENTER_RIGHT;
                d2 = RectangleEdge.TOP == rectangleEdge ? 1.5707963267948966 : -1.5707963267948966;
            } else if (RectangleEdge.TOP == rectangleEdge) {
                textAnchor = TextAnchor.BOTTOM_CENTER;
                textAnchor2 = TextAnchor.BOTTOM_CENTER;
            } else {
                textAnchor = TextAnchor.TOP_CENTER;
                textAnchor2 = TextAnchor.TOP_CENTER;
            }
            DateTick dateTick = new DateTick(date, this.parse(date), textAnchor, textAnchor2, d2);
            arrayList.add(dateTick);
            date = dateTickUnit.addToDate(date);
            switch (dateTickUnit.getUnit()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: {
                    date = this.calculateDateForPosition((RegularTimePeriod)new Month(date), this.getTickMarkPosition());
                    continue block5;
                }
                case 0: {
                    date = this.calculateDateForPosition((RegularTimePeriod)new Year(date), this.getTickMarkPosition());
                    continue block5;
                }
            }
        }
        return arrayList;
    }

    private AxisState extendDrawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d2;
        boolean bl = true;
        AxisState axisState = new AxisState(d);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        double d3 = this.getTickMarkOutsideLength();
        double d4 = this.getTickMarkInsideLength();
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = list.iterator();
        double d5 = -1.0;
        ValueTick valueTick = null;
        ValueTick valueTick2 = null;
        ValueTick valueTick3 = null;
        Line2D.Double double_ = null;
        this.markVector.clear();
        while (iterator.hasNext()) {
            valueTick3 = (ValueTick)iterator.next();
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                super.setTickMarksVisible(true);
                float[] fArray = this.calculateAnchorPoint(valueTick3, d, rectangle2D2, rectangleEdge);
                if (this.needDrawTick(valueTick3.getText())) {
                    TextUtilities.drawRotatedString((String)valueTick3.getText(), (Graphics2D)graphics2D, (float)fArray[0], (float)fArray[1], (TextAnchor)valueTick3.getTextAnchor(), (double)valueTick3.getAngle(), (TextAnchor)valueTick3.getRotationAnchor());
                    if (bl && this.isAtLeft()) {
                        TextUtilities.drawRotatedString((String)"00:00:00", (Graphics2D)graphics2D, (float)((float)rectangle2D2.getX()), (float)fArray[1], (TextAnchor)valueTick3.getTextAnchor(), (double)valueTick3.getAngle(), (TextAnchor)valueTick3.getRotationAnchor());
                        bl = false;
                    }
                }
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            double d6 = this.valueToJava2D(valueTick3.getValue(), rectangle2D2, rectangleEdge);
            if (d5 < 0.0) {
                d5 = d6;
                valueTick = valueTick3;
            } else {
                int n = axisInfo.getXAxisShowScaleUnit();
                this.gap = (d6 - d5) / (double)n;
                for (int i = 1; i < n; ++i) {
                    double_ = new Line2D.Double(d5 + this.gap * (double)i, d + d3, d5 + this.gap * (double)i, d - d4);
                    graphics2D.draw(double_);
                    this.markVector.add(new Double(d5 + this.gap * (double)i));
                }
                d5 = d6;
            }
            d2 = d3 + 2.0;
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d - d3, d6, d + d4, d6);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d + d3, d6, d - d4, d6);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(d6, d - d3, d6, d + d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(d6, d + d2, d6, d - d4);
            }
            graphics2D.draw(double_);
            this.markVector.add(new Double(d6));
        }
        if (valueTick3 != null && valueTick != null) {
            valueTick2 = valueTick3;
            double d7 = this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            d2 = this.valueToJava2D(valueTick2.getValue(), rectangle2D2, rectangleEdge);
            double d8 = d2 + this.gap;
            double d9 = this.valueToJava2D(this.getLowerBound(), rectangle2D2, rectangleEdge);
            double d10 = this.valueToJava2D(this.getUpperBound(), rectangle2D2, rectangleEdge);
            for (double d11 = d7 - this.gap; d11 >= d9; d11 -= this.gap) {
                double_ = new Line2D.Double(d11, d + d3, d11, d - d4);
                graphics2D.draw(double_);
                this.markVector.add(0, new Double(d11));
            }
            while (d8 < d10) {
                double_ = new Line2D.Double(d8, d + d3, d8, d - d4);
                graphics2D.draw(double_);
                this.markVector.add(new Double(d8));
                d8 += this.gap;
            }
            this.markVector.add(new Double(this.maxX));
        }
        double d12 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge == RectangleEdge.LEFT) {
                axisState.cursorLeft(d12 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d12 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d12);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d12 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d12);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d12 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d12);
            }
        }
        return axisState;
    }

    void drowPointer(Graphics2D graphics2D) {
        boolean bl = false;
        Color color = Color.RED;
        if (this.chartGraphPanel != null) {
            bl = this.chartGraphPanel.isPointerNeedVisible();
            color = this.chartGraphPanel.getPointerColor();
        }
        if (bl) {
            double d;
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 2);
            this.minX = this.area.getMinX();
            this.maxX = this.area.getMaxX();
            this.totolWidth = this.maxX - this.minX;
            if (this.currentPointerX == -1.0) {
                this.currentPointerX = this.maxX - this.minX > 0.0 ? (this.maxX - this.minX) / 2.0 + this.minX + 3.0 : this.area.getMaxX();
            }
            this.currentPointerX = d = (double)((int)(this.minX + this.totolWidth * this.percent));
            Line2D.Double double_ = new Line2D.Double(d, this.area.getMinY(), d, this.area.getMaxY());
            graphics2D.setPaint(color);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(double_);
            double d2 = this.getTickMarkOutsideLength();
            double d3 = this.getTickMarkInsideLength();
            Line2D.Double double_2 = new Line2D.Double(d, this.currentPointerY + d2 + 20.0, d, this.currentPointerY - d3);
            graphics2D.setPaint(color);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(double_2);
            int n = (int)(this.currentPointerY + d2 + 20.0);
            int n2 = (int)d;
            this.xpoints = new int[]{n2 - 8, n2, n2 + 8};
            this.ypoints = new int[]{n + 8, n, n + 8};
            Polygon polygon = new Polygon(this.xpoints, this.ypoints, 3);
            graphics2D.draw(polygon);
            graphics2D.fill(polygon);
        }
    }

    double getCurrPointX() {
        return this.currentPointerX;
    }

    public void setPointPostion(int n, int n2) {
        this.currentPointerX += (double)(n - n2);
        this.index = -1;
        if (this.currentPointerX > this.maxX) {
            this.currentPointerX = this.maxX;
            this.percent = 1.0;
        } else if (this.currentPointerX < this.minX) {
            this.currentPointerX = this.minX;
            this.percent = 0.0;
        } else if (this.totolWidth > 0.0) {
            double d;
            Enumeration enumeration = this.markVector.elements();
            while (enumeration.hasMoreElements() && (d = ((Double)enumeration.nextElement()).doubleValue()) <= this.currentPointerX) {
                ++this.index;
            }
            if (this.index != -1) {
                this.percent = ((Double)this.markVector.get(this.index) - this.minX) / this.totolWidth;
            }
        }
    }

    double getPositionOfPercent(double d) {
        return this.minX + this.totolWidth * d;
    }

    double getGapOffset() {
        return this.gap;
    }

    public boolean isInPointerScope(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return this.xpoints != null && this.ypoints != null && n2 >= this.ypoints[1] && n2 <= this.ypoints[0] && n >= this.xpoints[0] && n <= this.xpoints[2];
    }

    public boolean isInPointerScope(Point2D point2D) {
        int n = (int)point2D.getX();
        int n2 = (int)point2D.getY();
        return this.xpoints != null && this.ypoints != null && n2 >= this.ypoints[1] && n2 <= this.ypoints[0] && n >= this.xpoints[0] && n <= this.xpoints[2];
    }

    public double getCurrentPointerPostion() {
        return this.percent;
    }

    double getPercent() {
        return this.percent;
    }

    void setPercent(double d) {
        this.percent = d > 1.0 ? 1.0 : (d < 0.0 ? 0.0 : d);
    }

    void resetExtendDateAxis() {
        this.resetRange = true;
        this.autoAdjustRange();
        this.resetRange = false;
        this.setPercent(1.0);
        this.basalDateL = -1L;
        this.dataCount = 0;
        this.beginDate = ((DateRange)this.getRange()).getUpperDate();
    }

    protected void autoAdjustRange() {
        long l = (long)this.getFixedAutoRange();
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)plot;
            Range range = valueAxisPlot.getDataRange((ValueAxis)this);
            if (range == null || this.resetRange) {
                Date date = new Date();
                date.setHours(0);
                date.setMinutes(0);
                date.setSeconds(0);
                long l2 = date.getTime();
                l2 /= 1000L;
                l2 *= 1000L;
                long l3 = 1L;
                if ((double)l > 0.0) {
                    l3 = l2 - l;
                }
                range = new DateRange((double)l3, (double)l2);
            }
            this.adjustUpperDate.setTime((long)range.getUpperBound());
            long l4 = this.getTimeline().toTimelineValue(this.adjustUpperDate);
            long l5 = 0L;
            if ((double)l > 0.0) {
                l5 = l4 - l;
            } else {
                this.adjustLowerDate.setTime((long)range.getLowerBound());
                l5 = this.getTimeline().toTimelineValue(this.adjustLowerDate);
                double d = l4 - l5;
                long l6 = (long)this.getAutoRangeMinimumSize();
                if (d < (double)l6) {
                    long l7 = (long)((double)l6 - d) / 2L;
                    l4 += l7;
                    l5 -= l7;
                }
                l4 += (long)(d * this.getUpperMargin());
                l5 -= (long)(d * this.getLowerMargin());
            }
            l4 = this.getTimeline().toMillisecond(l4);
            l5 = this.getTimeline().toMillisecond(l5);
            DateRange dateRange = new DateRange(new Date(l5), new Date(l4));
            this.setRange((Range)dateRange, false, false);
        }
    }

    protected Date previousStandardDate(Date date, DateTickUnit dateTickUnit) {
        long l;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = axisInfo.getXAxisBasicScaleUnit();
        int n9 = axisInfo.getXAxisShowScaleUnit();
        int n10 = dateTickUnit.getCount();
        int n11 = 0;
        Calendar calendar = Calendar.getInstance();
        if (n10 == n8 * n9) {
            l = (long)this.getFixedAutoRange();
            Date date2 = new Date(date.getTime() + l);
            int n12 = (date2.getHours() * 60 + date2.getMinutes()) * 60 + date2.getSeconds();
            int n13 = n12 / n10;
            long l2 = date2.getTime() - (long)(n12 * 1000) - l + (long)(n13 * n10 * 1000);
            Date date3 = new Date(l2);
            calendar.setTime(date3);
            n11 = calendar.get(13);
        } else {
            calendar.setTime(date);
            int n14 = calendar.get(dateTickUnit.getCalendarField());
            n11 = n10 * (n14 / n10);
        }
        switch (dateTickUnit.getUnit()) {
            case 6: {
                n2 = calendar.get(13);
                n3 = calendar.get(12);
                n4 = calendar.get(11);
                n5 = calendar.get(5);
                n6 = calendar.get(2);
                n7 = calendar.get(1);
                calendar.set(n7, n6, n5, n4, n3, n2);
                calendar.set(14, n11);
                return calendar.getTime();
            }
            case 5: {
                n3 = calendar.get(12);
                n4 = calendar.get(11);
                n5 = calendar.get(5);
                n6 = calendar.get(2);
                n7 = calendar.get(1);
                n = this.getTickMarkPosition() == DateTickMarkPosition.START ? 0 : (this.getTickMarkPosition() == DateTickMarkPosition.MIDDLE ? 500 : 999);
                calendar.set(14, n);
                calendar.set(n7, n6, n5, n4, n3, n11);
                return calendar.getTime();
            }
            case 4: {
                n4 = calendar.get(11);
                n5 = calendar.get(5);
                n6 = calendar.get(2);
                n7 = calendar.get(1);
                n2 = this.getTickMarkPosition() == DateTickMarkPosition.START ? 0 : (this.getTickMarkPosition() == DateTickMarkPosition.MIDDLE ? 30 : 59);
                calendar.clear(14);
                calendar.set(n7, n6, n5, n4, n11, n2);
                return calendar.getTime();
            }
            case 3: {
                n5 = calendar.get(5);
                n6 = calendar.get(2);
                n7 = calendar.get(1);
                if (this.getTickMarkPosition() == DateTickMarkPosition.START) {
                    n3 = 0;
                    n2 = 0;
                } else if (this.getTickMarkPosition() == DateTickMarkPosition.MIDDLE) {
                    n3 = 30;
                    n2 = 0;
                } else {
                    n3 = 59;
                    n2 = 59;
                }
                calendar.clear(14);
                calendar.set(n7, n6, n5, n11, n3, n2);
                return calendar.getTime();
            }
            case 2: {
                n6 = calendar.get(2);
                n7 = calendar.get(1);
                if (this.getTickMarkPosition() == DateTickMarkPosition.START) {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                } else if (this.getTickMarkPosition() == DateTickMarkPosition.MIDDLE) {
                    n4 = 12;
                    n3 = 0;
                    n2 = 0;
                } else {
                    n4 = 23;
                    n3 = 59;
                    n2 = 59;
                }
                calendar.clear(14);
                calendar.set(n7, n6, n11, n4, 0, 0);
                l = calendar.getTime().getTime();
                if (l > date.getTime()) {
                    calendar.set(n7, n6, n11 - 1, n4, 0, 0);
                }
                return calendar.getTime();
            }
            case 1: {
                n7 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n7, n11, 1, 0, 0, 0);
                Month month = new Month(calendar.getTime());
                Date date4 = this.calculateDateForPosition((RegularTimePeriod)month, this.getTickMarkPosition());
                long l3 = date4.getTime();
                if (l3 > date.getTime()) {
                    month = (Month)month.previous();
                    date4 = this.calculateDateForPosition((RegularTimePeriod)month, this.getTickMarkPosition());
                }
                return date4;
            }
            case 0: {
                n6 = this.getTickMarkPosition() == DateTickMarkPosition.START ? 0 : (this.getTickMarkPosition() == DateTickMarkPosition.MIDDLE ? 6 : 12);
                calendar.clear(14);
                calendar.set(n11, n6, 1, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    private Date calculateDateForPosition(RegularTimePeriod regularTimePeriod, DateTickMarkPosition dateTickMarkPosition) {
        if (dateTickMarkPosition == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        if (dateTickMarkPosition == DateTickMarkPosition.START) {
            return new Date(regularTimePeriod.getFirstMillisecond());
        }
        if (dateTickMarkPosition == DateTickMarkPosition.MIDDLE) {
            return new Date(regularTimePeriod.getMiddleMillisecond());
        }
        if (dateTickMarkPosition == DateTickMarkPosition.END) {
            return new Date(regularTimePeriod.getLastMillisecond());
        }
        return null;
    }

    private boolean needDrawTick(String string) {
        return this.getMinimumDate().getTime() >= this.beginDate.getTime() || string.indexOf("00:") == 0;
    }

    public void setBeginDate(Date date) {
        if (this.dataCount > 1) {
            return;
        }
        this.beginDate = date;
        ++this.dataCount;
    }

    private boolean isAtLeft() {
        return this.getMinimumDate().getHours() == 0 && this.getMinimumDate().getMinutes() == 0 && this.getMinimumDate().getSeconds() == 0;
    }

    void setBasalDate(Date date) {
        if (date == null) {
            this.basalDateL = -1L;
        } else if (this.basalDateL == -1L) {
            this.basalDateL = date.getTime();
        }
    }

    void setCurrentDate(Date date) {
        if (date == null) {
            return;
        }
        this.currentDateL = date.getTime() + (long)this.getFixedAutoRange();
    }

    private String parse(Date date) {
        if (date == null) {
            return null;
        }
        String string = null;
        DateFormat dateFormat = this.getDateFormatOverride();
        string = dateFormat != null ? dateFormat.format(date) : this.getTickUnit().dateToString(date);
        if (this.timeCycled || this.basalDateL == -1L) {
            return string;
        }
        if (string.length() < 2) {
            return string;
        }
        int n = Integer.parseInt(string.substring(0, 2));
        if ((n += this.getHourOffset(date.getTime())) < 24) {
            return string;
        }
        return n + string.substring(2, string.length());
    }

    int getHourOffset() {
        return this.getHourOffset(this.currentDateL);
    }

    int getHourOffset(long l) {
        return (int)((l - this.basalDateL / 1000L * 1000L) / 86400000L) * 24;
    }

    void setTimeCycled(boolean bl) {
        this.timeCycled = bl;
    }

    boolean isTimeCycled() {
        return this.timeCycled;
    }

    long getValueAtAxis(double d) {
        if (this.area != null) {
            DateRange dateRange;
            long l;
            double d2 = 0.0;
            Date date = null;
            double d3 = this.area.getWidth();
            double d4 = this.area.getMinX();
            if (d < d4 || d > d4 + d3) {
                return -1L;
            }
            d2 = (d - d4) / d3;
            long l2 = (long)(this.getFixedAutoRange() * d2);
            Range range = this.getRange();
            if (range instanceof DateRange && (l = (date = (dateRange = (DateRange)range).getLowerDate()).getTime() + l2) >= this.chartGraphPanel.getFirstTimeStarted() && this.chartGraphPanel.getFirstTimeStarted() != 0L) {
                return l;
            }
        }
        return -1L;
    }
}

