/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.curve;

import com.swimap.iview.templates.charts.curve.AxisInfo;
import com.swimap.iview.templates.charts.curve.ExtendChartPanel;
import com.swimap.iview.templates.charts.curve.ExtendDateAxis;
import com.swimap.iview.templates.charts.curve.ExtendNumberAxis;
import com.swimap.iview.templates.charts.curve.ExtendStandardXYItemRenderer;
import com.swimap.iview.templates.charts.curve.ExtendStandardXYToolTipGenerator;
import com.swimap.iview.templates.charts.curve.ExtendXYPlot;
import com.swimap.iview.templates.charts.curve.PointerChangeListener;
import com.swimap.iview.templates.charts.curve.ScrollBarProcess;
import com.swimap.iview.templates.charts.curve.TaskInfo;
import com.swimap.iview.templates.charts.curve.TaskInfoChangeEvent;
import com.swimap.iview.templates.charts.curve.TaskInfoChangeListener;
import com.swimap.iview.templates.charts.curve.expand.CommonTools;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.DateRange;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class ChartGraphPanel
extends JPanel
implements TaskInfoChangeListener {
    private static IviewLogger logger = IviewLogger.getLogger(ChartGraphPanel.class, "IVIEW");
    private ChartPanel chartPanel = null;
    private AxisInfo axisInfo = new AxisInfo();
    private boolean firstDateAdd = false;
    private DefaultDrawingSupplier defaultDrawingSupplier = new DefaultDrawingSupplier();
    private long firstTimeStart = 0L;
    private TaskInfo.TaskDataCoordinate firstCoordinate = null;
    private transient EventListenerList listenerList = new EventListenerList();
    private static final int MAX_DRAW_HEIGHT = 1000;
    private static final int MAX_DRAW_WIDTH = 1200;
    private static final int MIN_DRAW_HEIGHT = 150;
    private static final int MIN_DRAW_WIDTH = 250;
    private final CommonTools commonTools = new CommonTools();
    private static final int DEFAULT_PERIOD_TIME = 5000;
    private int periodTime = 5000;
    private static final String daemonTaskName = "DaemonTaskABCDEFGasdfba{}*&$% ";
    private final DaemonTask daemonTask = new DaemonTask("DaemonTaskABCDEFGasdfba{}*&$% ");
    private static final Paint[] DEFAULT_CHARTCOLOR = new Paint[]{Color.black, Color.red, ChartColor.DARK_GREEN, ChartColor.DARK_BLUE, new Color(208, 32, 255), Color.yellow, ChartColor.LIGHT_BLUE, ChartColor.LIGHT_RED, ChartColor.LIGHT_GREEN, new Color(160, 32, 255)};
    private Hashtable taskHashtable = new Hashtable(12);
    private JPopupMenu popMenu = null;
    private String chartTitle = "";
    private boolean legend = false;
    private boolean toolTip = true;
    private boolean isAutoScroll = true;
    private boolean isPointVisible = false;
    private Color pointerColor = Color.RED;
    private static final int MULTIPLE = 1000;
    private ScrollBarProcess scrollProcess = null;

    DaemonTask getDaemonTask() {
        return this.daemonTask;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setBeginTime(Date date) {
        if (date != null) {
            this.scrollProcess.setBeginTimeEnable(true);
            this.scrollProcess.setBeginTime(date.getTime());
        }
    }

    public Date getBeginTime() {
        return new Date(this.scrollProcess.getBeginTime());
    }

    public void setBeginTimeVisible(boolean bl) {
        this.scrollProcess.setBegintimeVisible(bl);
    }

    public void setYTipFormat(NumberFormat numberFormat) {
        ((ExtendChartPanel)this.chartPanel).setYFormat(numberFormat);
    }

    public ChartGraphPanel() {
        this.axisInfo = new AxisInfo();
        this.initializeColorInfos(null);
        this.init();
        this.addTask(this.daemonTask);
    }

    public ChartGraphPanel(String string, AxisInfo axisInfo, Color[] colorArray, boolean bl, boolean bl2) {
        this.chartTitle = string;
        this.axisInfo = axisInfo;
        this.initializeColorInfos(colorArray);
        this.legend = bl;
        this.toolTip = bl2;
        this.init();
        this.addTask(this.daemonTask);
    }

    public void close() {
        this.scrollProcess.clearLabelTimer();
        this.clearTask();
        this.taskHashtable.clear();
        this.taskHashtable = null;
    }

    public void resetChart() {
        if (!this.taskHashtable.isEmpty()) {
            this.clearTask();
            this.taskHashtable.clear();
        }
        this.daemonTask.getTimeSeries().clear();
        this.setFirstTimeStarted(0L);
        this.firstDateAdd = false;
        this.scrollProcess.resetScrollBarProcess();
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        ExtendDateAxis extendDateAxis = (ExtendDateAxis)xYPlot.getDomainAxis();
        extendDateAxis.resetExtendDateAxis();
        this.chartPanel.setRefreshBuffer(true);
        this.chartPanel.repaint();
    }

    private void clearTask() {
        TaskInfo[] taskInfoArray = this.getTaskInfos();
        String string = null;
        if (taskInfoArray != null) {
            for (int i = 0; i < taskInfoArray.length; ++i) {
                string = taskInfoArray[i].getTaskName();
                this.deleteTask(string);
            }
        }
    }

    private void initializeColorInfos(Color[] colorArray) {
        if (colorArray != null && colorArray.length == 10) {
            System.arraycopy(colorArray, 0, DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, 0, 10);
        } else {
            System.arraycopy(DEFAULT_CHARTCOLOR, 0, DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, 0, 10);
        }
    }

    private void init() {
        JFreeChart jFreeChart = this.createChart(null);
        jFreeChart.setBackgroundPaint(null);
        this.chartPanel = new ExtendChartPanel(jFreeChart, true);
        this.chartPanel.setMaximumDrawHeight(1000);
        this.chartPanel.setMaximumDrawWidth(1200);
        this.chartPanel.setMinimumDrawHeight(150);
        this.chartPanel.setMinimumDrawWidth(250);
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
        this.scrollProcess = new ScrollBarProcess(this);
        this.add((Component)this.scrollProcess.getScrollBarPanel(), "South");
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        ExtendDateAxis extendDateAxis = (ExtendDateAxis)xYPlot.getDomainAxis();
        extendDateAxis.setPercent(1.0);
        this.setPopupMenu(this.popMenu);
        MouseHandler mouseHandler = new MouseHandler();
        this.chartPanel.addMouseListener((MouseListener)mouseHandler);
        this.addMouseListener(mouseHandler);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setBackgroud(Color color) {
        this.chartPanel.getChart().setBackgroundPaint((Paint)color);
        this.scrollProcess.getScrollBarPanel().setBackground(color);
    }

    public void setPeriodTime(int n) {
        if (this.getTaskInfos() != null) {
            throw new IllegalStateException("set period time must before add task!!!");
        }
        this.periodTime = n;
    }

    public int getPeriodTime() {
        return this.periodTime;
    }

    public void setPointerTime(Date date) {
        if (date != null) {
            this.setPointerTime(date.getTime() - this.firstTimeStart);
        }
    }

    private void setPointerTime(long l) {
        long l2 = l;
        l2 /= 1000L;
        l2 *= 1000L;
        if (!this.isPointerNeedVisible()) {
            return;
        }
        if (l2 < -1000L) {
            return;
        }
        JScrollBar jScrollBar = this.scrollProcess.getScrollBar();
        ExtendDateAxis extendDateAxis = (ExtendDateAxis)this.chartPanel.getChart().getXYPlot().getDomainAxis();
        long l3 = (long)extendDateAxis.getFixedAutoRange();
        logger.trace("" + l3);
        double d = 0.0;
        if (!jScrollBar.isEnabled()) {
            if (l2 <= l3) {
                long l4 = this.firstTimeStart + l2;
                DateRange dateRange = (DateRange)extendDateAxis.getRange();
                Date date = dateRange.getUpperDate();
                Date date2 = dateRange.getLowerDate();
                d = (double)(l4 - date2.getTime()) / (double)(date.getTime() - date2.getTime());
                extendDateAxis.setPercent(d);
            } else {
                extendDateAxis.setPercent(1.0);
            }
            this.chartPanel.getChart().fireChartChanged();
            return;
        }
        long l5 = this.getCurrentPointerTime().getTime() - this.firstCoordinate.getTaskTime().getTime();
        long l6 = Math.abs(l2 - l5) / ((long)this.axisInfo.getXAxisBasicScaleUnit() * 1000L);
        int n = (int)l6;
        int n2 = jScrollBar.getValue();
        long l7 = l3 / ((long)this.axisInfo.getXAxisBasicScaleUnit() * 1000L);
        int n3 = (int)l7;
        d = extendDateAxis.getPercent();
        if (l2 > l5) {
            jScrollBar.setValue(n2 + n);
            if (n2 + n > jScrollBar.getValue()) {
                double d2 = d + (double)(n2 + n - jScrollBar.getValue()) / (double)n3;
                extendDateAxis.setPercent(d2);
                this.chartPanel.getChart().fireChartChanged();
            }
            this.scrollProcess.paint();
        } else if (l2 < l5) {
            if (n2 <= n) {
                jScrollBar.setValue(jScrollBar.getMinimum());
                this.scrollProcess.paint();
                double d3 = d - (double)(n - n2 + 1) / (double)n3;
                extendDateAxis.setPercent(d3);
                this.chartPanel.getChart().fireChartChanged();
                return;
            }
            jScrollBar.setValue(n2 - n - 1);
            this.scrollProcess.paint();
        }
    }

    public TaskInfo addTask(String string, String string2) {
        if (string == null || this.taskHashtable.containsKey(string)) {
            return null;
        }
        TaskInfo taskInfo = new TaskInfo(string, string2, null, 1, 1, string2);
        if (this.addTask(taskInfo)) {
            return taskInfo;
        }
        return null;
    }

    public boolean addTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return false;
        }
        if (taskInfo.getTaskName() == null || this.taskHashtable.containsKey(taskInfo.getTaskName())) {
            return false;
        }
        taskInfo.addChangeListener(this);
        TimeSeries timeSeries = null;
        if (taskInfo.getToolTipName() != null) {
            timeSeries = new TimeSeries((Comparable)((Object)taskInfo.getToolTipName()), Millisecond.class);
            taskInfo.setTimeSeries(timeSeries);
        } else if (taskInfo.getTaskLabel() != null) {
            timeSeries = new TimeSeries((Comparable)((Object)taskInfo.getTaskLabel()), Millisecond.class);
            taskInfo.setTimeSeries(timeSeries);
        } else {
            timeSeries = new TimeSeries((Comparable)((Object)taskInfo.getTaskName()), Millisecond.class);
            taskInfo.setTimeSeries(timeSeries);
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        timeSeriesCollection.setDomainIsPointsInTime(false);
        timeSeries.setMaximumItemCount(TaskInfo.getMaxDataCount());
        timeSeries.setMaximumItemAge((long)(this.periodTime * (TaskInfo.getMaxDataCount() + 36)));
        taskInfo.setDataset(timeSeriesCollection);
        if (!(taskInfo instanceof DaemonTask)) {
            this.taskHashtable.put(taskInfo.getTaskName(), taskInfo);
        }
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        xYPlot.setDataset(xYPlot.getDatasetCount(), (XYDataset)taskInfo.getDataset());
        ExtendStandardXYToolTipGenerator extendStandardXYToolTipGenerator = null;
        if (this.toolTip) {
            extendStandardXYToolTipGenerator = ExtendStandardXYToolTipGenerator.getToolTipInstance();
        }
        XYURLGenerator xYURLGenerator = null;
        ExtendStandardXYItemRenderer extendStandardXYItemRenderer = new ExtendStandardXYItemRenderer(2, (XYToolTipGenerator)extendStandardXYToolTipGenerator, xYURLGenerator, this.axisInfo);
        extendStandardXYItemRenderer.setChartGraphPanel(this);
        xYPlot.setRenderer(xYPlot.getDatasetCount(), (XYItemRenderer)extendStandardXYItemRenderer);
        this.setUserTaskInfo(taskInfo);
        return true;
    }

    void setFirstTimeStarted(long l) {
        this.firstTimeStart = l;
    }

    void setFirstCoordinate(TaskInfo.TaskDataCoordinate taskDataCoordinate) {
        this.firstCoordinate = taskDataCoordinate;
    }

    long getFirstTimeStarted() {
        return this.firstTimeStart;
    }

    TaskInfo.TaskDataCoordinate getFirstCoordinate() {
        return this.firstCoordinate;
    }

    private void setUserTaskInfo(TaskInfo taskInfo) {
        Paint paint;
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        if (taskInfo.getLineColor() == null) {
            paint = xYPlot.getRenderer(xYPlot.getDatasetCount()).getSeriesPaint(0);
            taskInfo.modifyLineColor((Color)paint);
        }
        if ((paint = xYPlot.getRenderer(xYPlot.indexOf((XYDataset)taskInfo.getDataset()))) == null) {
            paint = xYPlot.getRenderer();
        }
        if (paint instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)paint;
            standardXYItemRenderer.setSeriesPaint(0, (Paint)taskInfo.getLineColor());
            this.setLineType(standardXYItemRenderer, taskInfo);
            this.setTaskLineShow(standardXYItemRenderer, taskInfo);
        }
        this.chartPanel.getChart().setTitle(this.chartPanel.getChart().getTitle());
    }

    private void setLineType(StandardXYItemRenderer standardXYItemRenderer, TaskInfo taskInfo) {
        int n = taskInfo.getLineType();
        int n2 = taskInfo.getLineWidth();
        this.commonTools.modifyLine(standardXYItemRenderer, n, n2);
    }

    private void setTaskLineShow(StandardXYItemRenderer standardXYItemRenderer, TaskInfo taskInfo) {
        standardXYItemRenderer.setPlotLines(taskInfo.getTaskLineIsShow());
        if (taskInfo.getLineType() == 2 || taskInfo.getLineType() == 3 || taskInfo.getLineType() == 5) {
            standardXYItemRenderer.setBaseShapesVisible(taskInfo.getTaskLineIsShow());
        }
    }

    public boolean deleteTask(String string) {
        if (string == null || !this.taskHashtable.containsKey(string)) {
            return false;
        }
        if (string.equals(daemonTaskName)) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)this.taskHashtable.remove(string);
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        int n = xYPlot.indexOf((XYDataset)taskInfo.getDataset());
        xYPlot.setDataset(n, null);
        xYPlot.setRenderer(n, null);
        taskInfo.getDataset().removeSeries(taskInfo.getTimeSeries());
        taskInfo = null;
        return true;
    }

    public TaskInfo[] getTaskInfos() {
        if (!this.taskHashtable.isEmpty()) {
            TaskInfo[] taskInfoArray = new TaskInfo[this.taskHashtable.size()];
            this.taskHashtable.values().toArray(taskInfoArray);
            return taskInfoArray;
        }
        return null;
    }

    AxisInfo getAxisInfo() {
        return this.axisInfo;
    }

    public boolean isAutoScroll() {
        return this.isAutoScroll;
    }

    public void setAutoScroll(boolean bl) {
        this.isAutoScroll = bl;
        if (!this.isAutoScroll) {
            this.scrollProcess.scrollmove(this.isAutoScroll);
        }
        if (this.isAutoScroll) {
            this.chartPanel.getChart().getXYPlot().getDomainAxis().setAutoRange(bl);
            this.scrollToRight();
            this.scrollProcess.scrollmove(this.isAutoScroll);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popMenu;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popMenu = jPopupMenu;
        this.chartPanel.setPopupMenu(this.popMenu);
        this.scrollProcess.setPopupMenu(this.popMenu);
    }

    public void setGridLineVisible(boolean bl) {
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        xYPlot.setDomainGridlinesVisible(bl);
        xYPlot.setRangeGridlinesVisible(bl);
    }

    @Override
    public void taskInfoChanged(TaskInfoChangeEvent taskInfoChangeEvent) {
        TaskInfo taskInfo = taskInfoChangeEvent.getTaskInfo();
        if (taskInfo == null) {
            return;
        }
        if (taskInfoChangeEvent.getEventType() == 2) {
            if (taskInfo.getDataset().getSeries().size() != 0) {
                if (!this.firstDateAdd && taskInfo.getDataset().getSeries().size() == 1) {
                    this.scrollProcess.startLabelTimer();
                    this.firstDateAdd = true;
                }
                this.scrollProcess.setScrollBarEnable(taskInfo);
            }
            return;
        }
        this.setUserTaskInfo(taskInfoChangeEvent.getTaskInfo());
    }

    public boolean isChartDataAdded() {
        return this.firstDateAdd;
    }

    public void startTotalTime() {
        this.firstDateAdd = true;
        this.scrollProcess.startLabelTimer();
    }

    public void setPointerVisible(boolean bl) {
        if (this.isPointVisible != bl) {
            this.isPointVisible = bl;
            this.chartPanel.getChart().setTitle(this.chartPanel.getChart().getTitle());
        }
    }

    boolean isPointerNeedVisible() {
        return this.isPointVisible;
    }

    public void setPointerColor(Color color) {
        if (color != null) {
            this.pointerColor = color;
        }
    }

    Color getPointerColor() {
        return this.pointerColor;
    }

    public Date getCurrentPointerTime() {
        DateAxis dateAxis = (DateAxis)this.chartPanel.getChart().getXYPlot().getDomainAxis();
        long l = (long)dateAxis.getFixedAutoRange();
        Date date = dateAxis.getMinimumDate();
        double d = ((ExtendDateAxis)dateAxis).getCurrentPointerPostion();
        long l2 = (long)((double)date.getTime() + (double)l * d);
        if (this.firstTimeStart != 0L && l2 >= this.firstTimeStart - 500L) {
            long l3 = 0L;
            if (this.firstCoordinate != null) {
                l3 = this.firstCoordinate.getTaskTime().getTime() - this.firstTimeStart;
            }
            Date date2 = new Date(l2 + l3);
            Date date3 = new Date(0L);
            date3.setYear(date2.getYear());
            date3.setMonth(date2.getMonth());
            date3.setDate(date2.getDate());
            date3.setHours(date2.getHours());
            date3.setMinutes(date2.getMinutes());
            date3.setSeconds(date2.getSeconds());
            return new Date(date3.getTime());
        }
        logger.debug(" current time is before start time .firstTimeStart = " + new Date(this.firstTimeStart) + "currentTime =" + new Date(l2));
        return null;
    }

    public void addPointerChangeListener(PointerChangeListener pointerChangeListener) {
        this.listenerList.add(PointerChangeListener.class, pointerChangeListener);
    }

    public void removePointerChangeListener(PointerChangeListener pointerChangeListener) {
        this.listenerList.remove(PointerChangeListener.class, pointerChangeListener);
    }

    void firePointerChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PointerChangeListener.class) continue;
            ((PointerChangeListener)objectArray[i + 1]).positonChanged();
        }
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = this.createTimeSeriesChart(this.chartTitle, this.axisInfo.getYAxisLabel(), xYDataset, this.legend, this.toolTip, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        TickUnits tickUnits = new TickUnits();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        int n = this.axisInfo.getXAxisBasicScaleUnit() * this.axisInfo.getXAxisShowScaleUnit();
        tickUnits.add((TickUnit)new DateTickUnit(5, n, 5, 1, (DateFormat)simpleDateFormat));
        valueAxis.setStandardTickUnits((TickUnitSource)tickUnits);
        tickUnits = new TickUnits();
        valueAxis = xYPlot.getRangeAxis();
        valueAxis.setRange(this.axisInfo.getYAxisRange().getLowerBound(), this.axisInfo.getYAxisRange().getUpperBound());
        n = this.axisInfo.getYAxisBasicScaleUnit() * this.axisInfo.getYAxisShowScaleUnit();
        int n2 = (int)this.axisInfo.getYAxisRange().getLength() / 4;
        tickUnits.add((TickUnit)new NumberTickUnit((double)n, (NumberFormat)new DecimalFormat("0")));
        tickUnits.add((TickUnit)new NumberTickUnit((double)n2, (NumberFormat)new DecimalFormat("0")));
        valueAxis.setStandardTickUnits((TickUnitSource)tickUnits);
        ExtendNumberAxis extendNumberAxis = new ExtendNumberAxis(this.axisInfo.getYAxisLabel());
        extendNumberAxis.setStandardTickUnits((TickUnitSource)tickUnits);
        extendNumberAxis.setRange(this.axisInfo.getYAxisRange().getLowerBound(), this.axisInfo.getYAxisRange().getUpperBound());
        xYPlot.setRangeAxis(1, (ValueAxis)extendNumberAxis);
        xYPlot.setDrawingSupplier((DrawingSupplier)this.defaultDrawingSupplier);
        return jFreeChart;
    }

    private JFreeChart createTimeSeriesChart(String string, String string2, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        ExtendDateAxis extendDateAxis = new ExtendDateAxis(this.axisInfo);
        extendDateAxis.setLowerMargin(0.0);
        extendDateAxis.setUpperMargin(0.0);
        extendDateAxis.setChartGraphPanel(this);
        extendDateAxis.setFixedAutoRange(this.axisInfo.getXAxisScope());
        extendDateAxis.setAutoRange(true);
        extendDateAxis.setLabelInsets(new RectangleInsets(25.0, 3.0, 3.0, 3.0));
        ExtendNumberAxis extendNumberAxis = new ExtendNumberAxis(this.axisInfo);
        extendNumberAxis.setLabel(string2);
        extendNumberAxis.setAutoRangeIncludesZero(false);
        ExtendXYPlot extendXYPlot = new ExtendXYPlot(xYDataset, (ValueAxis)extendDateAxis, (ValueAxis)extendNumberAxis, null, this);
        ExtendStandardXYToolTipGenerator extendStandardXYToolTipGenerator = null;
        if (bl2) {
            extendStandardXYToolTipGenerator = ExtendStandardXYToolTipGenerator.getToolTipInstance();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        extendXYPlot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(2, (XYToolTipGenerator)extendStandardXYToolTipGenerator, (XYURLGenerator)standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)extendXYPlot, bl);
        jFreeChart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        return jFreeChart;
    }

    public ScrollBarProcess getScrollBarProcess() {
        return this.scrollProcess;
    }

    public void stopTotalTime() {
        this.scrollProcess.clearLabelTimer();
    }

    public void setAllowDisplayTimer(boolean bl) {
        this.scrollProcess.setLabelVisible(bl);
    }

    public void setSynchronizeLabelTime(boolean bl) {
        this.scrollProcess.setSynchronizeLabelTime(bl);
    }

    public boolean isSynchronizeLabelTime() {
        return this.scrollProcess.isSynchronizeLabelTime();
    }

    public void setTimeCycled(boolean bl) {
        if (this.chartPanel == null) {
            return;
        }
        ((ExtendDateAxis)this.chartPanel.getChart().getXYPlot().getDomainAxis()).setTimeCycled(bl);
    }

    public boolean isTimeCycled() {
        if (this.chartPanel == null) {
            return false;
        }
        return ((ExtendDateAxis)this.chartPanel.getChart().getXYPlot().getDomainAxis()).isTimeCycled();
    }

    public void scrollToRight() {
        this.scrollProcess.scrollToRight();
    }

    public void addDaemonData(Date date, boolean bl) {
        if (date == null) {
            logger.trace("Parameter 'taskTime' is null");
            return;
        }
        if (!this.isChartDataAdded()) {
            logger.trace("Chart Data is not added. Method will return.");
            return;
        }
        long l = date.getTime();
        Date date2 = this.getFirstCoordinate().getTaskTime();
        long l2 = date2.getTime();
        long l3 = Math.abs(l - l2) + this.getFirstTimeStarted();
        Date date3 = new Date(l3);
        Millisecond millisecond = new Millisecond(date3);
        this.daemonTask.addDaemonData((RegularTimePeriod)millisecond);
        if (bl) {
            this.daemonTask.fireTaskInfoChanged(2);
        }
        this.getScrollBarProcess().adjustTime(date3);
    }

    public void setTimePause() {
        this.scrollProcess.setPause();
    }

    public void setTimeResume() {
        this.scrollProcess.setResume();
    }

    public void setNumberAxisRange(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("Range's upper must be greater than lower");
        }
        XYPlot xYPlot = this.getChartPanel().getChart().getXYPlot();
        ExtendNumberAxis extendNumberAxis = (ExtendNumberAxis)xYPlot.getRangeAxis(0);
        extendNumberAxis.setRange(n, n2);
        ExtendNumberAxis extendNumberAxis2 = (ExtendNumberAxis)xYPlot.getRangeAxis(1);
        extendNumberAxis2.setRange(n, n2);
        this.chartPanel.getChart().setTitle(this.chartPanel.getChart().getTitle());
    }

    public void setYAxisRange(int n, int n2) {
        this.setNumberAxisRange(n, n2);
    }

    final class DaemonTask
    extends TaskInfo {
        private RegularTimePeriod lastDate;
        private static final double VALUE = Double.NaN;

        DaemonTask(String string) {
            super(string, "", Color.white, 0, 0, "");
            this.lastDate = null;
            super.setTaskLineIsShow(false);
        }

        final void addDaemonData(RegularTimePeriod regularTimePeriod) {
            if (this.getTimeSeries() == null) {
                return;
            }
            if (this.lastDate == null) {
                this.lastDate = regularTimePeriod;
                super.getTimeSeries().addOrUpdate(regularTimePeriod, Double.NaN);
                return;
            }
            if (regularTimePeriod.equals(this.lastDate)) {
                return;
            }
            super.getTimeSeries().addOrUpdate(regularTimePeriod, Double.NaN);
            this.lastDate = regularTimePeriod;
        }

        @Override
        public void addData(Number number, Date date) {
        }

        @Override
        public void addData(double d, Date date) {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean inPointerScope = false;
        private int originateX = -1;
        private int currentX = -1;
        private int startPosition = -1;
        private int endPosition = -1;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Point2D point2D = ChartGraphPanel.this.chartPanel.translateScreenToJava2D(point);
                ExtendDateAxis extendDateAxis = (ExtendDateAxis)ChartGraphPanel.this.chartPanel.getChart().getXYPlot().getDomainAxis();
                this.inPointerScope = extendDateAxis.isInPointerScope(point2D);
                if (this.inPointerScope) {
                    this.originateX = (int)point2D.getX();
                    this.startPosition = (int)extendDateAxis.getCurrPointX();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.inPointerScope) {
                ExtendDateAxis extendDateAxis = (ExtendDateAxis)ChartGraphPanel.this.chartPanel.getChart().getXYPlot().getDomainAxis();
                this.endPosition = (int)extendDateAxis.getCurrPointX();
                if (this.startPosition != this.endPosition) {
                    ChartGraphPanel.this.firePointerChanged();
                }
                this.inPointerScope = false;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.inPointerScope) {
                double d;
                double d2;
                this.inPointerScope = false;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Point2D point2D = ChartGraphPanel.this.chartPanel.translateScreenToJava2D(point);
                this.currentX = (int)point2D.getX();
                ExtendDateAxis extendDateAxis = (ExtendDateAxis)ChartGraphPanel.this.chartPanel.getChart().getXYPlot().getDomainAxis();
                if ((double)(this.currentX - this.originateX) >= extendDateAxis.getGapOffset()) {
                    d2 = extendDateAxis.getPercent();
                    extendDateAxis.setPointPostion(this.currentX, this.originateX);
                    ChartGraphPanel.this.chartPanel.getChart().setTitle(ChartGraphPanel.this.chartPanel.getChart().getTitle());
                    d = extendDateAxis.getPercent();
                    if (d2 != d) {
                        this.originateX = (int)extendDateAxis.getPositionOfPercent(d);
                    }
                }
                if ((double)(this.originateX - this.currentX) >= extendDateAxis.getGapOffset()) {
                    d2 = extendDateAxis.getPercent();
                    extendDateAxis.setPointPostion((int)((double)this.currentX + extendDateAxis.getGapOffset()), this.originateX);
                    ChartGraphPanel.this.chartPanel.getChart().setTitle(ChartGraphPanel.this.chartPanel.getChart().getTitle());
                    d = extendDateAxis.getPercent();
                    if (d2 != d) {
                        this.originateX = (int)extendDateAxis.getPositionOfPercent(d);
                    }
                }
                this.inPointerScope = true;
            }
        }
    }
}

