/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.bar;

import com.swimap.iview.templates.charts.bar.BarChartStyleInformation;
import com.swimap.iview.templates.charts.bar.BarChartStyleInformationManager;
import com.swimap.iview.templates.charts.bar.xml.BackgroundColor;
import com.swimap.iview.templates.charts.bar.xml.BarChart;
import com.swimap.iview.templates.charts.bar.xml.BarChartInformation;
import com.swimap.iview.templates.charts.bar.xml.PointLabels;
import com.swimap.iview.templates.charts.bar.xml.SeriesInformation;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.net.URL;

public class BarChartXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(BarChartXMLFileReader.class, "IVIEW");
    private boolean validity = false;
    private BarChartStyleInformation styleInformation = null;
    private BarChartStyleInformationManager styleInformationManager = null;

    public BarChartStyleInformation getBarChartStyleInformation(String string) throws Exception {
        if (this.readXMLFile(string)) {
            return this.styleInformation;
        }
        return null;
    }

    public boolean readXMLFile(String string) throws Exception {
        try {
            File file = CommonUtil.getAbsoluteFile(string);
            URL uRL = file.toURL();
            BarChart barChart = BarChart.unmarshal(uRL);
            this.validity = barChart.isValid();
            if (this.validity) {
                Object[] objectArray;
                String[] stringArray;
                BackgroundColor backgroundColor;
                BarChartInformation barChartInformation = barChart.getBarChartInformation();
                this.styleInformation = new BarChartStyleInformation();
                if (barChartInformation.getTitle() != null) {
                    this.styleInformation.setChartTitle(barChartInformation.getTitle().trim());
                }
                if (barChartInformation.getDepth() != null) {
                    this.styleInformation.setChartDepth(barChartInformation.getDepth());
                }
                if (barChartInformation.getElevation() != null) {
                    this.styleInformation.setChartElevation(barChartInformation.getElevation());
                }
                if (barChartInformation.getRotation() != null) {
                    this.styleInformation.setChartRotation(barChartInformation.getRotation());
                }
                if (barChartInformation.getWidth() != null && barChartInformation.getHeight() != null) {
                    this.styleInformation.setChartSize(barChartInformation.getWidth(), barChartInformation.getHeight());
                }
                this.styleInformation.setLegendFont(barChartInformation.getLegendFontName().trim(), barChartInformation.getLegendFontStyle(), barChartInformation.getLegendFontSize());
                if (barChartInformation.getLegendPosition() != null) {
                    this.styleInformation.setLegendPosition(barChartInformation.getLegendPosition().trim());
                }
                if (barChartInformation.getBarWidth() != null) {
                    this.styleInformation.setBarWidth(barChartInformation.getBarWidth());
                }
                if (barChartInformation.getClusterDistance() != null) {
                    this.styleInformation.setDistanceBetweenBars(barChartInformation.getClusterDistance());
                }
                if (barChartInformation.getXAxisLabel() != null) {
                    this.styleInformation.setXAxisLabel(barChartInformation.getXAxisLabel().trim());
                }
                if (barChartInformation.getXAxisScale() != null) {
                    this.styleInformation.setXAxisScale(barChartInformation.getXAxisScale());
                }
                if (barChartInformation.getYAxisLabel() != null) {
                    this.styleInformation.setYAxisLabel(barChartInformation.getYAxisLabel().trim());
                }
                if (barChartInformation.getYAxisScale() != null) {
                    this.styleInformation.setYAxisScale(barChartInformation.getYAxisScale());
                }
                boolean bl = true;
                PointLabels[] pointLabelsArray = barChartInformation.getPointLabels();
                int n = barChartInformation.getPointLabelsCount();
                String[] stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    bl = true;
                    if (pointLabelsArray[i].getName() == null) {
                        bl = false;
                        break;
                    }
                    stringArray2[i] = pointLabelsArray[i].getName();
                }
                if (bl) {
                    this.styleInformation.setPointLabel(stringArray2);
                }
                if ((backgroundColor = barChartInformation.getBackgroundColor()) != null && backgroundColor.getR() != null && backgroundColor.getG() != null && backgroundColor.getB() != null) {
                    stringArray = new String[]{backgroundColor.getR(), backgroundColor.getG(), backgroundColor.getB()};
                    this.styleInformation.setChartBackground(stringArray);
                }
                if ((stringArray = barChartInformation.getLegendBackgroundColor()) != null && stringArray.getR() != null && stringArray.getG() != null && stringArray.getB() != null) {
                    objectArray = new String[]{stringArray.getR(), stringArray.getG(), stringArray.getB()};
                    this.styleInformation.setLegendBackground((String[])objectArray);
                }
                objectArray = barChartInformation.getSeriesInformation();
                int n2 = barChartInformation.getSeriesInformationCount();
                String[][] stringArray3 = new String[n2][3];
                String[] stringArray4 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    bl = true;
                    stringArray3[i][0] = objectArray[i].getR();
                    stringArray3[i][1] = ((SeriesInformation)objectArray[i]).getG();
                    stringArray3[i][2] = ((SeriesInformation)objectArray[i]).getB();
                    if (((SeriesInformation)objectArray[i]).getLabel() != null) {
                        stringArray4[i] = ((SeriesInformation)objectArray[i]).getLabel();
                        continue;
                    }
                    bl = false;
                }
                this.styleInformation.setSeriesColors(stringArray3);
                if (bl) {
                    this.styleInformation.setSeriesLabel(stringArray4);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.validity = false;
            logger.error("Error while reading XML file : " + numberFormatException);
            throw numberFormatException;
        }
        catch (Exception exception) {
            this.validity = false;
            logger.error("Error while reading XML file : " + exception);
            throw exception;
        }
        return this.validity;
    }

    public boolean isInformationValid() {
        return this.validity;
    }

    public boolean saveInformation(String string) throws Exception {
        this.styleInformationManager = new BarChartStyleInformationManager(string);
        boolean bl = this.styleInformationManager != null & this.styleInformation != null;
        if (bl) {
            try {
                this.styleInformationManager.saveInformation(this.styleInformation);
            }
            catch (Exception exception) {
                bl = false;
                logger.error("Error while saving the information" + exception);
                throw exception;
            }
        }
        return bl;
    }
}

