/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.bar;

import com.swimap.iview.templates.charts.bar.BarChartStyleInformation;
import com.swimap.iview.templates.charts.bar.IBarChartStyleInterface;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class BarChartTemplate
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(BarChartTemplate.class, "IVIEW");
    private static final Color DEFAULT_CHART_HEADER_BACKGROUND = Color.white;
    private static final Color DEFAULT_CHART_HEADER_FOREGROUND = Color.blue;
    private static final Font DEFAULT_CHART_HEADER_FONT = new Font("Courier", 3, 30);
    private BarChartStyleInformation styleInformation = null;
    private Vector chartDataVector = null;
    private JFreeChart chart = this.createChart();
    private ChartPanel chartPanel = new ChartPanel(this.chart);

    public BarChartTemplate() {
        this.add((Component)this.chartPanel);
    }

    public BarChartTemplate(IBarChartStyleInterface iBarChartStyleInterface) throws ClassNotFoundException, IOException, SecurityException {
        this();
        try {
            this.styleInformation = iBarChartStyleInterface.loadInformation();
            if (null == this.styleInformation) {
                String string = "styleInformation can not be null.";
                logger.error(string);
                throw new IllegalArgumentException(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error(classNotFoundException.toString());
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.error(iOException.toString());
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (SecurityException securityException) {
            logger.error(securityException.toString());
            throw securityException;
        }
        catch (Exception exception) {
            logger.error(exception.toString());
        }
        this.setStyleInformationToTemplate();
    }

    public BarChartStyleInformation getInformation() {
        return this.styleInformation;
    }

    public void setInformation(BarChartStyleInformation barChartStyleInformation) {
        if (null == barChartStyleInformation) {
            String string = "data can not be null.";
            logger.error(string);
            throw new IllegalArgumentException(string);
        }
        this.styleInformation = barChartStyleInformation;
        this.setStyleInformationToTemplate();
    }

    public void setChartData(Vector vector) {
        Object object;
        this.chartDataVector = vector;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        String[] stringArray = this.styleInformation.getSeriesLabel();
        String[] stringArray2 = this.styleInformation.getPointLabel();
        if (null != stringArray && null != vector && null != stringArray2) {
            object = new Vector();
            for (int i = 0; i < stringArray2.length; ++i) {
                object = (Vector)vector.get(i);
                for (int j = 0; j < stringArray.length; ++j) {
                    defaultCategoryDataset.addValue((Number)((Double)((Vector)object).get(j)), (Comparable)((Object)stringArray[j]), (Comparable)((Object)stringArray2[i]));
                }
            }
        }
        object = this.chart.getCategoryPlot();
        object.setDataset((CategoryDataset)defaultCategoryDataset);
        BarRenderer3D barRenderer3D = (BarRenderer3D)object.getRenderer();
        Color[] colorArray = this.styleInformation.getSeriesColors();
        if (null != colorArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                barRenderer3D.setSeriesPaint(i, (Paint)colorArray[i]);
            }
        }
    }

    public Vector getChartData() {
        return this.chartDataVector;
    }

    private void setStyleInformationToTemplate() {
        this.setChartProperties();
        this.setChartHeaderProperties();
        this.setChartAreaProperties();
        this.setXYAxisProperties();
        this.setLegendProperties();
        this.setBarProperties();
    }

    private void setLegendProperties() {
        LegendTitle legendTitle = this.chart.getLegend();
        legendTitle.setBackgroundPaint((Paint)this.styleInformation.getLegendBackground());
        legendTitle.setItemFont(this.styleInformation.getLegendFont());
        String string = this.styleInformation.getLegendPosition();
        RectangleEdge rectangleEdge = null;
        rectangleEdge = "SOUTH".equals(string) ? RectangleEdge.BOTTOM : ("WEST".equals(string) ? RectangleEdge.LEFT : ("NORTH".equals(string) ? RectangleEdge.TOP : RectangleEdge.RIGHT));
        legendTitle.setPosition(rectangleEdge);
        legendTitle.setBorder(0.0, 0.0, 0.0, 0.0);
    }

    private void setBarProperties() {
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D.setItemMargin((double)this.styleInformation.getDistanceBetweenBars() / 100.0);
    }

    private void setXYAxisProperties() {
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setLabel(this.styleInformation.getXAxisLabel());
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setLabel(this.styleInformation.getYAxisLabel());
        valueAxis.setLabelAngle(1.5707963267948966);
    }

    private void setChartProperties() {
        this.chart.setBackgroundPaint((Paint)this.styleInformation.getChartBackground());
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        categoryPlot.setBackgroundAlpha(1.0f);
        categoryPlot.setForegroundAlpha(1.0f);
    }

    private void setChartHeaderProperties() {
        TextTitle textTitle = this.chart.getTitle();
        textTitle.setText(this.styleInformation.getChartTitle());
        textTitle.setBackgroundPaint((Paint)DEFAULT_CHART_HEADER_BACKGROUND);
        textTitle.setFont(DEFAULT_CHART_HEADER_FONT);
        textTitle.setPaint((Paint)DEFAULT_CHART_HEADER_FOREGROUND);
    }

    private void setChartAreaProperties() {
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        categoryPlot.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setRangeGridlinesVisible(false);
        this.chartPanel.setPreferredSize(this.styleInformation.getChartSize());
        this.chartPanel.setOpaque(true);
        this.chart.setBorderVisible(false);
        this.chartPanel.setRangeZoomable(false);
    }

    private JFreeChart createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)"Bar Chart", (String)"Category", (String)"Value", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        return jFreeChart;
    }
}

