/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts.bar;

import com.swimap.iview.templates.charts.ChartStyleInformation;
import com.swimap.iview.util.log.IviewLogger;
import java.io.Serializable;

public class BarChartStyleInformation
extends ChartStyleInformation
implements Serializable {
    public static final int BAR_CLUSTER_OVERLAP_MIN = -100;
    public static final int BAR_CLUSTER_OVERLAP_MAX = 100;
    public static final int BAR_CLUSTER_WIDTH_MAX = 100;
    private static IviewLogger logger = IviewLogger.getLogger(BarChartStyleInformation.class, "IVIEW");
    private static final int MINIMUM_BAR_WIDTH = 0;
    private double xAxisScale = 0.0;
    private double yAxisScale = 0.0;
    private int distanceBetweenBars = 0;
    private int barWidth = 0;
    private String xAxisLabel = null;
    private String yAxisLabel = null;

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
    }

    public double getXAxisScale() {
        return this.xAxisScale;
    }

    public void setXAxisScale(String string) {
        try {
            this.xAxisScale = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting X-Axis scale : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public double getYAxisScale() {
        return this.yAxisScale;
    }

    public void setYAxisScale(String string) {
        try {
            this.yAxisScale = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting Y-Axis scale : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public int getDistanceBetweenBars() {
        return this.distanceBetweenBars;
    }

    public void setDistanceBetweenBars(String string) {
        try {
            this.distanceBetweenBars = Integer.parseInt(string);
            if (this.distanceBetweenBars < -100) {
                this.distanceBetweenBars = -100;
            } else if (this.distanceBetweenBars > 100) {
                this.distanceBetweenBars = 100;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting the distance between the bar : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(String string) {
        try {
            this.barWidth = Integer.parseInt(string);
            if (this.barWidth < 0) {
                this.barWidth = 0;
            } else if (this.barWidth > 100) {
                this.barWidth = 100;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting the bar width : " + numberFormatException);
            throw numberFormatException;
        }
    }
}

