/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.charts;

import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;

public abstract class ChartStyleInformation
implements Serializable {
    private static IviewLogger logger = IviewLogger.getLogger(ChartStyleInformation.class, "IVIEW");
    private String chartTitle = null;
    private Dimension chartSize = null;
    private Color chartBackgroundColor = null;
    private Font legendFont = null;
    private Color legendBackgroundColor = null;
    private String legendPosition = null;
    private String[] seriesLabels = null;
    private String[] pointLabels = null;
    private Color[] seriesColors = null;
    private int chartDepth = 0;
    private int chartElevation = 0;
    private int chartRotation = 0;

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void setChartTitle(String string) {
        this.chartTitle = string;
    }

    public Color getChartBackground() {
        return this.chartBackgroundColor;
    }

    public Dimension getChartSize() {
        return this.chartSize;
    }

    public void setChartSize(String string, String string2) {
        try {
            this.chartSize = new Dimension(Integer.parseInt(string), Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart size : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public void setChartBackground(String[] stringArray) {
        try {
            this.chartBackgroundColor = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart Background color : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(String string, String string2, String string3) {
        int n = 0;
        n = "BOLD".equalsIgnoreCase(string2) ? 1 : ("ITALIC".equalsIgnoreCase(string2) ? 2 : ("BOLD+ITALIC".equalsIgnoreCase(string2) ? 3 : 0));
        try {
            this.legendFont = new Font(string, n, Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart legend font : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public Color getLegendBackground() {
        return this.legendBackgroundColor;
    }

    public void setLegendBackground(String[] stringArray) {
        try {
            this.legendBackgroundColor = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart legend background : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public String getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(String string) {
        this.legendPosition = string;
    }

    public String[] getSeriesLabel() {
        return this.seriesLabels;
    }

    public void setSeriesLabel(String[] stringArray) {
        this.seriesLabels = stringArray;
    }

    public String[] getPointLabel() {
        return this.pointLabels;
    }

    public void setPointLabel(String[] stringArray) {
        this.pointLabels = stringArray;
    }

    public Color[] getSeriesColors() {
        return this.seriesColors;
    }

    public void setSeriesColors(String[][] stringArray) {
        try {
            this.seriesColors = new Color[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.seriesColors[i] = new Color(Integer.parseInt(stringArray[i][0]), Integer.parseInt(stringArray[i][1]), Integer.parseInt(stringArray[i][2]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting series colors : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public int getChartDepth() {
        return this.chartDepth;
    }

    public void setChartDepth(String string) {
        try {
            this.chartDepth = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart depth : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public int getChartElevation() {
        return this.chartElevation;
    }

    public void setChartElevation(String string) {
        try {
            this.chartElevation = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart elevation : " + numberFormatException);
            throw numberFormatException;
        }
    }

    public int getChartRotation() {
        return this.chartRotation;
    }

    public void setChartRotation(String string) {
        try {
            this.chartRotation = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error while setting chart rotation : " + numberFormatException);
            throw numberFormatException;
        }
    }
}

