/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.bubble;

import com.swimap.imap12.util.CapsLockTipBubble;
import com.swimap.iview.templates.bubble.BubbleCloseIcon;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BubbleComponent
extends JComponent
implements SwingConstants {
    private FontMetrics stringMeasure = null;
    private static final int MAX_WIDTH = 200;
    protected final int x = 0;
    protected final int y = 0;
    protected final int dogear = 5;
    private static final int DEFAULT_WIDTH = 90;
    private static final int DEFAULT_HEIGHT = 36;
    protected static final int ARROW_HEIGHT = 19;
    protected static final int INVERT_ANGLE = 180;
    protected static final int TIP_DIP = 8;
    protected int width = 90;
    protected int height = 36;
    protected final int npoints = 11;
    protected int[] xpoints = new int[11];
    protected int[] ypoints = new int[11];
    protected Shape shape = null;
    protected JTextArea textArea = new JTextArea();
    protected Insets insets = new Insets(10, 20, 30, 25);
    private String text = " ";
    private Font font = UIManager.getFont("Label.font");
    protected BubbleCloseIcon label = null;
    protected Component invoker = null;
    private transient HierarchyBoundsListener boundsUpdater = new BubbleBoundUpdater();
    protected int position = 1;

    public BubbleComponent() {
        this.setLayout(null);
        this.setDoubleBuffered(true);
        this.textArea.setLocation(this.insets.left, this.insets.top);
        this.textArea.setFont(this.font);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setOpaque(false);
        this.textArea.setFocusable(false);
        this.label = new BubbleCloseIcon();
        this.label.addIconCloseListener(new IconCloseListener(){

            @Override
            public void close() {
                BubbleComponent.this.hideBubble();
            }
        });
        this.label.setIcon(this.label);
        this.add(this.label);
        this.add(this.textArea);
        this.setOpaque(false);
        this.enableEvents(16L);
        this.resize();
        this.reShape();
    }

    public void setBubbleText(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Only String is allowed");
        }
        this.text = string;
        this.resize();
        this.reShape();
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    private void resize() {
        int n;
        String string = ScreenToolKit.getLineWrapString(this.text, 200, this.font);
        if (string.length() == 0) {
            this.width = 0;
            this.height = 0;
        }
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        this.setFont(this.font);
        n = 0;
        String string3 = null;
        string3 = String.valueOf('\n');
        int n3 = 0;
        while ((n3 = string.indexOf(string3, n3)) >= 0) {
            ++n;
            ++n3;
        }
        if (string.endsWith(string3)) {
            --n;
        }
        int n4 = this.stringMeasure.getHeight() * ++n;
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (n5 >= this.stringMeasure.stringWidth(stringArray[i])) continue;
            n5 = this.stringMeasure.stringWidth(stringArray[i]);
        }
        int n6 = n5 = n5 < 90 ? 90 : n5;
        n4 = this instanceof CapsLockTipBubble ? (n4 < this.stringMeasure.getHeight() ? 36 : n4) : (n4 < 36 ? 36 : n4);
        this.textArea.setSize(new Dimension(n5 + 2, n4 + 2));
        this.textArea.setText(this.text);
        this.label.setBounds(this.getWidth() - 18, 6, this.label.getIconWidth() + 6, this.label.getIconHeight() + 8);
        this.setPreferredSize(new Dimension(n5 + this.insets.left + this.insets.right, n4 + this.insets.top + this.insets.bottom));
    }

    @Override
    public void setFont(Font font) {
        if (null != font) {
            super.setFont(font);
            BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            this.stringMeasure = graphics.getFontMetrics(font);
        }
    }

    protected void reShape() {
        this.width = this.getPreferredSize().width - 1;
        this.height = this.getPreferredSize().height - 1;
        this.xpoints[0] = 5;
        this.xpoints[1] = 0;
        this.xpoints[2] = 0;
        this.xpoints[3] = 5;
        this.xpoints[4] = this.width - 33;
        this.xpoints[5] = this.width - 15;
        this.xpoints[6] = this.width - 15;
        this.xpoints[7] = this.width - 1 - 5;
        this.xpoints[8] = this.width - 1;
        this.xpoints[9] = this.width - 1;
        this.xpoints[10] = this.width - 1 - 5;
        this.ypoints[0] = 0;
        this.ypoints[1] = 5;
        this.ypoints[2] = this.height - 19 - 5;
        this.ypoints[3] = this.height - 19;
        this.ypoints[4] = this.height - 19;
        this.ypoints[5] = this.height - 1;
        this.ypoints[6] = this.height - 19;
        this.ypoints[7] = this.height - 19;
        this.ypoints[8] = this.height - 19 - 5;
        this.ypoints[9] = 5;
        this.ypoints[10] = 0;
        this.shape = new Polygon(this.xpoints, this.ypoints, 11);
        if (this.position == 5) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.width / 2, this.height / 2);
            affineTransform.rotate(Math.toRadians(180.0));
            affineTransform.translate(-this.width / 2, -this.height / 2);
            this.shape = affineTransform.createTransformedShape(this.shape);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.updateBounds();
        graphics2D.setColor(UIManager.getColor("text"));
        graphics2D.fill(this.shape);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.shape);
        super.paint(graphics2D);
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.shape.contains(n, n2);
    }

    private void setInvoker(Component component) {
        JLayeredPane jLayeredPane = this.updateBounds();
        if (jLayeredPane != null) {
            this.checkAndAddHierarchyBoundsListener(jLayeredPane);
            this.resize();
            this.reShape();
            jLayeredPane.add(this, JLayeredPane.POPUP_LAYER, 0);
            this.setVisible(false);
        }
    }

    protected JLayeredPane updateBounds() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this.invoker);
        if (jRootPane == null) {
            return null;
        }
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Point point = this.invoker.getLocation();
        point = SwingUtilities.convertPoint(this.invoker.getParent(), point, jLayeredPane);
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        if (point.y - n2 + 8 < 0) {
            this.position = 5;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n / 2, n2 / 2);
            affineTransform.rotate(Math.toRadians(180.0));
            affineTransform.translate(-n / 2, -n2 / 2);
            this.shape = affineTransform.createTransformedShape(this.shape);
        } else {
            this.position = 1;
        }
        if (this.position == 1) {
            this.textArea.setLocation(this.insets.left, this.insets.top);
            this.label.setBounds(this.getWidth() - 18, 6, this.label.getIconWidth() + 6, this.label.getIconHeight() + 8);
            this.setBounds(point.x - n + this.invoker.getWidth() / 2 + 15, point.y - n2 + 8, n, n2);
        } else if (this.position == 5) {
            this.textArea.setLocation(this.insets.left, this.insets.top + 19);
            this.label.setBounds(this.getWidth() - 18, this.insets.top + 12, this.label.getIconWidth() + 6, this.label.getIconHeight() + 8);
            this.setBounds(point.x + this.invoker.getWidth() / 2 - 15, point.y + this.invoker.getHeight() - 8, n, n2);
        }
        this.reShape();
        return jLayeredPane;
    }

    private void hideBubble() {
        if (null != this.invoker) {
            this.invoker.removeHierarchyBoundsListener(this.boundsUpdater);
        }
        this.setVisible(false);
    }

    private void checkAndAddHierarchyBoundsListener(Component component) {
        boolean bl = true;
        EventListener[] eventListenerArray = component.getListeners(HierarchyBoundsListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            if (eventListenerArray[i] != this.boundsUpdater) continue;
            bl = false;
            break;
        }
        if (bl) {
            component.addHierarchyBoundsListener(this.boundsUpdater);
        }
    }

    public void showBubble(Component component) {
        if (null == component) {
            throw new IllegalArgumentException("Only Component and its child is allowed");
        }
        this.invoker = component;
        this.checkAndAddHierarchyBoundsListener(component);
        this.setInvoker(component);
        this.setVisible(true);
        this.repaint();
    }

    public boolean isBubbleComponentShowing() {
        return this.isShowing();
    }

    private class BubbleBoundUpdater
    implements HierarchyBoundsListener {
        private BubbleBoundUpdater() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            BubbleComponent.this.updateBounds();
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            BubbleComponent.this.updateBounds();
        }
    }
}

