/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.bubble;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class BubbleCloseIcon
extends JLabel
implements Icon {
    private static IviewLogger logger = IviewLogger.getLogger(BubbleCloseIcon.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private final Color COLOR_MOUSE_HOVER = new Color(255, 153, 0);
    private final Color COLOR_MOUSE_PRESSED = new Color(153, 102, 0);
    private final Color COLOR_MOUSE_NORMAL = new Color(94, 94, 94);
    private static final String DEFAULT_TOOL_TIP = res == null ? "Close" : res.getString("CloseIcon_ToolTip");
    private static final int ICON_HEIGHT = 8;
    private static final int ICON_WIDTH = 8;
    private static final String ICON_STATUS_HOVER = "hover";
    private static final String ICON_STATUS_PRESSED = "pressed";
    private static final String ICON_STATUS_NORMAL = "normal";
    private boolean pressed = false;
    private EventListenerList listeners = new EventListenerList();
    private String iconStatus = "normal";
    private boolean enable = true;

    public BubbleCloseIcon() {
        this.setName("BubbleCloseIcon");
        this.setToolTipText(DEFAULT_TOOL_TIP);
        this.addMouseListener(new BubbleCloseIconMouseListener());
        this.addMouseMotionListener(new BubbleCloseIconMouseMotionListener());
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (graphics == null) {
            throw new IllegalArgumentException("Graphics is null.");
        }
        if (this.enable) {
            if (ICON_STATUS_NORMAL.equals(this.iconStatus)) {
                graphics.setColor(this.COLOR_MOUSE_NORMAL);
            }
            if (ICON_STATUS_HOVER.equals(this.iconStatus)) {
                graphics.setColor(this.COLOR_MOUSE_HOVER);
            }
            if (ICON_STATUS_PRESSED.equals(this.iconStatus)) {
                graphics.setColor(this.COLOR_MOUSE_PRESSED);
            }
        }
        graphics.drawLine(n, n2, n + 8, n2 + 8);
        graphics.drawLine(n, n2 + 8, n + 8, n2);
        graphics.drawLine(n + 1, n2, n + 8, n2 + 8 - 1);
        graphics.drawLine(n, n2 + 8 - 1, n - 1 + 8, n2);
        graphics.drawLine(n, n2 + 1, n + 8 - 1, n2 + 8);
        graphics.drawLine(n + 1, n2 + 8, n + 8, n2 + 1);
    }

    @Override
    public int getIconHeight() {
        return 8;
    }

    @Override
    public int getIconWidth() {
        return 8;
    }

    private synchronized void setIconStatus(String string) {
        if (!string.equals(this.iconStatus)) {
            this.iconStatus = string;
            this.repaint();
        }
    }

    private void processCloseEvent() {
        EventListener[] eventListenerArray = this.listeners.getListeners(IconCloseListener.class);
        IconCloseListener iconCloseListener = null;
        try {
            for (int i = 0; i < eventListenerArray.length; ++i) {
                iconCloseListener = (IconCloseListener)eventListenerArray[i];
                iconCloseListener.close();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void addIconCloseListener(IconCloseListener iconCloseListener) {
        this.listeners.add(IconCloseListener.class, iconCloseListener);
    }

    public void removeIconCloseListener(IconCloseListener iconCloseListener) {
        this.listeners.remove(IconCloseListener.class, iconCloseListener);
    }

    private class BubbleCloseIconMouseMotionListener
    extends MouseMotionAdapter {
        private BubbleCloseIconMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BubbleCloseIcon.this.setIconStatus(BubbleCloseIcon.ICON_STATUS_HOVER);
        }
    }

    private class BubbleCloseIconMouseListener
    extends MouseAdapter {
        private BubbleCloseIconMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (BubbleCloseIcon.this.pressed) {
                BubbleCloseIcon.this.setIconStatus(BubbleCloseIcon.ICON_STATUS_PRESSED);
            } else if (mouseEvent.getModifiers() == 0) {
                BubbleCloseIcon.this.setIconStatus(BubbleCloseIcon.ICON_STATUS_HOVER);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BubbleCloseIcon.this.setIconStatus(BubbleCloseIcon.ICON_STATUS_NORMAL);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                BubbleCloseIcon.this.pressed = true;
                BubbleCloseIcon.this.setIconStatus(BubbleCloseIcon.ICON_STATUS_PRESSED);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (BubbleCloseIcon.this.pressed) {
                    BubbleCloseIcon.this.setIconStatus(BubbleCloseIcon.ICON_STATUS_NORMAL);
                }
                BubbleCloseIcon.this.processCloseEvent();
                BubbleCloseIcon.this.pressed = false;
            }
        }
    }
}

