/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.beans.threestate;

import com.swimap.iview.templates.beans.threestate.DefaultPolicy;
import com.swimap.iview.templates.beans.threestate.ItemObject;
import com.swimap.iview.templates.beans.threestate.StateChangePolicy;
import com.swimap.iview.templates.beans.threestate.ThreeStateListModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ThreeStateList
extends JList {
    private transient MouseListener mouseListener = new MouseHandler();
    private transient StateChangePolicy policy = new DefaultPolicy();

    public ThreeStateList() {
        this(new Object[0]);
    }

    public ThreeStateList(Object[] objectArray) {
        super(new ThreeStateListModel(objectArray));
        this.setCellRenderer(new StateListCellRenderer());
        this.addMouseListener(this.mouseListener);
    }

    public StateChangePolicy getStateChangePolicy() {
        return this.policy;
    }

    public void setStateChangePolicy(StateChangePolicy stateChangePolicy) {
        this.policy = stateChangePolicy;
    }

    public void clear() {
        this.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
    }

    public void setListData(Object[] objectArray) {
        this.setModel((ListModel)new ThreeStateListModel(objectArray));
    }

    public void setListData(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.toArray(objectArray);
        this.setModel((ListModel)new ThreeStateListModel(objectArray));
    }

    public void setModel(ListModel listModel) {
        if (!(listModel instanceof ThreeStateListModel)) {
            throw new IllegalArgumentException("The model must be instance of ThreeStateModel");
        }
        super.setModel(listModel);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            if (null == this.mouseListener) {
                this.mouseListener = new MouseHandler();
            }
            this.addMouseListener(this.mouseListener);
        } else {
            this.clear();
        }
    }

    private static class StateListCellRenderer
    extends DefaultListCellRenderer {
        private StateListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ItemObject itemObject = (ItemObject)object;
            this.setIcon(itemObject.getState().getIcon());
            this.setText(itemObject.toString());
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            JList jList = (JList)mouseEvent.getSource();
            ItemObject itemObject = (ItemObject)jList.getModel().getElementAt(jList.locationToIndex(mouseEvent.getPoint()));
            if (itemObject == null) {
                return;
            }
            itemObject.setState(ThreeStateList.this.policy.next(itemObject.getState()));
            jList.repaint();
        }
    }
}

