/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.beans.threestate;

import com.swimap.iview.templates.beans.threestate.DefaultPolicy;
import com.swimap.iview.templates.beans.threestate.ItemObject;
import com.swimap.iview.templates.beans.threestate.ItemState;
import com.swimap.iview.templates.beans.threestate.StateChangePolicy;
import com.swimap.iview.templates.beans.threestate.StateListCellRenderer;
import com.swimap.iview.templates.beans.threestate.ThreeStateList;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class ThreeStateComboBox
extends JComboBox {
    private ThreeStateList render = null;
    private transient KeyListener keyListener = new KeyHandler();
    private static StateChangePolicy policy = new DefaultPolicy();
    private SelectionListener selectionListener = new SelectionListener();
    private transient BasicComboBoxEditor comboeditor = new BasicComboBoxEditor(){

        @Override
        public Component getEditorComponent() {
            this.editor.setEditable(false);
            this.editor.removeKeyListener(ThreeStateComboBox.this.keyListener);
            this.editor.addKeyListener(ThreeStateComboBox.this.keyListener);
            return this.editor;
        }

        @Override
        public Object getItem() {
            return "";
        }
    };
    private transient BasicComboBoxUI myui = new BasicComboBoxUI(){

        @Override
        protected ComboPopup createPopup() {
            MyPopup myPopup = new MyPopup(ThreeStateComboBox.this);
            myPopup.setName("ThreeStateComboBox_pop");
            myPopup.getAccessibleContext().setAccessibleParent(ThreeStateComboBox.this);
            ThreeStateComboBox.this.render = (ThreeStateList)myPopup.getList();
            if (ThreeStateComboBox.this.render != null) {
                ThreeStateComboBox.this.render.getSelectionModel().removeListSelectionListener(ThreeStateComboBox.this.selectionListener);
                ThreeStateComboBox.this.render.getSelectionModel().addListSelectionListener(ThreeStateComboBox.this.selectionListener);
            }
            return myPopup;
        }
    };

    public ThreeStateComboBox(Object[] objectArray) {
        super(objectArray);
        this.setRenderer(new StateListCellRenderer());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setEditable(true);
        this.setEditor(this.comboeditor);
        ((JTextField)this.comboeditor.getEditorComponent()).setText("");
        this.setUI(this.myui);
        this.setName("ThreeStateComboBox");
    }

    public int getListCount() {
        return this.render.getModel().getSize();
    }

    public ItemState getStateAt(int n) {
        return ((ItemObject)this.render.getModel().getElementAt(n)).getState();
    }

    public Object getValueAt(int n) {
        return ((ItemObject)this.render.getModel().getElementAt(n)).getElement();
    }

    public ItemObject getItemObjectAt(int n) {
        return (ItemObject)this.render.getModel().getElementAt(n);
    }

    public void setThreeComboBoxState(int n, ItemState itemState) {
        Object e = this.render.getModel().getElementAt(n);
        if (e != null) {
            ((ItemObject)e).setState(itemState);
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 32) {
                return;
            }
            int n = ThreeStateComboBox.this.render.getSelectedIndex();
            if (n >= 0) {
                ItemState itemState = ThreeStateComboBox.this.getStateAt(n);
                ThreeStateComboBox.this.setThreeComboBoxState(n, policy.next(itemState));
                ThreeStateComboBox.this.render.repaint();
            }
        }
    }

    private final class MyPopup
    extends BasicComboPopup {
        public MyPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        protected void installListListeners() {
            this.list.addListSelectionListener(this.listSelectionListener);
        }

        @Override
        protected JScrollPane createScroller() {
            return new JScrollPane(this.list, 20, 30);
        }

        protected JList createList() {
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            Object[] objectArray = new Object[comboBoxModel.getSize()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = comboBoxModel.getElementAt(i);
            }
            ThreeStateList threeStateList = new ThreeStateList(objectArray);
            return threeStateList;
        }
    }

    private final class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ThreeStateComboBox.this.setSelectedIndex(ThreeStateComboBox.this.render.getSelectedIndex());
        }
    }
}

