/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.beans.threestate;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.beans.threestate.DefaultPolicy;
import com.swimap.iview.templates.beans.threestate.ItemObject;
import com.swimap.iview.templates.beans.threestate.ItemState;
import com.swimap.iview.templates.beans.threestate.StateChangePolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ThreeStateCombo
extends JPanel {
    public static final Direction LEFT_TO_RIGHT = new Direction();
    public static final Direction UP_TO_DOWN = new Direction();
    private static final int HEIGHT = 22;
    private static final String ITEM_PROPERTY = "Item";
    private JTextField textField = new JTextField(15);
    private JLabel downLabel = new JLabel(new ImageIcon(ThreeStateCombo.class.getResource("down.gif")));
    private PopupPanel popupPanel = null;
    private JPopupMenu popupMenu = new JPopupMenu();
    private transient MouseListener popupMouseListener = new PopupMouseHandler();
    private transient MouseListener stateMouseListener = new StateMouseHandler();
    private FunctionItemHandler functionItemHandler0 = new FunctionItemHandler(0);
    private FunctionItemHandler functionItemHandler1 = new FunctionItemHandler(1);
    private FunctionItemHandler functionItemHandler2 = new FunctionItemHandler(2);
    private transient StateChangePolicy policy = new DefaultPolicy();
    private boolean isShowFunctionItem = false;
    private int selectedCount = 0;
    private int unselectedCount = 0;
    private int originalCount = 0;
    private ItemObject itemObjectTemp = null;
    static ResourceBundle res1 = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/beans/Res");
    private final int SELECT_ITEM = 0;
    private final int ORIGINAL_ITEM = 1;
    private final int UNSELECT_ITEM = 2;

    public ThreeStateCombo(Object[] objectArray, int n, Direction direction) {
        this(objectArray, n, direction, false);
    }

    public ThreeStateCombo(Object[] objectArray, int n, Direction direction, boolean bl) {
        this.setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.add(this.textField);
        box.add(this.downLabel);
        box.add(Box.createHorizontalStrut(1));
        this.add((Component)box, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.textField.setEditable(false);
        ToolTipManager.sharedInstance().registerComponent(this.textField);
        this.isShowFunctionItem = bl;
        this.originalCount = objectArray.length;
        this.popupPanel = new PopupPanel(objectArray, n, direction, bl);
        this.popupPanel.setName("ThreeStateCombo_popupPanel");
        this.popupMenu.add(this.popupPanel);
        this.popupMenu.setName("ThreeStateCombo_popupMenu");
        this.textField.addMouseListener(this.popupMouseListener);
        this.downLabel.addMouseListener(this.popupMouseListener);
        this.setName("ThreeStateCombo");
        for (int i = 0; i < this.popupPanel.itemLabels.length; ++i) {
            if (bl && i < 3) {
                if (i == 0) {
                    this.popupPanel.itemLabels[i].addMouseListener(this.functionItemHandler0);
                    continue;
                }
                if (i == 1) {
                    this.popupPanel.itemLabels[i].addMouseListener(this.functionItemHandler1);
                    continue;
                }
                if (i != 2) continue;
                this.popupPanel.itemLabels[i].addMouseListener(this.functionItemHandler2);
                continue;
            }
            this.popupPanel.itemLabels[i].addMouseListener(this.stateMouseListener);
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.textField.setName(string + "textField");
        this.downLabel.setName(string + "downLabel");
    }

    public ItemObject[] getAllItems() {
        if (this.isShowFunctionItem) {
            ItemObject[] itemObjectArray = new ItemObject[this.popupPanel.items.length - 3];
            System.arraycopy(this.popupPanel.items, 3, itemObjectArray, 0, this.popupPanel.items.length - 3);
            return itemObjectArray;
        }
        return this.popupPanel.items;
    }

    public void setThreeComboState(int n, ItemState itemState) {
        if (this.isShowFunctionItem) {
            n += 3;
        }
        JLabel[] jLabelArray = this.popupPanel.itemLabels;
        ItemObject itemObject = (ItemObject)jLabelArray[n].getClientProperty(ITEM_PROPERTY);
        itemObject.setState(itemState);
        jLabelArray[n].setIcon(itemState.getIcon());
        jLabelArray[n].repaint();
        this.updateTextField();
    }

    public StateChangePolicy getStateChangePolicy() {
        return this.policy;
    }

    public void setStateChangePolicy(StateChangePolicy stateChangePolicy) {
        this.policy = stateChangePolicy;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 22;
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = 22;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.height = 22;
        return dimension;
    }

    public void clear() {
        this.textField.removeMouseListener(this.popupMouseListener);
        this.downLabel.removeMouseListener(this.popupMouseListener);
        this.popupMouseListener = null;
        for (int i = 0; i < this.popupPanel.itemLabels.length; ++i) {
            this.popupPanel.itemLabels[i].removeMouseListener(this.stateMouseListener);
        }
        if (this.isShowFunctionItem) {
            this.popupPanel.itemLabels[0].removeMouseListener(this.functionItemHandler0);
            this.popupPanel.itemLabels[1].removeMouseListener(this.functionItemHandler1);
            this.popupPanel.itemLabels[2].removeMouseListener(this.functionItemHandler2);
        }
        this.stateMouseListener = null;
        ToolTipManager.sharedInstance().unregisterComponent(this.textField);
    }

    private void updateAll(int n) {
        switch (n) {
            case 0: {
                int n2;
                this.selectedCount = this.popupPanel.itemLabels.length - 3;
                this.originalCount = 0;
                this.unselectedCount = 0;
                for (n2 = 1; n2 < 3; ++n2) {
                    this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[n2].getClientProperty(ITEM_PROPERTY);
                    this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                    this.popupPanel.itemLabels[n2].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                    this.popupPanel.itemLabels[n2].repaint();
                }
                for (n2 = 3; n2 < this.popupPanel.itemLabels.length; ++n2) {
                    this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[n2].getClientProperty(ITEM_PROPERTY);
                    this.itemObjectTemp.setState(ItemState.SELECTED_STATE);
                    this.popupPanel.itemLabels[n2].setIcon(ItemState.SELECTED_STATE.getIcon());
                    this.popupPanel.itemLabels[n2].repaint();
                }
                this.updateTextField();
                break;
            }
            case 1: {
                this.selectedCount = 0;
                this.originalCount = this.popupPanel.itemLabels.length - 3;
                this.unselectedCount = 0;
                this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[0].getClientProperty(ITEM_PROPERTY);
                this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                this.popupPanel.itemLabels[0].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                this.popupPanel.itemLabels[0].repaint();
                this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[2].getClientProperty(ITEM_PROPERTY);
                this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                this.popupPanel.itemLabels[2].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                this.popupPanel.itemLabels[2].repaint();
                for (int i = 3; i < this.popupPanel.itemLabels.length; ++i) {
                    this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[i].getClientProperty(ITEM_PROPERTY);
                    this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                    this.popupPanel.itemLabels[i].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                    this.popupPanel.itemLabels[i].repaint();
                }
                this.updateTextField();
                break;
            }
            case 2: {
                int n3;
                this.selectedCount = 0;
                this.originalCount = 0;
                this.unselectedCount = this.popupPanel.itemLabels.length - 3;
                for (n3 = 0; n3 < 2; ++n3) {
                    this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[n3].getClientProperty(ITEM_PROPERTY);
                    this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                    this.popupPanel.itemLabels[n3].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                    this.popupPanel.itemLabels[n3].repaint();
                }
                for (n3 = 3; n3 < this.popupPanel.itemLabels.length; ++n3) {
                    this.itemObjectTemp = (ItemObject)this.popupPanel.itemLabels[n3].getClientProperty(ITEM_PROPERTY);
                    this.itemObjectTemp.setState(ItemState.UNSELECTED_STATE);
                    this.popupPanel.itemLabels[n3].setIcon(ItemState.UNSELECTED_STATE.getIcon());
                    this.popupPanel.itemLabels[n3].repaint();
                }
                this.updateTextField();
                break;
            }
        }
    }

    private void updateTextField() {
        StringBuffer stringBuffer = new StringBuffer();
        ItemObject[] itemObjectArray = this.popupPanel.items;
        for (int i = 0; i < itemObjectArray.length; ++i) {
            if (this.isShowFunctionItem && i < 3 || itemObjectArray[i].getState() != ItemState.SELECTED_STATE) continue;
            stringBuffer.append(itemObjectArray[i].toString());
            stringBuffer.append(';');
        }
        String string = stringBuffer.toString();
        this.textField.setText(string);
        this.textField.setCaretPosition(0);
        if ("".equals(string)) {
            this.textField.setToolTipText(null);
        } else {
            this.textField.setToolTipText(string);
        }
    }

    public static final class Direction {
        private Direction() {
        }
    }

    private static class PopupPanel
    extends JPanel {
        JLabel[] itemLabels = null;
        ItemObject[] items = null;

        PopupPanel(Object[] objectArray, int n, Direction direction, boolean bl) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (bl) {
                this.itemLabels = new JLabel[objectArray.length + 3];
                this.items = new ItemObject[objectArray.length + 3];
                this.items[0] = new ItemObject(res1.getString("SELECT_ALL"));
                this.itemLabels[0] = new JLabel(this.items[0].toString(), this.items[0].getState().getIcon(), 2);
                this.itemLabels[0].putClientProperty(ThreeStateCombo.ITEM_PROPERTY, this.items[0]);
                this.itemLabels[0].setName("ThreeStateCombo_SELECT_ALL");
                this.items[1] = new ItemObject(res1.getString("CLEAR_ALL"));
                this.itemLabels[1] = new JLabel(this.items[1].toString(), this.items[1].getState().getIcon(), 2);
                this.itemLabels[1].putClientProperty(ThreeStateCombo.ITEM_PROPERTY, this.items[1]);
                this.itemLabels[1].setName("ThreeStateCombo_CLEAR_ALL");
                this.items[2] = new ItemObject(res1.getString("GRAY_ALL"));
                this.itemLabels[2] = new JLabel(this.items[2].toString(), this.items[2].getState().getIcon(), 2);
                this.itemLabels[2].putClientProperty(ThreeStateCombo.ITEM_PROPERTY, this.items[2]);
                this.itemLabels[2].setName("ThreeStateCombo_GRAY_ALL");
            } else {
                this.itemLabels = new JLabel[objectArray.length];
                this.items = new ItemObject[objectArray.length];
            }
            int n6 = n5 = bl ? 3 : 0;
            while (n6 - n5 < objectArray.length) {
                this.items[n6] = new ItemObject(objectArray[n6 - n5]);
                this.itemLabels[n6] = new JLabel(this.items[n6].toString(), this.items[n6].getState().getIcon(), 2);
                this.itemLabels[n6].putClientProperty(ThreeStateCombo.ITEM_PROPERTY, this.items[n6]);
                this.itemLabels[n6].setName("ThreeStateCombo_itemLabels_" + n6);
                ++n6;
            }
            n6 = bl ? 3 + objectArray.length : objectArray.length;
            int n7 = n6 / n;
            if (n6 % n != 0) {
                ++n7;
            }
            JLabel[][] jLabelArray = new JLabel[n7][n];
            if (direction == LEFT_TO_RIGHT) {
                n4 = 0;
                for (n3 = 0; n3 < n7; ++n3) {
                    for (n2 = 0; n2 < n; ++n2) {
                        n4 = n3 * n + n2;
                        if (n4 >= this.itemLabels.length) continue;
                        jLabelArray[n3][n2] = this.itemLabels[n4];
                    }
                }
            } else {
                n4 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    for (n2 = 0; n2 < n7; ++n2) {
                        n4 = n3 * n7 + n2;
                        if (n4 >= this.itemLabels.length) continue;
                        jLabelArray[n2][n3] = this.itemLabels[n4];
                    }
                }
            }
            this.setLayout(new GridBagLayout());
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < n7; ++n3) {
                    if (jLabelArray[n3][n4] == null) continue;
                    this.add((Component)jLabelArray[n3][n4], new GridBagConstraints(n4, n3, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
                }
            }
        }
    }

    private class FunctionItemHandler
    extends MouseAdapter {
        private int functionItemNo = 0;

        FunctionItemHandler(int n) {
            this.functionItemNo = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!ThreeStateCombo.this.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            ItemObject itemObject = (ItemObject)jLabel.getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
            ItemState itemState = null;
            itemState = itemObject.getState() == ItemState.SELECTED_STATE ? ItemState.ORIGINAL_STATE : ItemState.SELECTED_STATE;
            itemObject.setState(itemState);
            jLabel.setIcon(itemState.getIcon());
            jLabel.repaint();
            ThreeStateCombo.this.updateAll(this.functionItemNo);
        }
    }

    private class StateMouseHandler
    extends MouseAdapter {
        private StateMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!ThreeStateCombo.this.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            ItemObject itemObject = (ItemObject)jLabel.getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
            ItemState itemState = itemObject.getState();
            if (ThreeStateCombo.this.isShowFunctionItem) {
                if (itemState == ItemState.SELECTED_STATE) {
                    if (ThreeStateCombo.this.selectedCount > 0) {
                        ThreeStateCombo.this.selectedCount--;
                    }
                    ThreeStateCombo.this.itemObjectTemp = (ItemObject)((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[0].getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
                    ThreeStateCombo.this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                    ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[0].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                    ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[0].repaint();
                } else if (itemState == ItemState.ORIGINAL_STATE) {
                    if (ThreeStateCombo.this.originalCount > 0) {
                        ThreeStateCombo.this.originalCount--;
                    }
                    ThreeStateCombo.this.itemObjectTemp = (ItemObject)((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[1].getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
                    ThreeStateCombo.this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                    ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[1].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                    ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[1].repaint();
                } else {
                    if (ThreeStateCombo.this.unselectedCount > 0) {
                        ThreeStateCombo.this.unselectedCount--;
                    }
                    ThreeStateCombo.this.itemObjectTemp = (ItemObject)((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[2].getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
                    ThreeStateCombo.this.itemObjectTemp.setState(ItemState.ORIGINAL_STATE);
                    ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[2].setIcon(ItemState.ORIGINAL_STATE.getIcon());
                    ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[2].repaint();
                }
            }
            ItemState itemState2 = ThreeStateCombo.this.policy.next(itemObject.getState());
            if (ThreeStateCombo.this.isShowFunctionItem) {
                if (itemState2 == ItemState.SELECTED_STATE) {
                    ThreeStateCombo.this.selectedCount++;
                    if (ThreeStateCombo.this.selectedCount == ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels.length - 3) {
                        ThreeStateCombo.this.itemObjectTemp = (ItemObject)((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[0].getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
                        ThreeStateCombo.this.itemObjectTemp.setState(ItemState.SELECTED_STATE);
                        ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[0].setIcon(ItemState.SELECTED_STATE.getIcon());
                        ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[0].repaint();
                    }
                } else if (itemState2 == ItemState.ORIGINAL_STATE) {
                    ThreeStateCombo.this.originalCount++;
                    if (ThreeStateCombo.this.originalCount == ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels.length - 3) {
                        ThreeStateCombo.this.itemObjectTemp = (ItemObject)((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[1].getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
                        ThreeStateCombo.this.itemObjectTemp.setState(ItemState.SELECTED_STATE);
                        ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[1].setIcon(ItemState.SELECTED_STATE.getIcon());
                        ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[1].repaint();
                    }
                } else {
                    ThreeStateCombo.this.unselectedCount++;
                    if (ThreeStateCombo.this.unselectedCount == ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels.length - 3) {
                        ThreeStateCombo.this.itemObjectTemp = (ItemObject)((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[2].getClientProperty(ThreeStateCombo.ITEM_PROPERTY);
                        ThreeStateCombo.this.itemObjectTemp.setState(ItemState.SELECTED_STATE);
                        ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[2].setIcon(ItemState.SELECTED_STATE.getIcon());
                        ((ThreeStateCombo)ThreeStateCombo.this).popupPanel.itemLabels[2].repaint();
                    }
                }
            }
            itemObject.setState(itemState2);
            jLabel.setIcon(itemState2.getIcon());
            jLabel.repaint();
            ThreeStateCombo.this.updateTextField();
        }
    }

    private class PopupMouseHandler
    extends MouseAdapter {
        private PopupMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ThreeStateCombo.this.popupMenu.show(ThreeStateCombo.this, 0, 23);
        }
    }
}

