/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.beans.selectlist;

import com.swimap.iview.templates.beans.selectlist.StateChangedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class SelectList
extends JComponent {
    private JScrollPane scrollPane = new JScrollPane();
    private JTable table = new JTable();
    private SelectListModel model = new SelectListModel();
    private boolean isResponse = false;
    private Vector listenerVector = new Vector();
    private Vector tipVector = null;
    private boolean checkBoxCellSelectionEnabled = false;

    public SelectList() {
        this((Object[])null);
    }

    public SelectList(Vector vector) {
        this.model.setData(vector);
        this.table.setModel(this.model);
        this.init();
    }

    public SelectList(Object[] objectArray) {
        this.model.setData(objectArray);
        this.table.setModel(this.model);
        this.init();
    }

    public void setData(Vector vector) {
        this.model.setData(vector);
    }

    public void setData(Object[] objectArray) {
        this.model.setData(objectArray);
    }

    public void addElement(Object object, boolean bl) {
        this.model.addElement(object, bl);
    }

    public void removeElement(Object object) {
        this.model.removeElement(object);
    }

    public int getCurrentIndex() {
        return this.table.getSelectedRow();
    }

    public void setCurrentIndex(int n) {
        this.table.setRowSelectionInterval(n, n);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.scrollPane.getVerticalScrollBar().setEnabled(bl);
        this.scrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.scrollPane.setWheelScrollingEnabled(bl);
        this.table.setEnabled(bl);
        if (bl) {
            this.table.setForeground(Color.black);
        } else {
            this.table.clearSelection();
            this.table.setForeground(new Color(165, 165, 165));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.table.isEnabled();
    }

    public Object getValueAt(int n) {
        return this.model.getValueAt(n, 1);
    }

    public void setValueAt(Object object, int n) {
        this.model.setValueAt(object, n, 1);
    }

    public void setCurrentRowAllowed(boolean bl) {
        this.table.setRowSelectionAllowed(bl);
        this.table.setCellSelectionEnabled(false);
    }

    public boolean isRowSelected(int n) {
        return this.model.isRowSelected(n);
    }

    public Object[] getSelectedValues() {
        return this.model.getSelectedValues();
    }

    public void selectAll(boolean bl) {
        this.model.selectAll(bl);
    }

    public void setElementSelected(Object object, boolean bl) {
        this.model.setElementSelected(object, bl);
    }

    public void setRowSelected(int n, boolean bl) {
        this.model.setRowSelected(n, bl);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.table.addKeyListener(keyListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.table.addMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.table.addMouseMotionListener(mouseMotionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.table.removeKeyListener(keyListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.table.removeMouseListener(mouseListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.table.removeMouseMotionListener(mouseMotionListener);
    }

    public void setIsResponse(boolean bl) {
        this.isResponse = bl;
    }

    public void addStateChangedListener(StateChangedListener stateChangedListener) {
        this.listenerVector.addElement(stateChangedListener);
    }

    public void removeStateChangedListener(StateChangedListener stateChangedListener) {
        if (this.listenerVector.contains(stateChangedListener)) {
            this.listenerVector.remove(stateChangedListener);
        }
    }

    public void setRowRequestFocus(int n) {
        if (n < this.table.getRowCount() && n >= 0) {
            this.table.setRowSelectionInterval(n, n);
        }
    }

    private void init() {
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SelectList.this.isResponse && SwingUtilities.isLeftMouseButton(mouseEvent) && SelectList.this.table.isEnabled()) {
                    Object object;
                    int n = SelectList.this.table.rowAtPoint(mouseEvent.getPoint());
                    int n2 = SelectList.this.table.columnAtPoint(mouseEvent.getPoint());
                    if (n2 == 1 && (object = SelectList.this.table.getValueAt(n, 0)) instanceof Boolean) {
                        boolean bl = (Boolean)object == false;
                        SelectList.this.model.setRowSelected(n, bl);
                        SelectList.this.table.setRowSelectionInterval(n, n);
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object object;
                int n;
                if (keyEvent.getKeyCode() == 9) {
                    SelectList.this.table.transferFocus();
                    if (SelectList.this.scrollPane.getVerticalScrollBar().isVisible()) {
                        SelectList.this.scrollPane.getVerticalScrollBar().transferFocus();
                    }
                    keyEvent.consume();
                }
                if (SelectList.this.isResponse && keyEvent.getKeyCode() == 32 && (n = SelectList.this.table.getSelectedRow()) != -1 && (object = SelectList.this.table.getValueAt(n, 0)) instanceof Boolean) {
                    boolean bl = (Boolean)object == false;
                    SelectList.this.model.setRowSelected(n, bl);
                    SelectList.this.table.setRowSelectionInterval(n, n);
                    keyEvent.consume();
                }
            }
        });
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        int n = this.table.getRowHeight() + 3;
        tableColumn.setMinWidth(n);
        tableColumn.setMaxWidth(n);
        this.table.sizeColumnsToFit(0);
        tableColumn.setCellRenderer(new CheckRenderer());
        tableColumn.setCellEditor(new CheckEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new DataColumnRenderer());
        this.scrollPane.getViewport().add(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.setName("SelectList");
    }

    public void setScrollPaneBorder(Border border) {
        this.scrollPane.setBorder(border);
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void setFixedCellHeight(int n) {
        this.table.setRowHeight(n);
    }

    public int getFixedCellHeight() {
        return this.table.getRowHeight();
    }

    public int locationToIndex(Point point) {
        return this.table.rowAtPoint(point);
    }

    public void setCheckBoxCellSelectionEnabled(boolean bl) {
        this.checkBoxCellSelectionEnabled = bl;
    }

    public void setToolTip(Vector vector) {
        this.tipVector = vector;
    }

    private String getToolTipData(Object object, JLabel jLabel, int n) {
        String string;
        String string2 = object.toString();
        if (string2.equals(string = this.getAbbreviatoryString(string2, n, jLabel))) {
            string2 = null;
        }
        return string2;
    }

    private String getAbbreviatoryString(String string, int n, JLabel jLabel) {
        Font font = jLabel.getFont();
        Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(string);
        Insets insets = jLabel.getInsets(new Insets(0, 0, 0, 0));
        if ((n2 += insets.left + insets.right) < n) {
            return string;
        }
        return null;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.table.setName(string + "_table");
        this.scrollPane.setName(string + "_scrollPane");
    }

    private class DataColumnRenderer
    extends DefaultTableCellRenderer {
        private DataColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (SelectList.this.tipVector != null && SelectList.this.tipVector.size() > n) {
                if (SelectList.this.tipVector.get(n) != null && SelectList.this.tipVector.get(n).toString().length() > 0) {
                    String string = SelectList.this.getToolTipData(SelectList.this.tipVector.get(n).toString(), (JLabel)component, jTable.getColumnModel().getColumn(n2).getWidth());
                    ((JLabel)component).setToolTipText(string);
                } else {
                    ((JLabel)component).setToolTipText(null);
                }
            } else {
                ((JLabel)component).setToolTipText(null);
            }
            return component;
        }
    }

    private class CheckEditor
    extends DefaultCellEditor {
        private JCheckBox editor;

        public CheckEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.editor = null;
            this.editor = jCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Boolean) {
                this.editor.setSelected((Boolean)object);
            }
            this.editor.setBackground(jTable.getBackground());
            this.editor.setForeground(jTable.getForeground());
            if (SelectList.this.checkBoxCellSelectionEnabled && bl) {
                SelectList.this.setForeground(jTable.getSelectionForeground());
                this.editor.setBackground(jTable.getSelectionBackground());
            }
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.isSelected();
        }
    }

    private class CheckRenderer
    extends DefaultTableCellRenderer {
        private JCheckBox renderer = new JCheckBox(null, null, false);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Boolean) {
                boolean bl3 = (Boolean)object;
                this.renderer.setSelected(bl3);
            }
            this.renderer.setEnabled(jTable.isEnabled());
            this.renderer.setBackground(jTable.getBackground());
            this.renderer.setForeground(jTable.getForeground());
            if (SelectList.this.checkBoxCellSelectionEnabled && bl) {
                this.renderer.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            }
            if (SelectList.this.tipVector != null && SelectList.this.tipVector.size() > n) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, 1);
                if (SelectList.this.tipVector.get(n) != null && SelectList.this.tipVector.get(n).toString().length() > 0) {
                    String string = SelectList.this.getToolTipData(SelectList.this.tipVector.get(n).toString(), (JLabel)component, jTable.getColumnModel().getColumn(1).getWidth());
                    this.renderer.setToolTipText(string);
                } else {
                    this.renderer.setToolTipText(null);
                }
            } else {
                this.renderer.setToolTipText(null);
            }
            return this.renderer;
        }
    }

    private class SelectListModel
    extends DefaultTableModel {
        static final int COLUMN_COUNT = 2;
        static final int STATE_COLUMN = 0;
        static final int DATA_COLUMN = 1;
        private Vector state = new Vector(){

            public synchronized void setElementAt(Object object, int n) {
                int n2;
                Object object2 = this.elementData[n];
                super.setElementAt(object, n);
                if (((Boolean)object2).booleanValue() != ((Boolean)object).booleanValue() && (n2 = SelectList.this.listenerVector.size()) > 0) {
                    for (int i = 0; i < n2; ++i) {
                        ((StateChangedListener)SelectList.this.listenerVector.get(i)).stateChanged(n);
                    }
                }
            }
        };
        private Vector data = new Vector();

        public SelectListModel() {
            this((Object[])null);
        }

        public SelectListModel(Vector vector) {
            this.setData(vector);
        }

        public SelectListModel(Object[] objectArray) {
            this.setData(objectArray);
        }

        public void setData(Vector vector) {
            this.setData(vector == null ? null : vector.toArray());
        }

        public void setData(Object[] objectArray) {
            this.createDataValue(objectArray);
        }

        private void createDataValue(Object[] objectArray) {
            this.state.clear();
            this.data.clear();
            if (objectArray != null && objectArray.length > 0) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.state.addElement(Boolean.FALSE);
                    this.data.addElement(objectArray[i]);
                }
            }
            this.fireTableDataChanged();
        }

        public void selectAll(boolean bl) {
            int n = this.state.size();
            for (int i = 0; i < n; ++i) {
                this.state.setElementAt(bl, i);
            }
            this.fireTableDataChanged();
        }

        public boolean isRowSelected(int n) {
            return (Boolean)this.state.elementAt(n);
        }

        public Object[] getSelectedValues() {
            if (this.data == null || this.data.size() == 0) {
                return null;
            }
            Vector vector = new Vector();
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.state.elementAt(i).equals(Boolean.TRUE)) continue;
                vector.add(this.data.elementAt(i));
            }
            return vector.toArray();
        }

        public void setElementSelected(Object object, boolean bl) {
            int n = this.data.indexOf(object);
            if (-1 != n) {
                this.setRowSelected(n, bl);
            }
        }

        public void setRowSelected(int n, boolean bl) {
            this.state.setElementAt(bl, n);
            this.fireTableDataChanged();
        }

        public void addElement(Object object, boolean bl) {
            this.state.addElement(bl);
            this.data.addElement(object);
            this.fireTableDataChanged();
        }

        public void removeElement(Object object) {
            int n = this.data.indexOf(object);
            if (n >= 0) {
                this.state.remove(n);
                this.data.remove(n);
                this.fireTableDataChanged();
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.state.elementAt(n);
            }
            if (n2 == 1) {
                return this.data.elementAt(n);
            }
            throw new IndexOutOfBoundsException("The column should be 0 or 1");
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && !(object instanceof Boolean)) {
                throw new ClassCastException("The type is " + object.getClass() + ", the required type is java.lang.Boolean");
            }
            if (n2 == 0) {
                this.state.setElementAt(object, n);
            } else if (n2 == 1) {
                this.data.setElementAt(object, n);
            } else {
                throw new IndexOutOfBoundsException("The column should be 0 or 1");
            }
        }
    }
}

