/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.beans;

import com.swimap.iview.templates.basictable.filter.FilterConstants;
import com.swimap.iview.templates.beans.TableColumnSortable;
import com.swimap.iview.templates.beans.TableProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.table.TableCellRenderer;

public class SortableTableHeaderRenderer
implements TableCellRenderer {
    private ImageIcon sortableIcon = new ImageIcon(this.getClass().getResource("sortable.gif"));
    private ImageIcon upSortedIcon = new ImageIcon(this.getClass().getResource("upsorted.gif"));
    private ImageIcon downSortedIcon = new ImageIcon(this.getClass().getResource("downsorted.gif"));
    private JLabel iconLabel = new JLabel();
    private JPanel topPanel = new JPanel(new BorderLayout());
    private JLabel filterIconLbl = new JLabel(FilterConstants.EMPTY_FILTER_ICON);

    public SortableTableHeaderRenderer() {
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setHorizontalTextPosition(2);
        this.iconLabel.setName("SortableTableHeaderRenderer_iconLabel");
        this.filterIconLbl.setBorder(FilterConstants.FILTER_ICON_BORDER);
        this.filterIconLbl.setName("SortableTableHeaderRenderer_FilterIconLabel");
        Dimension dimension = new Dimension(15, 10);
        this.filterIconLbl.setMinimumSize(dimension);
        this.filterIconLbl.setPreferredSize(dimension);
        LookAndFeel.installBorder(this.topPanel, "TableHeader.cellBorder");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (jTable instanceof TableProperties) {
            object2 = (TableProperties)((Object)jTable);
            bl3 = object2.getSortable();
            bl4 = object2.isDataFilterEnabled();
            bl5 = object2.isColumnFiltarable(n2);
        }
        this.topPanel.removeAll();
        if (jTable instanceof TableColumnSortable) {
            object2 = (TableColumnSortable)((Object)jTable);
            if (object2.isColumnSortable(n2) && (bl3 || !(jTable instanceof TableProperties))) {
                this.iconLabel.setIcon(this.sortableIcon);
                int n3 = object2.getColumnState(n2);
                if (n3 < 0) {
                    this.iconLabel.setIcon(this.downSortedIcon);
                } else if (n3 > 0) {
                    this.iconLabel.setIcon(this.upSortedIcon);
                }
            } else {
                this.iconLabel.setIcon(null);
            }
        }
        this.iconLabel.setText(object.toString());
        this.topPanel.add((Component)this.iconLabel, "Center");
        if (bl4 && bl5) {
            boolean bl6 = ((TableProperties)((Object)jTable)).isColumnFiltered(n2);
            this.filterIconLbl.setIcon(bl6 ? FilterConstants.NON_EMPTY_FILTER_ICON : FilterConstants.EMPTY_FILTER_ICON);
            this.topPanel.add((Component)this.filterIconLbl, "East");
        }
        Insets insets = this.topPanel.getInsets();
        insets.top = 1;
        insets.bottom = 0;
        return this.topPanel;
    }
}

