/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.basictable.filter;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.basictable.filter.MultiValueComboListener;
import com.swimap.iview.templates.beans.JLFCheckList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

class MultiValueCombo
extends JPanel {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/basictable/Res");
    private static final int MAXIMUM_ROWCOUNT = 8;
    private static final int ARRAYLIST_CAPACITY = 8;
    private List<Object> addedValues = new ArrayList<Object>(8);
    private MultiValuePopup popup = null;
    private Object[] selectedItems = null;
    private JTextField field = null;
    private transient MultiValueComboListener listener;

    MultiValueCombo(Collection<Object> collection, List<Object> list) {
        if (null != list) {
            this.addedValues = list;
        }
        this.initPanel(collection);
    }

    private void initPanel(Collection<Object> collection) {
        this.popup = new MultiValuePopup(collection);
        JButton jButton = new JButton(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (this.getModel().isPressed()) {
                    this.setBackground(new Color(240, 240, 240));
                } else {
                    this.setBackground(Color.WHITE);
                }
                int n3 = n / 2 - 5;
                int n4 = n2 / 2 - 2;
                graphics.translate(n3, n4);
                graphics.drawLine(0, 0, 8, 0);
                graphics.drawLine(1, 1, 7, 1);
                graphics.drawLine(2, 2, 6, 2);
                graphics.drawLine(3, 3, 5, 3);
                graphics.drawLine(4, 4, 4, 4);
                graphics.translate(-n3, -n4);
            }
        };
        this.field = new JTextField();
        this.field.setEditable(false);
        this.field.setPreferredSize(new Dimension(100, 19));
        jButton.setBorder(this.field.getBorder());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBackground(this.field.getBackground());
        jButton.setPreferredSize(new Dimension(20, 21));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiValueCombo.this.popup.refreshAddedValues();
                MultiValueCombo.this.popup.adjustSize(MultiValueCombo.this.getPreferredSize());
                MultiValueCombo.this.popup.show(MultiValueCombo.this.field, 0, MultiValueCombo.this.field.getHeight());
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.field);
        this.add((Component)jButton, "East");
    }

    public void reinitList(Collection<Object> collection, List<Object> list) {
        this.addedValues = list;
        this.popup.reinitList(collection);
    }

    public List<Object> getAddedValues() {
        return this.addedValues;
    }

    public void setSelectedItems(Object[] objectArray) {
        this.popup.setSelectedItems(objectArray);
    }

    public void initComboValue() {
        this.popup.setComboValue();
    }

    public void clearSelection() {
        this.popup.clearSelection();
    }

    public Object[] getSelectedItems() {
        return this.selectedItems;
    }

    public void setListener(MultiValueComboListener multiValueComboListener) {
        this.listener = multiValueComboListener;
    }

    public static String getMultiValueStr(Object[] objectArray) {
        if (null == objectArray) {
            return "";
        }
        int n = objectArray.length;
        if (n == 0) {
            return "";
        }
        String string = null;
        String string2 = "[ ";
        for (int i = 0; i < n; ++i) {
            String string3 = string = objectArray[i] == null ? "" : objectArray[i].toString();
            if (string.indexOf(44) != -1) {
                string = "\"" + string + "\"";
            }
            string2 = string2 + string;
            if (i + 1 >= n) continue;
            string2 = string2 + " , ";
        }
        string2 = string2 + " ]";
        return string2;
    }

    static /* synthetic */ Object[] access$1102(MultiValueCombo multiValueCombo, Object[] objectArray) {
        multiValueCombo.selectedItems = objectArray;
        return objectArray;
    }

    private class MultiValuePopup
    extends JPopupMenu {
        private JLFCheckList list = null;
        private Font boldFont = null;
        private JScrollPane scroll = null;
        private JTextField newValField = null;
        private Dimension tfSize = new Dimension(170, 21);

        MultiValuePopup(Collection<Object> collection) {
            this.add(this.getInputPanel(collection));
        }

        private JPanel getInputPanel(Collection<Object> collection) {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.initMultiList(collection);
            this.initTextField();
            JPanel jPanel2 = this.initButtons();
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createEmptyBorder(3, 4, 0, 3));
            jPanel3.add(this.newValField);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add(this.scroll);
            jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 3));
            jPanel.add((Component)jPanel3, "North");
            jPanel.add((Component)jPanel4, "Center");
            jPanel.add((Component)jPanel2, "South");
            return jPanel;
        }

        private void initMultiList(Collection<Object> collection) {
            DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
            this.list = new JLFCheckList((ListModel)defaultListModel);
            Font font = this.list.getFont();
            this.boldFont = new Font(font.getFontName(), 1, font.getSize());
            this.list.setCellRenderer(new PopupListCellRenderer());
            if (null != collection) {
                for (Object object : collection) {
                    defaultListModel.addElement(object);
                }
            }
            for (Object object : MultiValueCombo.this.addedValues) {
                defaultListModel.addElement(object);
            }
            this.list.setFixedCellHeight(20);
            this.list.setVisibleRowCount(Math.min(8, defaultListModel.getSize()));
            this.scroll = new JScrollPane(this.list);
            if (defaultListModel.size() == 0) {
                this.scroll.setVisible(false);
            }
        }

        private JPanel initButtons() {
            Dimension dimension = new Dimension(80, 21);
            JPanel jPanel = new JPanel(new FlowLayout(2, 4, 3));
            JButton jButton = new JButton(res.getString("Btn_OK"));
            jButton.setPreferredSize(dimension);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiValuePopup.this.setComboValue();
                    MultiValuePopup.this.setVisible(false);
                    if (null != MultiValueCombo.this.listener) {
                        MultiValueCombo.this.listener.valueChanged();
                    }
                }
            });
            JButton jButton2 = new JButton(res.getString("Btn_Cancel"));
            jButton2.setPreferredSize(dimension);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiValuePopup.this.setVisible(false);
                }
            });
            jPanel.add(jButton);
            jPanel.add(jButton2);
            return jPanel;
        }

        private void initTextField() {
            this.newValField = new JTextField();
            this.newValField.setToolTipText(res.getString("Add_NewColValue"));
            this.newValField.setPreferredSize(this.tfSize);
            this.newValField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultListModel defaultListModel = (DefaultListModel)MultiValuePopup.this.list.getModel();
                    String string = MultiValuePopup.this.newValField.getText();
                    MultiValuePopup.this.newValField.setText("");
                    if (null == string || string.trim().length() == 0) {
                        return;
                    }
                    Object object = MultiValuePopup.this.findElement(defaultListModel.elements(), string);
                    if (object != null) {
                        int n = defaultListModel.indexOf(object);
                        if (MultiValuePopup.this.list.isSelectedIndex(n)) {
                            Rectangle rectangle = MultiValuePopup.this.list.getCellBounds(n, n);
                            MultiValuePopup.this.list.scrollRectToVisible(rectangle);
                        } else {
                            MultiValuePopup.this.list.setSelectedValue(object, true);
                        }
                        return;
                    }
                    this.addValue(defaultListModel, string);
                }

                private void addValue(DefaultListModel defaultListModel, String string) {
                    defaultListModel.addElement(string);
                    MultiValueCombo.this.addedValues.add(string);
                    MultiValuePopup.this.list.setSelectedValue(string, true);
                    if (!MultiValuePopup.this.scroll.isVisible()) {
                        MultiValuePopup.this.scroll.setVisible(true);
                    }
                    MultiValuePopup.this.list.setVisibleRowCount(Math.min(8, defaultListModel.getSize()));
                    MultiValuePopup.this.pack();
                    MultiValuePopup.this.updateUI();
                    MultiValuePopup.this.newValField.requestFocusInWindow();
                }
            });
        }

        protected void setComboValue() {
            MultiValueCombo.access$1102(MultiValueCombo.this, this.list.getSelectedValues());
            MultiValueCombo.this.field.setText(MultiValueCombo.getMultiValueStr(MultiValueCombo.this.selectedItems));
        }

        protected void refreshAddedValues() {
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            for (Object e : MultiValueCombo.this.addedValues) {
                if (defaultListModel.contains(e)) continue;
                defaultListModel.addElement(e);
            }
            this.list.setVisibleRowCount(Math.min(8, defaultListModel.getSize()));
            MultiValueCombo.access$1102(MultiValueCombo.this, this.getSelectedItems());
        }

        private Object findElement(Enumeration<?> enumeration, Object object) {
            Object object2 = null;
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (!object.toString().equals(object2.toString())) continue;
                return object2;
            }
            return null;
        }

        protected void adjustSize(Dimension dimension) {
            this.tfSize.width = Math.max(dimension.width - 10, 170);
            MultiValueCombo.this.field.setPreferredSize(this.tfSize);
        }

        public void setSelectedItems(Object[] objectArray) {
            for (Object object : objectArray) {
                this.list.setSelectedValue(object, false);
            }
            this.setComboValue();
        }

        private void clearSelection() {
            this.list.clearSelection();
        }

        public Object[] getSelectedItems() {
            return this.list.getSelectedValues();
        }

        protected void reinitList(Collection<Object> collection) {
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            defaultListModel.removeAllElements();
            for (Object object : collection) {
                defaultListModel.addElement(object);
            }
            for (Object object : MultiValueCombo.this.addedValues) {
                defaultListModel.addElement(object);
            }
            this.scroll.setVisible(defaultListModel.size() > 0);
            this.list.setVisibleRowCount(Math.min(8, defaultListModel.getSize()));
        }

        private class PopupListCellRenderer
        extends JCheckBox
        implements ListCellRenderer {
            private PopupListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setText(object.toString());
                this.setSelected(bl);
                this.setEnabled(jList.isEnabled());
                this.setBackground(jList.getBackground());
                this.setOpaque(true);
                Font font = jList.getFont();
                this.setFont(MultiValueCombo.this.addedValues.contains(object) ? MultiValuePopup.this.boldFont : font);
                return this;
            }
        }
    }
}

