/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.basictable.filter;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.basictable.filter.AdvancedCustomFilter;
import com.swimap.iview.templates.basictable.filter.DefaultFilterElement;
import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.Filterable;
import com.swimap.iview.templates.basictable.filter.MultiValueCombo;
import com.swimap.iview.templates.basictable.filter.Operators;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class CustomFilterDlg
extends JDialog {
    private static final long serialVersionUID = 3516301928698894948L;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/basictable/Res");
    private IviewLogger logger = IviewLogger.getLogger(CustomFilterDlg.class, "IVIEW");
    private List<JComboBox> operatorComboList = new ArrayList<JComboBox>(2);
    private List<JComponent> valueComboList = new ArrayList<JComponent>(2);
    private List<MultiValueCombo> multiValueComboList = new ArrayList<MultiValueCombo>(2);
    private List<List<JRadioButton>> opRadioList = new ArrayList<List<JRadioButton>>(2);
    private Operators.GroupOperator[] groupOpSelection = null;
    private Collection<Object> values = null;
    private String colName = null;
    private DefaultFilterElement rootElement = null;
    private final int DIALOG_WIDTH = 474;
    private final int DIALOG_HEIGHT = 260;
    private final int GAP = 5;
    private final int COMBO_HEIGHT = 20;
    private final int COMBO_WIDTH = 200;
    private final int RADIO_WIDTH = 60;
    private final int RADIO_HEIGHT = 13;
    private final int BUTTON_HEIGHT = 21;
    private final int BUTTON_WIDTH = 80;
    private final int ADVANCED_BUTTON_WIDTH = 60;
    private Map<Integer, Object> columnNames = null;
    private Filterable model = null;
    private int columnIndex = -1;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel dynamicPanel = new JPanel(new BorderLayout());
    private AdvancedCustomFilter advPanel = null;
    private boolean okPressed = false;
    private final int ARRAYLIST_CAPACITY = 8;
    private boolean advanceOptPopup = false;
    private JButton okBtn = null;
    private boolean keyPressed = false;

    public CustomFilterDlg(Collection<Object> collection, int n, Filterable filterable, Map<Integer, Object> map) {
        super((Frame)FrameworkUtilities.getMainFrame(), true);
        this.values = collection;
        this.columnIndex = n;
        this.model = filterable;
        this.columnNames = map;
        this.colName = this.columnNames.get(n).toString();
        this.jbInit();
    }

    private void jbInit() {
        this.setSize(474, 260);
        this.setTitle(res.getString("Filter_Dlg_Title"));
        this.setName("Custom_Filter_Dlg");
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.getContentPane().add(this.getDialogPanel());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = CustomFilterDlg.this.getSize();
                if (dimension.getWidth() < 474.0 || dimension.getHeight() != 260.0) {
                    if (dimension.getWidth() < 474.0) {
                        CustomFilterDlg.this.setSize(474, (int)dimension.getHeight());
                    } else {
                        CustomFilterDlg.this.setSize((int)dimension.getWidth(), 260);
                    }
                }
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        ScreenToolKit.centerLocateToScreen(this);
    }

    private JPanel getDialogPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 4, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, -2, -4));
        jPanel.setPreferredSize(new Dimension(500, 30));
        JLabel jLabel = new JLabel(res.getString("Filter_Dlg_TopLbl"));
        jLabel.setName("CustomFilter_Dlg_topLBL");
        jLabel.setPreferredSize(new Dimension(300, 20));
        this.dynamicPanel.add((Component)jLabel, "North");
        this.initializeCombosAndRadios(2);
        this.dynamicPanel.add((Component)this.getCondPanel(), "Center");
        this.okBtn = new JButton(res.getString("Btn_OK"));
        this.okBtn.setName("CustomFilter_Dlg_OK");
        this.okBtn.setPreferredSize(new Dimension(80, 21));
        JButton jButton = new JButton(res.getString("Btn_Cancel"));
        jButton.setName("CustomFilter_Dlg_Cancel");
        jButton.setPreferredSize(new Dimension(80, 21));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFilterDlg.this.formConditions();
                CustomFilterDlg.this.closeDialog();
                CustomFilterDlg.this.okPressed = true;
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFilterDlg.this.rootElement = null;
                CustomFilterDlg.this.closeDialog();
                CustomFilterDlg.this.okPressed = false;
            }
        });
        ScreenToolKit.setDefaultButtons(this.okBtn, jButton);
        jPanel.add(this.okBtn);
        jPanel.add(jButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CustomFilterDlg.this.rootElement = null;
                CustomFilterDlg.this.closeDialog();
                CustomFilterDlg.this.okPressed = false;
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                CustomFilterDlg.this.setFocusOnOKButton();
            }
        });
        this.mainPanel.add((Component)this.dynamicPanel, "Center");
        this.mainPanel.add((Component)jPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        return this.mainPanel;
    }

    private void setFocusOnOKButton() {
        if (this.okBtn != null) {
            this.okBtn.requestFocus();
        }
    }

    private void closeDialog() {
        this.dispose();
        this.setVisible(false);
    }

    private void initializeCombosAndRadios(int n) {
        JComboBox<Object> jComboBox = null;
        JComboBox<Object> jComboBox2 = null;
        JTextField jTextField = null;
        MultiValueCombo multiValueCombo = null;
        JRadioButton jRadioButton = null;
        JRadioButton jRadioButton2 = null;
        this.groupOpSelection = new Operators.GroupOperator[n - 1];
        Dimension dimension = new Dimension(200, 20);
        Dimension dimension2 = new Dimension(60, 13);
        List<Operators.Operator> list = this.model.getFilterOperatorList(this.columnIndex);
        if (null == list || list.size() <= 0) {
            list = Arrays.asList(Operators.Operator.values());
        }
        OperatorAction operatorAction = null;
        ValueAction valueAction = null;
        KeyOperationAction keyOperationAction = null;
        ValueItemChangeListner valueItemChangeListner = null;
        for (int i = 0; i < n; ++i) {
            jComboBox = new JComboBox<Object>();
            jComboBox.setName("CustomFilter_DLG_OP_Combo" + i);
            operatorAction = new OperatorAction();
            keyOperationAction = new KeyOperationAction();
            jComboBox.addKeyListener(keyOperationAction);
            jComboBox.addActionListener(operatorAction);
            if (i != 0) {
                jComboBox.addItem("");
            }
            for (Operators.Operator operator : list) {
                jComboBox.addItem((Object)operator);
            }
            jComboBox.setPreferredSize(dimension);
            this.operatorComboList.add(jComboBox);
            if (this.values.size() == 0) {
                jTextField = new JTextField();
                jTextField.setName("CustomFilter_DLG_Val_Field" + i);
                jTextField.setPreferredSize(dimension);
                this.valueComboList.add(jTextField);
            } else {
                jComboBox2 = new JComboBox<Object>(this.values.toArray());
                jComboBox2.setName("CustomFilter_DLG_Val_Combo" + i);
                jComboBox2.setEditable(true);
                jComboBox2.setPreferredSize(dimension);
                jComboBox2.setSelectedIndex(-1);
                jComboBox2.setRenderer(new ValueComboRendrer());
                valueAction = new ValueAction();
                valueItemChangeListner = new ValueItemChangeListner();
                jComboBox2.addActionListener(valueAction);
                jComboBox2.addItemListener(valueItemChangeListner);
                this.valueComboList.add(jComboBox2);
            }
            multiValueCombo = new MultiValueCombo(this.values, this.model.getAddedColumnValueList(this.columnIndex));
            multiValueCombo.setPreferredSize(dimension);
            this.multiValueComboList.add(multiValueCombo);
            if (i != 0) {
                jComboBox.setSelectedIndex(0);
            }
            if (i >= n - 1) continue;
            ArrayList arrayList = new ArrayList(2);
            jRadioButton = new JRadioButton(res.getString("Gruop_OP_AND"));
            jRadioButton.setName("CustomFilter_DLG_AndRB" + i);
            final int n2 = i;
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((CustomFilterDlg)CustomFilterDlg.this).groupOpSelection[n2] = Operators.GroupOperator.GROUP_OP_AND;
                }
            });
            jRadioButton.setMnemonic('A');
            jRadioButton.setPreferredSize(dimension2);
            jRadioButton.setSelected(true);
            this.groupOpSelection[n2] = Operators.GroupOperator.GROUP_OP_AND;
            jRadioButton2 = new JRadioButton(res.getString("Group_OP_OR"));
            jRadioButton2.setName("CustomFilter_DLG_ORRB" + i);
            jRadioButton2.setMnemonic('O');
            jRadioButton2.setPreferredSize(dimension2);
            jRadioButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((CustomFilterDlg)CustomFilterDlg.this).groupOpSelection[n2] = Operators.GroupOperator.GROUP_OP_OR;
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            arrayList.add(jRadioButton);
            arrayList.add(jRadioButton2);
            this.opRadioList.add(arrayList);
        }
    }

    private JPanel getCondPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), this.colName, 0, 2, jPanel.getFont(), Color.BLUE);
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.operatorComboList.size();
        for (int i = 0; i < n; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i * 2;
            gridBagConstraints.insets = new Insets(2, 5, 3, 6);
            jPanel.add((Component)this.operatorComboList.get(i), gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i * 2;
            gridBagConstraints.insets = new Insets(2, 6, 3, 5);
            jPanel.add((Component)this.valueComboList.get(i), gridBagConstraints);
            jPanel.add((Component)this.multiValueComboList.get(i), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            if (i >= n - 1) continue;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i * 2 + 1;
            gridBagConstraints.insets = new Insets(2, 5, 3, 6);
            JPanel jPanel2 = new JPanel();
            List<JRadioButton> list = this.opRadioList.get(i);
            jPanel2.add(list.get(0));
            jPanel2.add(list.get(1));
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }
        final JLabel jLabel = new JLabel("<html><u>" + res.getString("Advanced_LBL") + "</u></html>");
        jLabel.setToolTipText(res.getString("Advanced_LBL_Tooltip"));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setForeground(new Color(0, 102, 153));
        jLabel.setName("CustomFilter_Dlg_Advanced");
        jLabel.setPreferredSize(new Dimension(60, 21));
        jLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jLabel.getFocusCycleRootAncestor().transferFocus();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CustomFilterDlg.this.addAdvancedPanel();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Font font = (Font)UIManager.get("Label.font");
                jLabel.setFont(new Font(font.getFontName(), 1, font.getSize()));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Font font = (Font)UIManager.get("Label.font");
                jLabel.setFont(new Font(font.getFontName(), 0, font.getSize()));
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n * 2;
        gridBagConstraints.insets = new Insets(5, 130, 0, 0);
        return jPanel;
    }

    private void addAdvancedPanel() {
        if (null == this.rootElement) {
            this.formConditions();
        }
        DefaultFilterElement defaultFilterElement = this.rootElement;
        this.advPanel = new AdvancedCustomFilter(defaultFilterElement, this.columnNames, this.model);
        this.advPanel.setHideRootOperatorPopUp(this.advanceOptPopup);
        this.mainPanel.remove(this.dynamicPanel);
        this.mainPanel.add((Component)this.advPanel.getPanel(), "Center");
        this.setTitle(res.getString("Advanced_Filter_Dlg_Title"));
        this.mainPanel.revalidate();
    }

    private void formConditions() {
        if (this.isAdvancedFilter()) {
            return;
        }
        DefaultFilterElement defaultFilterElement = new DefaultFilterElement(null);
        DefaultFilterElement defaultFilterElement2 = null;
        JComboBox jComboBox = null;
        JTextField jTextField = null;
        Object object = null;
        Object object2 = null;
        int n = this.operatorComboList.size();
        for (int i = 0; i < n; ++i) {
            defaultFilterElement2 = new DefaultFilterElement(null);
            jComboBox = this.operatorComboList.get(i);
            object = jComboBox.getSelectedItem();
            if (!(object instanceof Operators.Operator)) continue;
            defaultFilterElement2.setOperator((Operators.Operator)((Object)object));
            if (Operators.Operator.EXIST_IN == object || Operators.Operator.NOT_EXIST_IN == object) {
                object2 = this.multiValueComboList.get(i).getSelectedItems();
            } else if (this.values.size() == 0) {
                jTextField = (JTextField)this.valueComboList.get(i);
                object2 = jTextField.getText();
            } else {
                jComboBox = (JComboBox)this.valueComboList.get(i);
                object2 = jComboBox.getSelectedItem();
            }
            object2 = null == object2 ? "" : object2;
            defaultFilterElement2.setValue(object2);
            defaultFilterElement2.setColumnIndex(this.columnIndex);
            defaultFilterElement2.setViewColumnName(this.columnNames.get(this.columnIndex).toString());
            defaultFilterElement.add(defaultFilterElement2);
            if (i >= n - 1 || this.operatorComboList.get(i + 1).getSelectedIndex() <= 0) continue;
            defaultFilterElement.setGroupOp(this.groupOpSelection[i]);
        }
        if (null == this.rootElement) {
            this.rootElement = new DefaultFilterElement(null);
            this.rootElement.setGroupOp(Operators.GroupOperator.GROUP_OP_AND);
        }
        if (defaultFilterElement.getChildCount() > 1) {
            this.rootElement.addIntersectionFilter(defaultFilterElement, this.columnIndex);
        } else if (defaultFilterElement.getChildCount() == 1) {
            this.rootElement.addIntersectionFilter((DefaultFilterElement)defaultFilterElement.getChildAt(0), this.columnIndex);
        }
    }

    public void initializeConditions(DefaultFilterElement defaultFilterElement) {
        Object object;
        if (null == defaultFilterElement) {
            return;
        }
        this.rootElement = defaultFilterElement;
        ArrayList<DefaultFilterElement> arrayList = new ArrayList<DefaultFilterElement>(8);
        defaultFilterElement.getConditionsof(this.columnIndex, arrayList);
        FilterElement[] filterElementArray = new FilterElement[arrayList.size()];
        arrayList.toArray(filterElementArray);
        JComboBox jComboBox = null;
        JTextField jTextField = null;
        FilterElement filterElement = null;
        int n = filterElementArray.length;
        Operators.Operator operator = null;
        Object object2 = null;
        for (int i = 0; i < n; ++i) {
            filterElement = filterElementArray[i];
            jComboBox = this.operatorComboList.get(i);
            operator = filterElement.getCondOperator();
            jComboBox.setSelectedItem((Object)operator);
            object2 = filterElement.getCondValue();
            if (operator == Operators.Operator.EXIST_IN || operator == Operators.Operator.NOT_EXIST_IN) {
                object = this.multiValueComboList.get(i);
                if (!(object2 instanceof Object[])) continue;
                ((MultiValueCombo)object).setSelectedItems((Object[])object2);
                continue;
            }
            if (this.values.size() == 0) {
                jTextField = (JTextField)this.valueComboList.get(i);
                jTextField.setText(filterElement.getCondValue().toString());
                continue;
            }
            jComboBox = (JComboBox)this.valueComboList.get(i);
            jComboBox.setSelectedItem(filterElement.getCondValue());
        }
        if (n == 2 && filterElementArray[0].getParent() == filterElementArray[1].getParent()) {
            List<JRadioButton> list = this.opRadioList.get(0);
            object = filterElementArray[0].getParent().getGroupOperator();
            switch (8.$SwitchMap$com$swimap$iview$templates$basictable$filter$Operators$GroupOperator[((Enum)object).ordinal()]) {
                case 1: {
                    list.get(0).setSelected(true);
                    break;
                }
                case 2: {
                    list.get(1).setSelected(true);
                    break;
                }
                default: {
                    this.logger.trace("Group operator is not supported.");
                }
            }
            this.groupOpSelection[0] = object;
        }
        this.initComboVisibility();
    }

    private void initComboVisibility() {
        int n = this.operatorComboList.size();
        Object object = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            object = this.operatorComboList.get(i).getSelectedItem();
            bl = false;
            if (object instanceof Operators.Operator) {
                Operators.Operator operator = (Operators.Operator)((Object)object);
                bl = operator == Operators.Operator.EXIST_IN || operator == Operators.Operator.NOT_EXIST_IN;
            }
            this.valueComboList.get(i).setVisible(!bl);
            this.multiValueComboList.get(i).setVisible(bl);
        }
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    public boolean isAdvancedFilter() {
        return this.advPanel != null;
    }

    public FilterElement getFilterElement() {
        if (this.advPanel != null) {
            return this.advPanel.getFilter();
        }
        return this.rootElement;
    }

    public void setHideAdvanceOptPopup(boolean bl) {
        this.advanceOptPopup = bl;
    }

    static class 8 {
        static final /* synthetic */ int[] $SwitchMap$com$swimap$iview$templates$basictable$filter$Operators$GroupOperator;

        static {
            $SwitchMap$com$swimap$iview$templates$basictable$filter$Operators$GroupOperator = new int[Operators.GroupOperator.values().length];
            try {
                8.$SwitchMap$com$swimap$iview$templates$basictable$filter$Operators$GroupOperator[Operators.GroupOperator.GROUP_OP_AND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                8.$SwitchMap$com$swimap$iview$templates$basictable$filter$Operators$GroupOperator[Operators.GroupOperator.GROUP_OP_OR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    class ValueComboRendrer
    extends BasicComboBoxRenderer {
        Object[] objvale;

        ValueComboRendrer() {
            this.objvale = CustomFilterDlg.this.values.toArray();
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
                if (-1 < n) {
                    jList.setToolTipText(this.objvale[n].toString());
                }
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            this.setFont(jList.getFont());
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    private class ValueItemChangeListner
    implements ItemListener {
        private ValueItemChangeListner() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            CustomFilterDlg.this.keyPressed = true;
        }
    }

    private class ValueAction
    implements ActionListener {
        private ValueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CustomFilterDlg.this.keyPressed) {
                CustomFilterDlg.this.setFocusOnOKButton();
            }
            CustomFilterDlg.this.keyPressed = false;
        }
    }

    private class KeyOperationAction
    implements KeyListener {
        private KeyOperationAction() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
                CustomFilterDlg.this.setFocusOnOKButton();
            } else {
                CustomFilterDlg.this.keyPressed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class OperatorAction
    implements ActionListener {
        private OperatorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomFilterDlg.this.initComboVisibility();
            if (!CustomFilterDlg.this.keyPressed) {
                CustomFilterDlg.this.setFocusOnOKButton();
            }
            CustomFilterDlg.this.keyPressed = false;
        }
    }
}

