/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.basictable.filter;

import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.Operators;
import java.util.ArrayList;
import java.util.List;

public class BasicFilterElement
implements FilterElement {
    protected List<BasicFilterElement> children = null;
    protected FilterElement parent = null;
    protected Operators.GroupOperator groupOperator = null;
    protected int columnIndex = -1;
    protected Operators.Operator condOperator = null;
    protected Object condValue = null;
    private static final int INITIAL_SIZE = 4;

    public BasicFilterElement(Operators.GroupOperator groupOperator) {
        this.groupOperator = groupOperator;
    }

    public BasicFilterElement(int n, Operators.Operator operator, Object object) {
        this.columnIndex = n;
        this.condOperator = operator;
        this.condValue = object;
    }

    @Override
    public FilterElement getChildAt(int n) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public Operators.Operator getCondOperator() {
        return this.condOperator;
    }

    @Override
    public Object getCondValue() {
        return this.condValue;
    }

    @Override
    public Operators.GroupOperator getGroupOperator() {
        return this.groupOperator;
    }

    @Override
    public FilterElement getParent() {
        return this.parent;
    }

    @Override
    public boolean isCondition() {
        return null != this.condOperator && null != this.condValue && -1 != this.columnIndex && null == this.groupOperator;
    }

    public void add(FilterElement filterElement) {
        if (filterElement != null && filterElement.getParent() == this) {
            this.insert(filterElement, this.getChildCount() - 1);
        } else {
            this.insert(filterElement, this.getChildCount());
        }
    }

    public void insert(FilterElement filterElement, int n) {
        if (filterElement == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(filterElement)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        BasicFilterElement basicFilterElement = (BasicFilterElement)filterElement.getParent();
        if (basicFilterElement != null) {
            basicFilterElement.remove(filterElement);
        }
        ((BasicFilterElement)filterElement).setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<BasicFilterElement>(4);
        }
        this.children.add(n, (BasicFilterElement)filterElement);
    }

    private boolean isNodeAncestor(FilterElement filterElement) {
        if (filterElement == null) {
            return false;
        }
        FilterElement filterElement2 = this;
        do {
            if (filterElement2 != filterElement) continue;
            return true;
        } while ((filterElement2 = filterElement2.getParent()) != null);
        return false;
    }

    private void setParent(FilterElement filterElement) {
        this.parent = filterElement;
    }

    protected void removeChildAt(int n) {
        BasicFilterElement basicFilterElement = (BasicFilterElement)this.getChildAt(n);
        this.children.remove(n);
        basicFilterElement.setParent(null);
    }

    public void remove(FilterElement filterElement) {
        if (filterElement == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (this.getChildCount() == 0 || filterElement.getParent() != this) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.removeChildAt(this.getIndex(filterElement));
    }

    private int getIndex(FilterElement filterElement) {
        if (filterElement == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getChildCount();
        if (n == 0 || filterElement.getParent() != this) {
            throw new IllegalArgumentException("argument is not a child");
        }
        for (int i = 0; i < n; ++i) {
            if (this.children.get(i) != filterElement) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        return 31 * ((this.children == null ? 0 : ((Object)this.children).hashCode()) + (this.groupOperator == null ? 0 : this.groupOperator.hashCode()) + (this.condOperator == null ? 0 : this.condOperator.hashCode()) + (this.condValue == null ? 0 : this.condValue.hashCode()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BasicFilterElement) {
            BasicFilterElement basicFilterElement = (BasicFilterElement)object;
            if (this.areObjectsEquals(this.children, basicFilterElement.children) && this.areObjectsEquals((Object)this.groupOperator, (Object)basicFilterElement.groupOperator) && this.areObjectsEquals((Object)this.condOperator, (Object)basicFilterElement.condOperator) && this.areObjectsEquals(this.condValue, basicFilterElement.condValue) && this.columnIndex == basicFilterElement.columnIndex) {
                return true;
            }
        }
        return false;
    }

    boolean areObjectsEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (null != object) {
            return object.equals(object2);
        }
        if (null != object2) {
            return object2.equals(object);
        }
        return false;
    }
}

